/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.internal.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.internal.impl.JavaClassImpl;

public class ArrayTypeImpl
extends JavaClassImpl
implements ArrayType,
JavaClass {
    protected static final int ARRAY_DIMENSIONS_EDEFAULT = 0;
    protected int arrayDimensions = 0;
    protected EClassifier componentType = null;
    protected JavaHelpers finalComponentType = null;

    protected ArrayTypeImpl() {
    }

    protected EClass eStaticClass() {
        return JavaRefPackage.Literals.ARRAY_TYPE;
    }

    public JavaHelpers computeComponentType() {
        String componentName = this.getQualifiedNameForReflection();
        componentName = componentName.substring(0, componentName.length() - 2);
        return JavaRefFactory.eINSTANCE.reflectType(componentName, (EObject)this);
    }

    public EClassifier getComponentType() {
        if (this.getComponentTypeGen() == null && this.getName() != null) {
            this.componentType = this.computeComponentType();
        }
        return this.getComponentTypeGen();
    }

    public JavaHelpers getComponentTypeAsHelper() {
        return (JavaHelpers)this.getComponentType();
    }

    public JavaHelpers getFinalComponentType() {
        if (this.finalComponentType == null) {
            String componentName = this.getQualifiedNameForReflection();
            componentName = componentName.substring(0, componentName.indexOf("["));
            this.finalComponentType = JavaRefFactory.eINSTANCE.reflectType(componentName, (EObject)this);
        }
        return this.finalComponentType;
    }

    public boolean isArray() {
        return true;
    }

    public boolean isPrimitiveArray() {
        return this.getFinalComponentType().isPrimitive();
    }

    public void setComponentType(JavaHelpers helperComponentType) {
        this.setComponentType((EClassifier)helperComponentType);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 38: {
                return new Integer(this.getArrayDimensions());
            }
            case 39: {
                if (resolve) {
                    return this.getComponentType();
                }
                return this.basicGetComponentType();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 38: {
                this.setArrayDimensions((Integer)newValue);
                return;
            }
            case 39: {
                this.setComponentType((EClassifier)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 38: {
                this.setArrayDimensions(0);
                return;
            }
            case 39: {
                this.setComponentType((EClassifier)null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 38: {
                return this.arrayDimensions != 0;
            }
            case 39: {
                return this.componentType != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public void setArrayDimensions(int newArrayDimensions) {
        int oldArrayDimensions = this.arrayDimensions;
        this.arrayDimensions = newArrayDimensions;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 38, oldArrayDimensions, this.arrayDimensions));
        }
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (arrayDimensions: ");
        result.append(this.arrayDimensions);
        result.append(')');
        return result.toString();
    }

    public EClassifier getComponentTypeGen() {
        if (this.componentType != null && this.componentType.eIsProxy()) {
            InternalEObject oldComponentType = (InternalEObject)this.componentType;
            this.componentType = (EClassifier)this.eResolveProxy(oldComponentType);
            if (this.componentType != oldComponentType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 39, (Object)oldComponentType, (Object)this.componentType));
            }
        }
        return this.componentType;
    }

    public EClassifier basicGetComponentType() {
        return this.componentType;
    }

    public void setComponentType(EClassifier newComponentType) {
        this.finalComponentType = null;
        this.setComponentTypeGen(newComponentType);
    }

    public void setComponentTypeGen(EClassifier newComponentType) {
        EClassifier oldComponentType = this.componentType;
        this.componentType = newComponentType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 39, (Object)oldComponentType, (Object)this.componentType));
        }
    }

    public TypeKind getKind() {
        JavaHelpers ft = this.getFinalComponentType();
        if (!ft.isPrimitive()) {
            TypeKind ftKind = ((JavaClass)ft).getKind();
            return ftKind != TypeKind.UNDEFINED_LITERAL ? TypeKind.CLASS_LITERAL : TypeKind.UNDEFINED_LITERAL;
        }
        return TypeKind.CLASS_LITERAL;
    }

    public boolean isPublic() {
        JavaHelpers ft = this.getFinalComponentType();
        if (!ft.isPrimitive()) {
            return ((JavaClass)ft).isPublic();
        }
        return true;
    }
}

