/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.ProjectUnavailableError;
import org.eclipse.wst.validation.internal.ResourceUnavailableError;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerManager {
    private Set<String> _markers = new HashSet<String>(50);

    public static MarkerManager getDefault() {
        return Singleton.markerManager;
    }

    private MarkerManager() {
        this._markers.add("org.eclipse.wst.validation.problemmarker2");
        this._markers.add("org.eclipse.wst.validation.problemmarker");
    }

    public void clearMarker(IResource resource, Validator validator) throws CoreException {
        if (resource == null) {
            return;
        }
        this.hook(resource);
        String id = validator.getMarkerId();
        if (id != null) {
            try {
                resource.deleteMarkers(id, true, 0);
            }
            catch (CoreException coreException) {}
            return;
        }
        IMarker[] markers = resource.findMarkers("org.eclipse.wst.validation.problemmarker2", true, 0);
        String valId = validator.getId();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            id = marker.getAttribute("ValidationId", null);
            if (valId.equals(id)) {
                marker.delete();
            }
            ++n2;
        }
    }

    public void createMarker(ValidatorMessage m, String id) {
        try {
            IResource resource = m.getResource();
            this.hook(resource);
            IMarker marker = resource.createMarker(m.getType());
            Map map = m.getAttributes();
            if (map.get("ValidationId") == null) {
                map.put("ValidationId", id);
            }
            marker.setAttributes(map);
        }
        catch (CoreException e) {
            if (!m.getResource().exists()) {
                throw new ResourceUnavailableError(m.getResource());
            }
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public void deleteMarkers(IResource resource, long operationStartTime, int depth) {
        try {
            IMarker[] markers;
            this.hook(resource);
            IMarker[] iMarkerArray = markers = resource.findMarkers(null, true, depth);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                long createTime;
                IMarker marker = iMarkerArray[n2];
                if (this._markers.contains(marker.getType()) && (createTime = marker.getCreationTime()) < operationStartTime) {
                    try {
                        marker.delete();
                    }
                    catch (CoreException coreException) {}
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            IProject project = resource.getProject();
            if (!project.exists() || !project.isOpen()) {
                throw new ProjectUnavailableError(project);
            }
            if (!resource.exists()) {
                throw new ResourceUnavailableError(resource);
            }
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public void makeMarkers(List<IMessage> list) {
        for (IMessage message : list) {
            IResource res = null;
            Object target = message.getTargetObject();
            if (target != null && target instanceof IResource) {
                res = (IResource)target;
            }
            if (res == null && (target = message.getAttribute("TargetResource")) != null && target instanceof IResource) {
                res = (IResource)target;
            }
            if (res == null) continue;
            try {
                this.hook(res);
                String id = message.getMarkerId();
                if (id == null) {
                    id = "org.eclipse.wst.validation.problemmarker";
                }
                IMarker marker = res.createMarker(id);
                marker.setAttributes((Map)message.getAttributes());
                marker.setAttribute("message", (Object)message.getText());
                int markerSeverity = 0;
                int sev = message.getSeverity();
                if ((sev & 1) != 0) {
                    markerSeverity = 2;
                } else if ((sev & 2) != 0) {
                    markerSeverity = 1;
                }
                marker.setAttribute("severity", markerSeverity);
                marker.setAttribute("lineNumber", message.getLineNumber());
            }
            catch (CoreException e) {
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
    }

    public void hook(IResource resource) {
    }

    public Set<String> getMarkers() {
        return this._markers;
    }

    /* synthetic */ MarkerManager(MarkerManager markerManager) {
        this();
    }

    private static class Singleton {
        static MarkerManager markerManager = new MarkerManager(null);

        private Singleton() {
        }
    }
}

