/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.internal.archive.ArchiveWrapper;
import org.eclipse.jst.j2ee.internal.archive.ComponentArchiveSaveAdapter;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.OverwriteHandlerException;
import org.eclipse.jst.j2ee.internal.common.classpath.J2EEComponentClasspathUpdater;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.jst.jee.archive.ArchiveOptions;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveFactory;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;

public abstract class J2EEArtifactImportOperation
extends AbstractDataModelOperation {
    protected Archive moduleFile;
    protected ArchiveWrapper archiveWrapper;
    protected IVirtualComponent virtualComponent;
    protected IAdaptable info;
    protected final int PROJECT_CREATION_WORK = 30;
    private static IArchiveFactory archiveFactory = IArchiveFactory.INSTANCE;

    public J2EEArtifactImportOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable anInfo) throws ExecutionException {
        try {
            J2EEComponentClasspathUpdater.getInstance().pauseUpdates();
            this.info = anInfo;
            this.moduleFile = (Archive)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.FILE");
            this.archiveWrapper = (ArchiveWrapper)this.model.getProperty("IJ2EEComponentImportDataModelProperties.ARCHIVE_WRAPPER");
            monitor.beginTask(ProjectSupportResourceHandler.getString(ProjectSupportResourceHandler.Importing_archive, new Object[]{this.archiveWrapper.getPath()}), this.computeTotalWork());
            this.doExecute(monitor);
            IStatus iStatus = OK_STATUS;
            return iStatus;
        }
        finally {
            try {
                if (this.virtualComponent != null) {
                    J2EEComponentClasspathUpdater.getInstance().queueUpdate(this.virtualComponent.getProject());
                }
            }
            finally {
                J2EEComponentClasspathUpdater.getInstance().resumeUpdates();
                this.model.dispose();
                monitor.done();
            }
        }
    }

    protected int computeTotalWork() {
        return 30 + this.archiveWrapper.getSize();
    }

    protected void doExecute(IProgressMonitor monitor) throws ExecutionException {
        IDataModel nestedModel = this.model.getNestedModel("IJ2EEArtifactImportDataModelProperties.NESTED_MODEL_J2EE_COMPONENT_CREATION");
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 30);
        this.virtualComponent = this.createVirtualComponent(nestedModel, (IProgressMonitor)subMonitor);
        try {
            this.importModuleFile((IProgressMonitor)new SubProgressMonitor(monitor, this.archiveWrapper.getSize()));
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    protected IVirtualComponent createVirtualComponent(IDataModel aModel, IProgressMonitor monitor) throws ExecutionException {
        try {
            aModel.getDefaultOperation().execute(monitor, this.info);
            String projectName = aModel.getStringProperty("IFacetDataModelProperties.FACET_PROJECT_NAME");
            IProject project = ProjectUtilities.getProject((String)projectName);
            IVirtualComponent iVirtualComponent = ComponentCore.createComponent((IProject)project);
            return iVirtualComponent;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract SaveStrategy createSaveStrategy(IVirtualComponent var1);

    protected void modifyStrategy(SaveStrategy saveStrat) {
    }

    protected ComponentArchiveSaveAdapter getArchiveSaveAdapter(IVirtualComponent virtualComponent) {
        return new ComponentArchiveSaveAdapter(virtualComponent);
    }

    protected void importModuleFile(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            try {
                monitor.beginTask(null, this.archiveWrapper.getSize());
                if (this.archiveWrapper.getIArchive() != null) {
                    IArchive archive = this.archiveWrapper.getIArchive();
                    ComponentArchiveSaveAdapter adap = this.getArchiveSaveAdapter(this.virtualComponent);
                    ArchiveOptions saveOptions = new ArchiveOptions();
                    saveOptions.setOption((Object)"SAVE_ADAPTER", (Object)adap);
                    archiveFactory.saveArchive(archive, saveOptions, monitor);
                } else {
                    ComponentSaveStrategyImpl aStrategy = (ComponentSaveStrategyImpl)this.createSaveStrategy(this.virtualComponent);
                    aStrategy.setProgressMonitor(monitor);
                    aStrategy.setOverwriteHandler((IOverwriteHandler)this.model.getProperty("IJ2EEArtifactImportDataModelProperties.OVERWRITE_HANDLER"));
                    aStrategy.setDataModel(this.model);
                    this.modifyStrategy((SaveStrategy)aStrategy);
                    this.archiveWrapper.getCommonArchive().save((SaveStrategy)aStrategy);
                }
            }
            catch (OverwriteHandlerException overwriteHandlerException) {
                throw new InterruptedException();
            }
            catch (Exception ex) {
                throw new WFTWrappedException((Throwable)ex, EJBArchiveOpsResourceHandler.ERROR_IMPORTING_MODULE_FILE);
            }
        }
        finally {
            monitor.done();
        }
    }
}

