/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.text;

import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xsd.ui.internal.util.ModelReconcileAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDModelReconcileAdapter
extends ModelReconcileAdapter {
    protected XSDSchema schema;

    public XSDModelReconcileAdapter(Document document, XSDSchema schema) {
        super(document);
        this.schema = schema;
    }

    protected void handleNodeChanged(Node node) {
        try {
            if (!this.shouldReconcileModelFor(node)) {
                return;
            }
        }
        catch (Exception exception) {}
        if (node instanceof Element) {
            XSDConcreteComponent concreteComponent = this.schema.getCorrespondingComponent(node);
            concreteComponent.elementChanged((Element)node);
        } else if (node instanceof Document) {
            Document document = (Document)node;
            Element schemaElement = document.getDocumentElement();
            if (schemaElement != null && schemaElement != this.schema.getElement()) {
                if (schemaElement.getLocalName().equals("schema")) {
                    this.schema.setElement(schemaElement);
                }
            } else if (schemaElement != null) {
                this.schema.elementChanged(schemaElement);
            } else if (schemaElement == null) {
                this.schema.getContents().clear();
                this.schema.getElementDeclarations().clear();
                this.schema.getTypeDefinitions().clear();
                this.schema.getAttributeDeclarations().clear();
                this.schema.getModelGroupDefinitions().clear();
                this.schema.getAttributeGroupDefinitions().clear();
                this.schema.setElement(null);
            }
        }
    }

    protected boolean shouldReconcileModelFor(Node changedNode) {
        String nodeName;
        String nodeNamespace = changedNode.getNamespaceURI();
        String schemaNamespace = this.schema.getSchemaForSchemaNamespace();
        if (!schemaNamespace.equals(nodeNamespace)) {
            return false;
        }
        Node parentNode = changedNode.getParentNode();
        return parentNode == null || !"appinfo".equals(nodeName = changedNode.getLocalName()) && !"documentation".equals(nodeName);
    }

    public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
    }
}

