/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public abstract class SelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    private ISelection selection;
    private Object model;

    protected SelectionDispatchAction(ISelection selection) {
        Assert.isNotNull((Object)selection);
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void update(ISelection selection) {
        this.dispatchSelectionChanged(selection);
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object object = selection.getFirstElement();
            this.setEnabled(this.canEnable(object));
        } else {
            this.setEnabled(false);
        }
    }

    protected boolean canEnable(Object selectedObject) {
        return false;
    }

    public void run(IStructuredSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ITextSelection selection) {
        this.selectionChanged((ISelection)selection);
    }

    public void run(ITextSelection selection) {
        this.run((ISelection)selection);
    }

    public void selectionChanged(ISelection selection) {
        this.setEnabled(false);
    }

    public void run(ISelection selection) {
    }

    public void run() {
        this.dispatchRun(this.getSelection());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.dispatchSelectionChanged(event.getSelection());
    }

    private void dispatchSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selectionChanged((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.selectionChanged((ITextSelection)selection);
        } else {
            this.selectionChanged(selection);
        }
    }

    protected void dispatchRun(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            this.run(selection);
        }
    }

    public final Object getModel() {
        return this.model;
    }

    public final void setModel(Object model) {
        this.model = model;
    }

    public boolean canRun() {
        return true;
    }
}

