/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.editor.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.core.search.SearchMatch;
import org.eclipse.wst.common.core.search.pattern.QualifiedName;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.common.ui.internal.search.dialogs.IComponentDescriptionProvider;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.search.IXSDSearchConstants;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class XSDComponentDescriptionProvider
extends LabelProvider
implements IComponentDescriptionProvider {
    private static final Image SIMPLE_TYPE_IMAGE = XSDEditorPlugin.getXSDImage("icons/XSDSimpleType.gif");
    private static final Image COMPLEX_TYPE_IMAGE = XSDEditorPlugin.getXSDImage("icons/XSDComplexType.gif");
    private static final Image ELEMENT_IMAGE = XSDEditorPlugin.getXSDImage("icons/XSDElement.gif");

    public boolean isApplicable(Object component) {
        return true;
    }

    public String getQualifier(Object component) {
        QualifiedName qualifiedName;
        String result = null;
        if (component instanceof ComponentSpecification) {
            result = ((ComponentSpecification)component).getQualifier();
        } else if (component instanceof XSDNamedComponent) {
            result = ((XSDNamedComponent)component).getTargetNamespace();
        } else if (component instanceof SearchMatch && (qualifiedName = this.getQualifiedNameForSearchMatch((SearchMatch)component)) != null) {
            result = qualifiedName.getNamespace();
        }
        return result;
    }

    private QualifiedName getQualifiedNameForSearchMatch(SearchMatch match) {
        QualifiedName qualifiedName = null;
        Object o = match.map.get("name");
        if (o != null && o instanceof QualifiedName) {
            qualifiedName = (QualifiedName)o;
        }
        return qualifiedName;
    }

    public String getName(Object component) {
        QualifiedName qualifiedName;
        String result = null;
        if (component instanceof ComponentSpecification) {
            result = ((ComponentSpecification)component).getName();
        } else if (component instanceof XSDNamedComponent) {
            result = ((XSDNamedComponent)component).getName();
        } else if (component instanceof SearchMatch && (qualifiedName = this.getQualifiedNameForSearchMatch((SearchMatch)component)) != null) {
            result = qualifiedName.getLocalName();
        }
        return result;
    }

    public IFile getFile(Object component) {
        XSDConcreteComponent concreteComponent;
        XSDSchema schema;
        IFile result = null;
        if (component instanceof ComponentSpecification) {
            result = ((ComponentSpecification)component).getFile();
        } else if (component instanceof SearchMatch) {
            result = ((SearchMatch)component).getFile();
        } else if (component instanceof XSDConcreteComponent && (schema = (concreteComponent = (XSDConcreteComponent)component).getSchema()) != null) {
            String location = schema.getSchemaLocation();
            String platformResource = "platform:/resource";
            if (location != null && location.startsWith(platformResource)) {
                Path path = new Path(location.substring(platformResource.length()));
                result = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
            }
        }
        return result;
    }

    public ILabelProvider getLabelProvider() {
        return this;
    }

    public String getText(Object element) {
        String result = "";
        String name = this.getName(element);
        if (name != null) {
            result = String.valueOf(result) + name;
        }
        return result;
    }

    public Image getImage(Object component) {
        Image result = null;
        if (component instanceof SearchMatch) {
            SearchMatch searchMatch = (SearchMatch)component;
            QualifiedName qualifiedName = (QualifiedName)searchMatch.map.get("metaName");
            if (qualifiedName != null) {
                if (qualifiedName.equals((Object)IXSDSearchConstants.SIMPLE_TYPE_META_NAME)) {
                    result = SIMPLE_TYPE_IMAGE;
                } else if (qualifiedName.equals((Object)IXSDSearchConstants.COMPLEX_TYPE_META_NAME)) {
                    result = COMPLEX_TYPE_IMAGE;
                } else if (qualifiedName.equals((Object)IXSDSearchConstants.ELEMENT_META_NAME)) {
                    result = ELEMENT_IMAGE;
                }
            }
        } else if (component instanceof XSDComplexTypeDefinition) {
            result = COMPLEX_TYPE_IMAGE;
        } else if (component instanceof XSDSimpleTypeDefinition) {
            result = SIMPLE_TYPE_IMAGE;
        } else if (component instanceof XSDElementDeclaration) {
            result = ELEMENT_IMAGE;
        }
        return result;
    }

    public Image getFileIcon(Object component) {
        return XSDEditorPlugin.getXSDImage("icons/XSDFile.gif");
    }
}

