/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.properties.sections;

import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.xsd.ui.internal.common.commands.UpdateAttributeValueCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.AbstractSection;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;

public class XSDComplexTypeAdvancedSection
extends AbstractSection {
    private static final String EMPTY = "";
    private static final String FALSE = "false";
    private static final String TRUE = "true";
    protected CCombo blockCombo;
    protected CCombo finalCombo;
    private String[] finalValues = new String[]{"", "restriction", "extension", "#all"};
    private String[] blockValues = new String[]{"", "restriction", "extension", "#all"};
    private String[] abstractValues = new String[]{"", "true", "false"};
    private CCombo abstractCombo;

    protected void createContents(Composite parent) {
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel blockLabel = this.getWidgetFactory().createCLabel(this.composite, "block:");
        blockLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.blockCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.blockCombo.setLayoutData((Object)data);
        this.blockCombo.setEditable(false);
        this.blockCombo.setItems(this.blockValues);
        this.blockCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel finalLabel = this.getWidgetFactory().createCLabel(this.composite, "final:");
        finalLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.finalCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.finalCombo.setLayoutData((Object)data);
        this.finalCombo.setEditable(false);
        this.finalCombo.setItems(this.finalValues);
        this.finalCombo.addSelectionListener((SelectionListener)this);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        CLabel abstractLabel = this.getWidgetFactory().createCLabel(this.composite, "abstract:");
        abstractLabel.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.abstractCombo = this.getWidgetFactory().createCCombo(this.composite);
        this.abstractCombo.setLayoutData((Object)data);
        this.abstractCombo.setEditable(false);
        this.abstractCombo.setItems(this.abstractValues);
        this.abstractCombo.addSelectionListener((SelectionListener)this);
    }

    public void doWidgetSelected(SelectionEvent e) {
        if (e.widget == this.blockCombo) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
            String value = this.blockCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(complexType.getElement(), "block", value);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.finalCombo) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
            String value = this.finalCombo.getText();
            UpdateAttributeValueCommand command = new UpdateAttributeValueCommand(complexType.getElement(), "final", value);
            command.setDeleteIfEmpty(true);
            this.getCommandStack().execute((Command)command);
        } else if (e.widget == this.abstractCombo) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
            String value = this.abstractCombo.getText();
            if (value.equals(EMPTY)) {
                complexType.getElement().removeAttribute("abstract");
            } else if (value.equals(TRUE)) {
                complexType.setAbstract(true);
            } else if (value.equals(FALSE)) {
                complexType.setAbstract(false);
            }
        }
    }

    public void refresh() {
        super.refresh();
        this.setListenerEnabled(false);
        try {
            if (this.input instanceof XSDComplexTypeDefinition) {
                XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)this.input;
                if (complexType.getContainer() instanceof XSDSchema) {
                    this.composite.setEnabled(!this.isReadOnly);
                } else {
                    this.composite.setEnabled(false);
                }
                String blockAttValue = complexType.getElement().getAttribute("block");
                if (blockAttValue != null) {
                    this.blockCombo.setText(blockAttValue);
                } else {
                    this.blockCombo.setText(EMPTY);
                }
                String finalAttValue = complexType.getElement().getAttribute("final");
                if (finalAttValue != null) {
                    this.finalCombo.setText(finalAttValue);
                } else {
                    this.finalCombo.setText(EMPTY);
                }
                if (complexType.getElement().hasAttribute("abstract")) {
                    boolean absAttValue = complexType.isAbstract();
                    if (absAttValue) {
                        this.abstractCombo.setText(TRUE);
                    } else {
                        this.abstractCombo.setText(FALSE);
                    }
                } else {
                    this.abstractCombo.setText(EMPTY);
                }
            }
        }
        catch (Exception exception) {}
        this.setListenerEnabled(true);
    }
}

