/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;

public class JDOMClassFinder {
    private static JDOMClassFinder instance;

    protected IPath getBinaryPathFromQualifiedName(String qualifiedName) {
        return new Path(String.valueOf(qualifiedName.replace('.', File.separatorChar)) + ".class");
    }

    public IType getBinaryType(String qualifiedName) {
        try {
            IJavaElement found = this.getJavaElement(qualifiedName);
            return ((IClassFile)found).getType();
        }
        catch (JavaModelException jme) {
            System.out.println(ResourceHandler.getString((String)"Error_Looking_Up_Type_ERROR_", (Object[])new Object[]{qualifiedName, jme.getMessage()}));
            return null;
        }
    }

    public IJavaElement getJavaElement(String qualifiedName) {
        try {
            if (this.getSourceProject() != null) {
                return this.getSourceProject().findElement(this.getPathFromQualifiedName(qualifiedName));
            }
        }
        catch (JavaModelException jme) {
            System.out.println(ResourceHandler.getString((String)"Error_Looking_Up_Type_ERROR_", (Object[])new Object[]{qualifiedName, jme.getMessage()}));
        }
        return null;
    }

    protected IPath getPathFromQualifiedName(String qualifiedName) {
        return new Path(String.valueOf(qualifiedName.replace('.', File.separatorChar)) + ".java");
    }

    protected IJavaProject getSourceProject() {
        return null;
    }

    public IType getType(String qualifiedName) {
        try {
            IJavaElement found = this.getJavaElement(qualifiedName);
            if (found != null) {
                if (found instanceof IClassFile) {
                    return ((IClassFile)found).getType();
                }
                if (found instanceof ICompilationUnit) {
                    ICompilationUnit foundCU = (ICompilationUnit)found;
                    String cuMainTypeName = foundCU.getElementName();
                    cuMainTypeName = cuMainTypeName.substring(0, cuMainTypeName.length() - 5);
                    return foundCU.getType(cuMainTypeName);
                }
            }
        }
        catch (JavaModelException jme) {
            System.out.println(ResourceHandler.getString((String)"Error_Looking_Up_Type_ERROR_", (Object[])new Object[]{qualifiedName, jme.getMessage()}));
        }
        return null;
    }

    public static JDOMClassFinder instance() {
        if (instance == null) {
            instance = new JDOMClassFinder();
        }
        return instance;
    }
}

