/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte.jdbc;

import com.ibm.icu.util.StringTokenizer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.core.rte.jdbc.JDBCSchema;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.DatabaseImpl;

public class JDBCDatabase
extends DatabaseImpl
implements ICatalogObject {
    private Connection connection;
    private boolean schemasLoaded = false;

    public JDBCDatabase(Connection connection) {
        if (connection == null) {
            System.err.println("null connection");
            throw new RuntimeException();
        }
        this.connection = connection;
    }

    public synchronized void refresh() {
        if (this.schemasLoaded) {
            this.schemasLoaded = false;
            this.schemas.clear();
        }
        RefreshManager.getInstance().referesh(this);
    }

    public EList getSchemas() {
        if (!this.schemasLoaded) {
            this.loadSchemas();
        }
        return this.schemas;
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Database getCatalogDatabase() {
        return this;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 9) {
            this.getSchemas();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadSchemas() {
        if (this.schemasLoaded) {
            return;
        }
        this.schemasLoaded = true;
        EList schemaList = super.getSchemas();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        try {
            DatabaseMetaData metaData = this.connection.getMetaData();
            boolean supportSchema = metaData.supportsSchemasInTableDefinitions();
            if (!supportSchema) {
                JDBCSchema schema = new JDBCSchema();
                schema.setName(this.getName());
                schemaList.add((Object)schema);
                return;
            }
            ConnectionInfo connectionInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo((SQLObject)this);
            ConnectionFilter filter = connectionInfo.getFilter(String.valueOf(this.getName()) + "::" + "DatatoolsSchemaFilterPredicate");
            if (filter == null) {
                filter = connectionInfo.getFilter("DatatoolsSchemaFilterPredicate");
            }
            String[] schemaAry = null;
            String pattern = null;
            if (filter != null) {
                String schemaFilter = filter.getPredicate();
                if ((schemaFilter = schemaFilter.replaceAll(" ", "")).startsWith("IN(")) {
                    schemaFilter = schemaFilter.substring(3, schemaFilter.length() - 1);
                    schemaFilter = schemaFilter.replaceAll(",", "");
                    schemaAry = this.parseINClause(schemaFilter);
                }
                if (schemaFilter.startsWith("LIKE")) {
                    pattern = this.parseLikeClause(schemaFilter);
                }
            }
            ResultSet r = metaData.getSchemas();
            while (r.next()) {
                String schemaName = r.getString(1);
                if (schemaAry != null) {
                    boolean found = false;
                    int i = 0;
                    while (i < schemaAry.length) {
                        if (schemaName.equals(schemaAry[i])) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) continue;
                }
                if (pattern != null && (pattern.indexOf("%") == 0 && pattern.endsWith("%") ? schemaName.indexOf(pattern.substring(1, pattern.length() - 1)) == -1 : (pattern.indexOf("%") == 0 ? !schemaName.endsWith(pattern.substring(1)) : !schemaName.startsWith(pattern.substring(0, pattern.length() - 1))))) continue;
                JDBCSchema schema = new JDBCSchema();
                schema.setName(schemaName);
                schemaList.add((Object)schema);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.eSetDeliver(deliver);
    }

    protected String[] parseINClause(String toParse) {
        StringTokenizer tokenizer = new StringTokenizer(toParse, "'");
        Vector<String> list = new Vector<String>();
        if (tokenizer.countTokens() >= 1) {
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        String[] retStrList = null;
        if (list.size() > 0) {
            retStrList = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                retStrList[i] = (String)list.get(i);
                ++i;
            }
        }
        return retStrList;
    }

    protected String parseLikeClause(String toParse) {
        String retString = toParse.substring(toParse.indexOf("'") + 1, toParse.length() - 1);
        return retString;
    }
}

