/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.resources;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.internal.HashUtil;

public class VirtualArchiveComponent
implements IVirtualComponent,
IAdaptable {
    public static final Class ADAPTER_TYPE;
    public static final String LIBARCHIVETYPE = "lib";
    public static final String VARARCHIVETYPE = "var";
    private static final IVirtualReference[] NO_REFERENCES;
    private static final IVirtualComponent[] NO_COMPONENTS;
    private static final IResource[] NO_RESOURCES;
    private static final IVirtualResource[] NO_VIRTUAL_RESOURCES;
    private static final Properties NO_PROPERTIES;
    private static final IPath[] NO_PATHS;
    private IPath runtimePath;
    private IProject componentProject;
    private IVirtualFolder rootFolder;
    private int flag = 1;
    private String archiveLocation;
    private IPath archivePath;
    private String archiveType;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ADAPTER_TYPE = clazz;
        NO_REFERENCES = new VirtualReference[0];
        NO_COMPONENTS = new VirtualComponent[0];
        NO_RESOURCES = null;
        NO_VIRTUAL_RESOURCES = null;
        NO_PROPERTIES = new Properties();
        NO_PATHS = new Path[0];
    }

    public VirtualArchiveComponent(IProject aComponentProject, String archiveLocation, IPath aRuntimePath) {
        if (aComponentProject == null) {
            throw new NullPointerException();
        }
        this.componentProject = aComponentProject;
        this.runtimePath = aRuntimePath;
        String archivePathString = archiveLocation.substring(4, archiveLocation.length());
        this.archiveType = archiveLocation.substring(0, archiveLocation.length() - archivePathString.length() - 1);
        this.archivePath = new Path(archivePathString);
    }

    public IVirtualComponent getComponent() {
        return this;
    }

    public String getName() {
        return String.valueOf(this.archiveType) + '/' + this.archivePath.toString();
    }

    public String getDeployedName() {
        return this.getName();
    }

    public void setComponentTypeId(String aComponentTypeId) {
    }

    public int getType() {
        return 64;
    }

    public boolean isBinary() {
        boolean ret = (this.flag & 1) == 1;
        return ret;
    }

    public IPath[] getMetaResources() {
        return NO_PATHS;
    }

    public void setMetaResources(IPath[] theMetaResourcePaths) {
    }

    public void delete(int updateFlags, IProgressMonitor monitor) throws CoreException {
    }

    public String getFileExtension() {
        return this.archivePath.getFileExtension();
    }

    public IPath getWorkspaceRelativePath() {
        IFile aFile;
        if (this.archivePath.segmentCount() > 1 && (aFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.archivePath)).exists()) {
            return aFile.getFullPath();
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        IFile aFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getWorkspaceRelativePath());
        if (aFile.exists()) {
            return aFile.getProjectRelativePath();
        }
        return null;
    }

    public IProject getProject() {
        return this.componentProject;
    }

    public IPath getRuntimePath() {
        return ROOT;
    }

    public boolean isAccessible() {
        return true;
    }

    public Properties getMetaProperties() {
        return NO_PROPERTIES;
    }

    public IVirtualResource[] getResources(String aResourceType) {
        return NO_VIRTUAL_RESOURCES;
    }

    public void create(int updateFlags, IProgressMonitor aMonitor) throws CoreException {
    }

    public IVirtualReference[] getReferences() {
        return NO_REFERENCES;
    }

    public void setReferences(IVirtualReference[] theReferences) {
    }

    public void addReferences(IVirtualReference[] references) {
    }

    public IVirtualReference getReference(String aComponentName) {
        return null;
    }

    public boolean exists() {
        IFile utilityJar;
        boolean exists = false;
        File diskFile = this.getUnderlyingDiskFile();
        if (diskFile != null) {
            exists = diskFile.exists();
        }
        if (!exists && (utilityJar = this.getUnderlyingWorkbenchFile()) != null) {
            exists = utilityJar.exists();
        }
        return exists;
    }

    public IVirtualFolder getRootFolder() {
        return null;
    }

    public IVirtualComponent[] getReferencingComponents() {
        return NO_COMPONENTS;
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public String getArchiveType() {
        return this.archiveType;
    }

    public int hashCode() {
        int hash = HashUtil.SEED;
        hash = HashUtil.hash((int)hash, (Object)this.getProject().getName());
        hash = HashUtil.hash((int)hash, (Object)this.getName());
        hash = HashUtil.hash((int)hash, (boolean)this.isBinary());
        return hash;
    }

    public boolean equals(Object anOther) {
        if (anOther instanceof VirtualArchiveComponent) {
            VirtualArchiveComponent otherComponent = (VirtualArchiveComponent)anOther;
            return this.getProject().equals((Object)otherComponent.getProject()) && this.getName().equals(otherComponent.getName()) && this.isBinary() == otherComponent.isBinary();
        }
        return false;
    }

    public void setMetaProperty(String name, String value) {
    }

    public void setMetaProperties(Properties properties) {
    }

    public IFile getUnderlyingWorkbenchFile() {
        if (this.getWorkspaceRelativePath() == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getWorkspaceRelativePath());
    }

    public File getUnderlyingDiskFile() {
        String osPath = null;
        IPath loc = null;
        if (this.getArchiveType().equals(VARARCHIVETYPE)) {
            Object adapted = this.getAdapter(ADAPTER_TYPE);
            if (adapted instanceof IPath) {
                IPath resolvedpath = (IPath)adapted;
                osPath = resolvedpath.toOSString();
            }
        } else if (!this.archivePath.isAbsolute()) {
            IFile file = this.getProject().getFile(this.archivePath);
            if (file.exists()) {
                loc = file.getLocation();
            } else if (this.archivePath.segmentCount() >= 2 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.archivePath)).exists()) {
                loc = file.getLocation();
            }
            if (loc != null) {
                osPath = loc.toOSString();
            }
        } else {
            osPath = this.archivePath.toOSString();
        }
        if (osPath == null || osPath.length() == 0) {
            return null;
        }
        File diskFile = new File(osPath);
        return diskFile;
    }

    public String toString() {
        if (this.archivePath != null) {
            return this.componentProject + " " + this.archivePath;
        }
        return super.toString();
    }
}

