/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emfworkbench;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModel;

public class EditModelLeastUsedCache {
    private static EditModelLeastUsedCache INSTANCE = new EditModelLeastUsedCache();
    private static final int threshhold = 10;
    private LinkedHashSet lru = new LinkedHashSet(10);

    public static EditModelLeastUsedCache getInstance() {
        return INSTANCE;
    }

    public void removeAllCached(Collection aCollection) {
        if (aCollection != null) {
            this.lru.removeAll(aCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void access(EditModel editModel) {
        boolean shouldAccess = true;
        LinkedHashSet linkedHashSet = this.lru;
        synchronized (linkedHashSet) {
            if (this.lru.contains(editModel)) {
                this.moveToEnd(editModel);
                shouldAccess = false;
            }
        }
        if (shouldAccess) {
            linkedHashSet = this.lru;
            synchronized (linkedHashSet) {
                editModel.access(this);
                this.lru.add(editModel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeLRUSizeIfNecessary() {
        EditModel model = null;
        LinkedHashSet linkedHashSet = this.lru;
        synchronized (linkedHashSet) {
            Iterator iterator;
            if (this.lru.size() > 10 && (model = (EditModel)(iterator = this.lru.iterator()).next()) != null) {
                this.lru.remove(model);
            }
            if (model != null) {
                model.releaseAccess(this);
            }
        }
    }

    private void moveToEnd(EditModel editModel) {
        this.lru.remove(editModel);
        this.lru.add(editModel);
    }
}

