/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.jsp.core.internal.JSPCoreMessages;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentproperties.JSPFContentProperties;
import org.eclipse.jst.jsp.core.internal.provisional.contenttype.ContentTypeIdForJSP;
import org.eclipse.jst.jsp.core.internal.validation.JSPActionValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPDirectiveValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPELValidator;
import org.eclipse.jst.jsp.core.internal.validation.JSPJavaValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public final class JSPBatchValidator
implements IValidatorJob,
IExecutableExtension {
    private static final String PLUGIN_ID_JSP_CORE = "org.eclipse.jst.jsp.core";
    static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/debug/jspvalidator"));
    private IContentType fJSPFContentType = null;
    private JSPDirectiveValidator directiveValidator = new JSPDirectiveValidator((IValidator)this);
    private JSPELValidator elValidator = new JSPELValidator((IValidator)this);
    private JSPJavaValidator jspJavaValidator = new JSPJavaValidator((IValidator)this);
    private JSPActionValidator fJSPActionValidator = new JSPActionValidator((IValidator)this);
    String[] fAdditionalContentTypesIDs = null;
    static /* synthetic */ Class class$0;

    public void cleanup(IReporter reporter) {
        this.directiveValidator.cleanup(reporter);
        this.elValidator.cleanup(reporter);
        this.jspJavaValidator.cleanup(reporter);
        this.fJSPActionValidator.cleanup(reporter);
    }

    void doValidate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block11: {
            JSPFileVisitor visitor;
            block9: {
                block10: {
                    String[] uris = helper.getURIs();
                    if (uris.length <= 0) break block10;
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile currentFile = null;
                    int i = 0;
                    while (i < uris.length && !reporter.isCancelled()) {
                        currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                        if (currentFile != null && currentFile.exists()) {
                            if (this.shouldValidate(currentFile) && this.fragmentCheck(currentFile)) {
                                LocalizedMessage message = new LocalizedMessage(4, NLS.bind((String)JSPCoreMessages.MESSAGE_JSP_VALIDATING_MESSAGE_UI_, (Object[])new String[]{currentFile.getFullPath().toString()}));
                                reporter.displaySubtask((IValidator)this, (IMessage)message);
                                this.validateFile(currentFile, reporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + uris[i] + "]");
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                if (!(helper instanceof IWorkbenchContext)) break block11;
                IProject project = ((IWorkbenchContext)helper).getProject();
                visitor = new JSPFileVisitor(reporter);
                try {
                    project.accept((IResourceProxyVisitor)visitor, 2);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            IFile[] files = visitor.getFiles();
            int i = 0;
            while (i < files.length && !reporter.isCancelled()) {
                if (this.shouldValidate(files[i]) && this.fragmentCheck(files[i])) {
                    LocalizedMessage message = new LocalizedMessage(4, NLS.bind((String)JSPCoreMessages.MESSAGE_JSP_VALIDATING_MESSAGE_UI_, (Object[])new String[]{files[i].getFullPath().toString()}));
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                    this.validateFile(files[i], reporter);
                }
                if (DEBUG) {
                    System.out.println("validating: [" + files[i] + "]");
                }
                ++i;
            }
        }
    }

    private boolean fragmentCheck(IFile file) {
        boolean shouldValidateFragments;
        boolean shouldValidate = true;
        if (this.getJSPFContentType().isAssociatedWith(file.getName()) && !(shouldValidateFragments = Boolean.valueOf(JSPFContentProperties.getProperty("validateFragments", (IResource)file, true)).booleanValue())) {
            boolean isFragment = this.isFragment(file);
            shouldValidate = !isFragment;
        }
        return shouldValidate;
    }

    private IContentType getJSPFContentType() {
        if (this.fJSPFContentType == null) {
            this.fJSPFContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT);
        }
        return this.fJSPFContentType;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        if (helper instanceof IWorkbenchContext) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        }
        return null;
    }

    static boolean isBatchValidatorPreferenceEnabled(IFile file) {
        if (file == null) {
            return true;
        }
        boolean enabled = true;
        ProjectConfiguration configuration = JSPBatchValidator.getProjectConfiguration(file);
        if (configuration != null) {
            ValidationRegistryReader validationRegistryReader = ValidationRegistryReader.getReader();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.validation.JSPBatchValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ValidatorMetaData metadata = validationRegistryReader.getValidatorMetaData(clazz.getName());
            if (configuration != null && metadata != null && !configuration.isBuildEnabled(metadata) && !configuration.isManualEnabled(metadata)) {
                enabled = false;
            }
        }
        return enabled;
    }

    private static ProjectConfiguration getProjectConfiguration(IFile file) {
        IProject project;
        ProjectConfiguration projectConfiguration = null;
        if (file != null && (project = file.getProject()) != null) {
            try {
                projectConfiguration = ConfigurationManager.getManager().getProjectConfiguration(project);
            }
            catch (InvocationTargetException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return projectConfiguration;
    }

    /*
     * Exception decompiling
     */
    private boolean isFragment(IFile file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 127->130)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void performValidation(IFile f, IReporter reporter, IStructuredModel model) {
        if (!reporter.isCancelled()) {
            this.directiveValidator.performValidation(f, reporter, model.getStructuredDocument());
        }
        if (!reporter.isCancelled()) {
            this.elValidator.performValidation(f, reporter, model.getStructuredDocument());
        }
        if (!reporter.isCancelled()) {
            this.jspJavaValidator.performValidation(f, reporter, model);
        }
        if (!reporter.isCancelled()) {
            this.fJSPActionValidator.performValidation(f, reporter, model);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fAdditionalContentTypesIDs = new String[0];
        if (data != null && data instanceof String && data.toString().length() > 0) {
            this.fAdditionalContentTypesIDs = StringUtils.unpack((String)data.toString());
        }
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.doValidate(helper, reporter);
    }

    /*
     * Exception decompiling
     */
    void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 92->96)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IStatus validateInJob(final IValidationContext helper, final IReporter reporter) throws ValidationException {
        IStatus status = Status.OK_STATUS;
        Job currentJob = Platform.getJobManager().currentJob();
        ISchedulingRule rule = null;
        if (currentJob != null) {
            rule = currentJob.getRule();
        }
        IWorkspaceRunnable validationRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    JSPBatchValidator.this.doValidate(helper, reporter);
                }
                catch (ValidationException e) {
                    throw new CoreException((IStatus)new Status(4, JSPBatchValidator.PLUGIN_ID_JSP_CORE, 0, JSPBatchValidator.PLUGIN_ID_JSP_CORE, (Throwable)e));
                }
            }
        };
        try {
            JavaCore.run((IWorkspaceRunnable)validationRunnable, (ISchedulingRule)rule, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            if (e.getCause() instanceof ValidationException) {
                throw (ValidationException)e.getCause();
            }
            throw new ValidationException((IMessage)new LocalizedMessage(3, e.getMessage()), (Throwable)e);
        }
        return status;
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private List fFiles = new ArrayList();
        private IContentType[] fContentTypes = null;
        private IReporter fReporter = null;

        public JSPFileVisitor(IReporter reporter) {
            this.fReporter = reporter;
        }

        final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        private IContentType[] getValidContentTypes() {
            if (this.fContentTypes == null) {
                this.fContentTypes = new IContentType[]{Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSP), Platform.getContentTypeManager().getContentType(ContentTypeIdForJSP.ContentTypeID_JSPFRAGMENT)};
                if (JSPBatchValidator.this.fAdditionalContentTypesIDs != null) {
                    ArrayList<IContentType> allTypes = new ArrayList<IContentType>(Arrays.asList(this.fContentTypes));
                    int i = 0;
                    while (i < JSPBatchValidator.this.fAdditionalContentTypesIDs.length) {
                        IContentType type = Platform.getContentTypeManager().getContentType(JSPBatchValidator.this.fAdditionalContentTypesIDs[i]);
                        if (type != null) {
                            allTypes.add(type);
                        }
                        ++i;
                    }
                    this.fContentTypes = allTypes.toArray(new IContentType[allTypes.size()]);
                }
            }
            return this.fContentTypes;
        }

        private boolean isJSPType(String fileName) {
            boolean valid = false;
            IContentType[] types = this.getValidContentTypes();
            int i = 0;
            while (i < types.length && !valid) {
                valid = types[i].isAssociatedWith(fileName);
                ++i;
            }
            return valid;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            IFile file;
            if (this.fReporter.isCancelled()) {
                return false;
            }
            if (proxy.getType() == 1 && this.isJSPType(proxy.getName()) && (file = (IFile)proxy.requestResource()).exists()) {
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + file.getName());
                }
                this.fFiles.add(file);
                return false;
            }
            return true;
        }
    }

    class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        private String getLocalizedText() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedText();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedText();
        }

        public String getText(Locale l) {
            return this.getLocalizedText();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedText();
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }
    }
}

