/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ResourceLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIteratorImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ContainerImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EARArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.project.ProjectSupportResourceHandler;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualContainer;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;

public abstract class ComponentLoadStrategyImpl
extends LoadStrategyImpl {
    protected static final String DOT_PROJECT = ".project";
    protected static final String DOT_CLASSPATH = ".classpath";
    protected static final String DOT_SETTINGS = ".settings";
    protected static final String DOT_CVS_IGORE = ".cvsignore";
    protected IVirtualComponent vComponent;
    protected boolean exportSource;
    private ArtifactEdit artifactEdit;
    private List zipFiles = new ArrayList();
    protected FilesHolder filesHolder;
    private Exception exception;
    private IResource[] sourceRoots = null;
    private boolean inJavaSrc = false;
    protected IProgressMonitor monitor = null;
    protected final int FILE_SAVE_WORK = 100;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ComponentLoadStrategyImpl(IVirtualComponent vComponent) {
        this.vComponent = vComponent;
        this.filesHolder = new FilesHolder();
        this.exception = new Exception();
    }

    public boolean contains(String uri) {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        return rootFolder.getFile((IPath)new Path(uri)).exists();
    }

    protected void initializeResourceSet() {
        this.resourceSet = WorkbenchResourceHelperBase.getResourceSet((IProject)this.vComponent.getProject());
    }

    protected boolean primContains(String uri) {
        return false;
    }

    public List getFiles() {
        this.aggregateSourceFiles();
        this.aggregateClassFiles();
        this.addUtilities();
        return this.filesHolder.getFiles();
    }

    protected void addUtilities() {
        IVirtualReference[] components = this.vComponent.getReferences();
        int i = 0;
        while (i < components.length) {
            IVirtualReference reference = components[i];
            IVirtualComponent referencedComponent = reference.getReferencedComponent();
            if (referencedComponent.isBinary() && reference.getDependencyType() == 1) {
                java.io.File diskFile = ((VirtualArchiveComponent)referencedComponent).getUnderlyingDiskFile();
                IPath path = reference.getRuntimePath();
                try {
                    ZipFile zipFile = new ZipFile(diskFile);
                    this.zipFiles.add(zipFile);
                    Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry entry = enumeration.nextElement();
                        this.filesHolder.addEntry(entry, zipFile, path);
                    }
                }
                catch (ZipException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
                catch (IOException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void aggregateSourceFiles() {
        try {
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualResource[] members = rootFolder.members();
            IPackageFragmentRoot[] srcPkgs = J2EEProjectUtilities.getSourceContainers(this.vComponent.getProject());
            this.sourceRoots = new IResource[srcPkgs.length];
            int i = 0;
            while (i < srcPkgs.length) {
                this.sourceRoots[i] = srcPkgs[i].getCorrespondingResource();
                ++i;
            }
            this.inJavaSrc = false;
            this.aggregateFiles(members);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    protected void aggregateClassFiles() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 396->400)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected boolean aggregateOutputFiles(IResource[] resources, IPath runtimePathPrefix, int outputFolderSegmentCount) throws CoreException {
        boolean fileAdded = false;
        int i = 0;
        while (i < resources.length) {
            File cFile = null;
            if (resources[i].exists()) {
                String uri;
                IPath runtimePath = runtimePathPrefix.append(resources[i].getProjectRelativePath().removeFirstSegments(outputFolderSegmentCount));
                String string = uri = runtimePath == null ? null : runtimePath.toString();
                if (uri != null) {
                    if (resources[i].getType() == 1) {
                        if (this.shouldInclude(uri)) {
                            cFile = this.createFile(uri);
                            cFile.setLastModified(this.getLastModified(resources[i]));
                            this.filesHolder.addFile(cFile, resources[i]);
                            fileAdded = true;
                        }
                    } else if (this.shouldInclude((IContainer)resources[i])) {
                        IResource[] nestedResources = ((IContainer)resources[i]).members();
                        this.aggregateOutputFiles(nestedResources, runtimePathPrefix, outputFolderSegmentCount);
                        if (!this.filesHolder.contains(uri) && this.shouldInclude(uri)) {
                            cFile = this.createDirectory(uri);
                            cFile.setLastModified(this.getLastModified(resources[i]));
                            this.filesHolder.addDirectory(cFile);
                            fileAdded = true;
                        }
                    }
                }
            }
            ++i;
        }
        return fileAdded;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean aggregateFiles(IVirtualResource[] virtualResources) throws CoreException {
        fileAdded = false;
        i = 0;
        while (true) {
            block12: {
                block13: {
                    if (i >= virtualResources.length) {
                        return fileAdded;
                    }
                    cFile = null;
                    if (!virtualResources[i].exists()) break block12;
                    runtimePath = virtualResources[i].getRuntimePath();
                    v0 = uri = runtimePath == null ? null : runtimePath.toString();
                    if (uri == null) break block12;
                    if (uri.charAt(0) == '/') {
                        uri = uri.substring(1);
                    }
                    if (this.filesHolder.contains(uri)) break block12;
                    if (virtualResources[i].getType() != 16) break block13;
                    if (this.shouldInclude(uri)) {
                        resource = virtualResources[i].getUnderlyingResource();
                        if (!this.inJavaSrc || !resource.isDerived()) {
                            cFile = this.createFile(uri);
                            cFile.setLastModified(this.getLastModified(resource));
                            this.filesHolder.addFile(cFile, resource);
                            fileAdded = true;
                        }
                    }
                    break block12;
                }
                if (!this.shouldInclude((IVirtualContainer)virtualResources[i])) break block12;
                inJavaSrcAtThisLevel = this.inJavaSrc;
                try {
                    if (!this.inJavaSrc) {
                        this.inJavaSrc = this.inJavaSrc(virtualResources[i]);
                    }
                    nestedVirtualResources = ((IVirtualContainer)virtualResources[i]).members();
                    this.aggregateFiles(nestedVirtualResources);
                    if (!this.filesHolder.contains(uri)) {
                        if (!this.shouldInclude(uri)) {
                            while (true) {
                                var10_11 = null;
                                this.inJavaSrc = inJavaSrcAtThisLevel;
                                break block12;
                                break;
                            }
                        }
                        resource = virtualResources[i].getUnderlyingResource();
                        if (this.inJavaSrc && resource.isDerived()) ** continue;
                        cFile = this.createDirectory(uri);
                        cFile.setLastModified(this.getLastModified(resource));
                        this.filesHolder.addDirectory(cFile);
                        fileAdded = true;
                    }
                }
                catch (Throwable var11_12) {
                    var10_11 = null;
                    this.inJavaSrc = inJavaSrcAtThisLevel;
                    throw var11_12;
                }
                {
                    var10_11 = null;
                    this.inJavaSrc = inJavaSrcAtThisLevel;
                }
            }
            ++i;
        }
    }

    private boolean inJavaSrc(IVirtualResource virtualResource) {
        if (this.sourceRoots.length == 0) {
            return false;
        }
        IResource[] resources = virtualResource.getUnderlyingResources();
        boolean inJavaSrc = false;
        int i = 0;
        while (i < resources.length) {
            inJavaSrc = false;
            int j = 0;
            while (j < this.sourceRoots.length) {
                if (this.sourceRoots[j].getFullPath().isPrefixOf(resources[i].getFullPath())) {
                    inJavaSrc = true;
                    break;
                }
                ++j;
            }
            if (!inJavaSrc) break;
            ++i;
        }
        return inJavaSrc;
    }

    protected long getLastModified(IResource aResource) {
        return aResource.getLocation().toFile().lastModified();
    }

    public void setExportSource(boolean newExportSource) {
        this.exportSource = newExportSource;
    }

    public boolean isExportSource() {
        return this.exportSource;
    }

    protected boolean shouldInclude(IContainer aContainer) {
        return true;
    }

    protected boolean shouldInclude(IVirtualContainer vContainer) {
        IContainer iContainer = (IContainer)vContainer.getUnderlyingResource();
        return this.shouldInclude(iContainer);
    }

    protected boolean shouldInclude(String uri) {
        if (uri.length() == 0 || DOT_PROJECT.equals(uri) || DOT_CLASSPATH.equals(uri) || uri.endsWith(DOT_CVS_IGORE) || uri.startsWith(DOT_SETTINGS)) {
            return false;
        }
        return this.isExportSource() || !this.isSource(uri);
    }

    protected boolean isSource(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.endsWith(".java") || uri.endsWith(".sqlj");
    }

    protected void addExternalFile(String uri, java.io.File externalDiskFile) {
        File aFile = this.createFile(uri);
        this.filesHolder.addFile(aFile, externalDiskFile);
    }

    public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
        if (this.filesHolder.contains(uri)) {
            return this.filesHolder.getInputStream(uri);
        }
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualResource vResource = rootFolder.findMember(uri);
        String filePath = null;
        if (vResource != null && vResource.exists()) {
            filePath = vResource.getUnderlyingResource().getLocation().toOSString();
            java.io.File file = new java.io.File(filePath);
            return new FileInputStream(file);
        }
        String eString = EARArchiveOpsResourceHandler.ARCHIVE_OPERATION_FileNotFound;
        throw new FileNotFoundException(eString);
    }

    public Collection getLoadedMofResources() {
        Collection resources = super.getLoadedMofResources();
        ArrayList<Resource> resourcesToRemove = new ArrayList<Resource>();
        Iterator iterator = resources.iterator();
        while (iterator.hasNext()) {
            Resource res = (Resource)iterator.next();
            if (!res.getURI().toString().endsWith(".component") || !res.getURI().segmentsList().contains(DOT_SETTINGS)) continue;
            resourcesToRemove.add(res);
        }
        if (resourcesToRemove != null) {
            resources.removeAll(resourcesToRemove);
        }
        return resources;
    }

    protected synchronized ArtifactEdit getArtifactEditForRead() {
        if (this.artifactEdit == null) {
            this.artifactEdit = ArtifactEdit.getArtifactEditForRead((IVirtualComponent)this.vComponent);
        }
        return this.artifactEdit;
    }

    public Resource getMofResource(String uri) throws FileNotFoundException, ResourceLoadException {
        return this.getArtifactEditForRead().getResource(URI.createURI((String)uri));
    }

    public boolean isClassLoaderNeeded() {
        return false;
    }

    public IVirtualComponent getComponent() {
        return this.vComponent;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public FileIterator getFileIterator() throws IOException {
        return new FileIteratorImpl((List)this.getContainer().getFiles()){
            protected SubProgressMonitor lastSubMon = null;
            boolean firstVisit = true;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public File next() {
                if (this.firstVisit) {
                    this.firstVisit = false;
                    if (ComponentLoadStrategyImpl.this.monitor != null) {
                        ComponentLoadStrategyImpl.this.monitor.beginTask(ProjectSupportResourceHandler.getString(ProjectSupportResourceHandler.Exporting_archive, new Object[]{ComponentLoadStrategyImpl.this.getContainer().getURI()}), this.files.size() * 100);
                    }
                }
                if (this.lastSubMon != null) {
                    this.lastSubMon.done();
                    this.lastSubMon = null;
                } else if (ComponentLoadStrategyImpl.this.monitor != null) {
                    ComponentLoadStrategyImpl.this.monitor.worked(100);
                }
                File file = super.next();
                if (ComponentLoadStrategyImpl.this.monitor == null) return file;
                if (file.isContainer()) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.jst.j2ee.internal.archive.operations.ComponentLoadStrategyImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    if (clazz.isInstance(((ContainerImpl)file).getLoadStrategy())) {
                        ComponentLoadStrategyImpl ls = (ComponentLoadStrategyImpl)((ContainerImpl)file).getLoadStrategy();
                        this.lastSubMon = new SubProgressMonitor(ComponentLoadStrategyImpl.this.monitor, 100, 4);
                        ls.setProgressMonitor((IProgressMonitor)this.lastSubMon);
                        return file;
                    }
                }
                ComponentLoadStrategyImpl.this.monitor.subTask(file.getURI());
                return file;
            }
        };
    }

    /*
     * Exception decompiling
     */
    public void close() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [7 : 224->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected class FilesHolder {
        private Map urisToFiles = new HashMap();
        private Map urisToResources = new HashMap();
        private Map resourcesToURI = new HashMap();
        private Map urisToDiskFiles;
        private Map urisToZipEntry = new HashMap();

        protected FilesHolder() {
        }

        public void removeIFile(IFile file) {
            String uri = (String)this.resourcesToURI.get(file);
            this.remove(uri);
        }

        public void remove(String uri) {
            this.urisToFiles.remove(uri);
            Object resource = this.urisToResources.remove(uri);
            if (resource != null) {
                this.resourcesToURI.remove(resource);
            }
            if (this.urisToDiskFiles != null) {
                this.urisToDiskFiles.remove(uri);
            }
        }

        public void addDirectory(File directory) {
            String uri = directory.getURI();
            this.urisToFiles.put(uri, directory);
        }

        public void addFile(File file) {
            String uri = file.getURI();
            this.urisToFiles.put(uri, file);
        }

        public void addFile(File file, java.io.File externalDiskFile) {
            String uri = file.getURI();
            this.urisToFiles.put(uri, file);
            if (this.urisToDiskFiles == null) {
                this.urisToDiskFiles = new HashMap();
            }
            this.urisToDiskFiles.put(uri, externalDiskFile);
        }

        public void addFile(File file, IResource resource) {
            String uri = file.getURI();
            this.urisToFiles.put(uri, file);
            this.urisToResources.put(uri, resource);
        }

        public InputStream getInputStream(String uri) throws IOException, FileNotFoundException {
            java.io.File diskFile = null;
            if (this.urisToDiskFiles != null && this.urisToDiskFiles.containsKey(uri)) {
                diskFile = (java.io.File)this.urisToDiskFiles.get(uri);
            } else if (this.urisToResources != null && this.urisToResources.containsKey(uri)) {
                IResource resource = (IResource)this.urisToResources.get(uri);
                diskFile = new java.io.File(resource.getLocation().toOSString());
            } else {
                Map fileURIMap = (Map)this.urisToZipEntry.get(uri);
                Iterator it = fileURIMap.keySet().iterator();
                String sourceFileUri = "";
                ZipFile zipFile = null;
                while (it.hasNext()) {
                    sourceFileUri = (String)it.next();
                    zipFile = (ZipFile)fileURIMap.get(sourceFileUri);
                }
                ZipEntry entry = zipFile.getEntry(sourceFileUri);
                InputStream in = zipFile.getInputStream(entry);
                return in;
            }
            return new FileInputStream(diskFile);
        }

        public List getFiles() {
            return new ArrayList(this.urisToFiles.values());
        }

        public boolean contains(String uri) {
            return this.urisToFiles.containsKey(uri);
        }

        public void addEntry(ZipEntry entry, ZipFile zipFile, IPath runtimePath) {
            String uri = runtimePath == null ? null : runtimePath.toString();
            String fileURI = "";
            fileURI = uri != null ? (!uri.equals("/") ? String.valueOf(uri) + entry.getName() : entry.getName()) : entry.getName();
            File file = ComponentLoadStrategyImpl.this.createFile(fileURI);
            HashMap<String, ZipFile> fileURIMap = new HashMap<String, ZipFile>();
            fileURIMap.put(entry.getName(), zipFile);
            this.urisToZipEntry.put(file.getURI(), fileURIMap);
            this.urisToFiles.put(file.getURI(), file);
        }
    }
}

