/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.connection.resource;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLSaveImpl;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;

public class OfflineSave
extends XMISaveImpl {
    protected void init(XMLResource resource, Map options) {
        super.init(resource, options);
        this.escape = new DataModelEscape();
    }

    public OfflineSave(XMLHelper helper) {
        super(helper);
    }

    public OfflineSave(Map options, XMLHelper helper, String encoding) {
        super(options, helper, encoding);
    }

    public void traverse(List contents) {
        this.doc.add("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
        this.doc.addLine();
        this.doc.addComment("xtools2_universal_type_manager");
        int size = contents.size();
        Object mark = size == 1 ? this.writeTopObject((EObject)contents.get(0)) : this.writeTopObjects(contents);
        this.doc.resetToMark(mark);
        this.addNamespaceDeclarations();
    }

    protected static class DataModelEscape
    extends XMLSaveImpl.Escape {
        protected static final char[] HEXES = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

        protected DataModelEscape() {
        }

        public static char[] uuencode(char c) {
            char[] uu = new char[]{'\\', 'u', HEXES[c >> 12 & 0xF], HEXES[c >> 8 & 0xF], HEXES[c >> 4 & 0xF], HEXES[c & 0xF]};
            return uu;
        }

        public String convert(String input) {
            boolean changed = false;
            int inputLength = input.length();
            this.grow(inputLength);
            input.getChars(0, inputLength, this.value, 0);
            int pos = 0;
            char ch = '\u0000';
            while (inputLength-- > 0) {
                ch = this.value[pos];
                switch (ch) {
                    case '&': {
                        pos = this.replace(pos, this.AMP, inputLength);
                        changed = true;
                        break;
                    }
                    case '<': {
                        pos = this.replace(pos, this.LESS, inputLength);
                        changed = true;
                        break;
                    }
                    case '\"': {
                        pos = this.replace(pos, this.QUOTE, inputLength);
                        changed = true;
                        break;
                    }
                    case '\n': {
                        pos = this.replace(pos, this.LF, inputLength);
                        changed = true;
                        break;
                    }
                    case '\r': {
                        pos = this.replace(pos, this.CR, inputLength);
                        changed = true;
                        break;
                    }
                    case '\t': {
                        pos = this.replace(pos, this.TAB, inputLength);
                        changed = true;
                        break;
                    }
                    case '\u0000': 
                    case '\u0001': 
                    case '\u0002': 
                    case '\u0003': 
                    case '\u0004': 
                    case '\u0005': 
                    case '\u0006': 
                    case '\u0007': 
                    case '\b': 
                    case '\u000b': 
                    case '\f': 
                    case '\u000e': 
                    case '\u000f': 
                    case '\u0010': 
                    case '\u0011': 
                    case '\u0012': 
                    case '\u0013': 
                    case '\u0014': 
                    case '\u0015': 
                    case '\u0016': 
                    case '\u0017': 
                    case '\u0018': 
                    case '\u0019': 
                    case '\u001a': 
                    case '\u001b': 
                    case '\u001c': 
                    case '\u001d': 
                    case '\u001e': 
                    case '\u001f': {
                        pos = this.replace(pos, DataModelEscape.uuencode(ch), inputLength);
                        changed = true;
                        break;
                    }
                    default: {
                        if (!DataValue.XMLChar.isValid((int)ch)) {
                            throw new RuntimeException("An invalid XML character (Unicode: 0x" + Integer.toHexString(ch) + ") was found in the element content:" + input);
                        }
                        ++pos;
                    }
                }
            }
            return changed ? new String(this.value, 0, pos) : input;
        }
    }
}

