/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.deploy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.componentcore.EnterpriseArtifactEdit;
import org.eclipse.jst.j2ee.internal.deploy.DeployerRegistry;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.internal.emf.utilities.CommandContext;
import org.eclipse.wst.common.internal.emf.utilities.ICommand;
import org.eclipse.wst.common.internal.emf.utilities.ICommandContext;
import org.eclipse.wst.server.core.IRuntime;

public class J2EEDeployOperation
extends AbstractDataModelOperation {
    private Object[] selection;
    private IStatus multiStatus;
    private IProject currentProject;

    public J2EEDeployOperation(Object[] deployableObjects) {
        this.selection = deployableObjects;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        DeployerRegistry reg = DeployerRegistry.instance();
        List modules = this.getSelectedModules(this.selection);
        monitor.beginTask(J2EEPluginResourceHandler.J2EEDeployOperation_UI_0, modules.size());
        int i = 0;
        while (true) {
            block10: {
                Object var11_12;
                EnterpriseArtifactEdit edit;
                block12: {
                    block11: {
                        if (i >= modules.size()) {
                            return this.getMultiStatus();
                        }
                        edit = null;
                        try {
                            edit = (EnterpriseArtifactEdit)((Object)modules.get(i));
                            EObject module = edit.getDeploymentDescriptorRoot();
                            IProject proj = ProjectUtilities.getProject((EObject)module);
                            IRuntime runtime = null;
                            try {
                                runtime = J2EEProjectUtilities.getServerRuntime(proj);
                            }
                            catch (CoreException e) {
                                J2EEPlugin.getDefault().getLog().log(e.getStatus());
                            }
                            if (runtime == null) {
                                var11_12 = null;
                                if (edit == null) break block10;
                                break block11;
                            }
                            List visitors = reg.getDeployModuleExtensions(module, runtime);
                            this.deploy(visitors, module, monitor);
                            monitor.worked(1);
                            break block12;
                        }
                        catch (Throwable throwable) {
                            var11_12 = null;
                            if (edit != null) {
                                edit.dispose();
                            }
                            throw throwable;
                        }
                    }
                    edit.dispose();
                    break block10;
                }
                var11_12 = null;
                if (edit != null) {
                    edit.dispose();
                }
            }
            ++i;
        }
    }

    private void deploy(List visitors, EObject module, IProgressMonitor monitor) {
        IProject proj = ProjectUtilities.getProject((EObject)module);
        int i = 0;
        while (i < visitors.size()) {
            block7: {
                if (visitors.get(i) instanceof IConfigurationElement) {
                    ICommand dep = null;
                    try {
                        dep = (ICommand)((IConfigurationElement)visitors.get(i)).createExecutableExtension("deployer_class");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break block7;
                    }
                    CommandContext ctx = new CommandContext(monitor, null, module.eResource().getResourceSet());
                    if (dep != null) {
                        dep.init(this.selection);
                        monitor.setTaskName(J2EEPluginResourceHandler.getString(J2EEPluginResourceHandler.J2EEDeployOperation_1_UI_, new Object[]{proj.getName(), dep.getClass().getName()}));
                        try {
                            dep.execute((IResource)proj, null, (ICommandContext)ctx);
                            this.addOKStatus(dep.getClass().getName());
                        }
                        catch (CoreException ex) {
                            Logger.getLogger().logError((Throwable)ex);
                            CoreException statusException = ex.getStatus().getException() != null ? ex.getStatus().getException() : ex;
                            this.addErrorStatus(ex.getStatus(), dep.getClass().getName(), statusException);
                        }
                    }
                }
            }
            ++i;
        }
    }

    private void addOKStatus(String DeployerName) {
        Status statusLocal = new Status(0, " ", 0, J2EEPluginResourceHandler.getString("J2EEDeployOperation_2_UI_", new Object[]{DeployerName}), null);
        this.getMultiStatus().add((IStatus)statusLocal);
    }

    private void addErrorStatus(IStatus exceptionStatus, String DeployerName, Throwable ex) {
        Throwable mainCause = null;
        if (exceptionStatus instanceof MultiStatus) {
            IStatus[] stati = ((MultiStatus)exceptionStatus).getChildren();
            int i = 0;
            while (i < stati.length) {
                this.addErrorStatus(stati[i], DeployerName, stati[i].getException());
                ++i;
            }
        }
        mainCause = ex != null && ex.getCause() != null ? ex.getCause() : ex;
        String message = J2EEPluginResourceHandler.bind((String)J2EEPluginResourceHandler.J2EEDeployOperation_3_UI_, (Object)DeployerName, (Object)"");
        Status statusLocal = new Status(4, J2EEPlugin.getPlugin().getPluginID(), 4, message, mainCause);
        this.getMultiStatus().add((IStatus)statusLocal);
    }

    private IStatus getMainStatus(IProject proj) {
        MultiStatus aStatus = new MultiStatus(J2EEPlugin.getPlugin().getPluginID(), 0, J2EEPluginResourceHandler.getString(J2EEPluginResourceHandler.J2EEDeployOperation_4_UI_, new Object[]{proj.getName()}), null);
        return aStatus;
    }

    public MultiStatus getMultiStatus() {
        if (this.multiStatus == null) {
            this.multiStatus = this.getMainStatus(this.currentProject);
        }
        return (MultiStatus)this.multiStatus;
    }

    public void setMultiStatus(IStatus newStatus) {
        this.multiStatus = newStatus;
    }

    protected List getSelectedModules(Object[] mySelections) {
        ArrayList<EnterpriseArtifactEdit> modules = new ArrayList<EnterpriseArtifactEdit>();
        ArrayList<IVirtualComponent> components = new ArrayList<IVirtualComponent>();
        int i = 0;
        while (i < mySelections.length) {
            Object object = mySelections[i];
            if (object instanceof EObject) {
                object = ProjectUtilities.getProject((Object)object);
                this.currentProject = (IProject)object;
            }
            if (object instanceof IProject) {
                this.currentProject = (IProject)object;
                IVirtualComponent component = ComponentCore.createComponent((IProject)((IProject)object));
                EnterpriseArtifactEdit edit = null;
                edit = (EnterpriseArtifactEdit)ComponentUtilities.getArtifactEditForRead((IVirtualComponent)component);
                if (components.contains((Object)edit)) {
                    if (edit != null) {
                        edit.dispose();
                    }
                } else if (J2EEProjectUtilities.isEARProject(component.getProject())) {
                    modules.add(0, edit);
                    components.add(0, component);
                } else {
                    modules.add(edit);
                    components.add(component);
                }
            }
            ++i;
        }
        return modules;
    }
}

