/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.wst.rdb.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.wst.rdb.core.internal.ui.widgets.DataContainerSelectionGroup;
import org.eclipse.wst.rdb.core.internal.ui.widgets.IDataSelectionValidator;

public class ResourceChooserDialog
extends SelectionDialog {
    private static final ResourceLoader resource = ResourceLoader.getResourceLoader();
    DataContainerSelectionGroup group;
    private IContainer initialSelection;
    private boolean allowNewContainerName = true;
    Label statusMessage;
    IDataSelectionValidator validator;
    private boolean showClosedProjects = true;
    private boolean showFiles = true;
    private String[] fileFilter = new String[0];
    private String[] projectNatureFilter = new String[0];
    private boolean allowMultipleSelection = false;
    private String[] filesToExclude = new String[0];

    public ResourceChooserDialog(Shell parentShell, IContainer initialRoot, boolean allowNewContainerName, String message, boolean showFiles) {
        super(parentShell);
        if (showFiles) {
            this.setTitle(resource.queryString("_UI_TITLE_FILE_CHOOSER"));
        } else {
            this.setTitle(resource.queryString("_UI_TITLE_FOLDER_CHOOSER"));
        }
        this.initialSelection = initialRoot;
        this.showFiles = showFiles;
        this.allowNewContainerName = allowNewContainerName;
        if (message != null) {
            this.setMessage(message);
        } else if (showFiles) {
            this.setMessage(resource.queryString("_UI_DESCRIPTION_FILE"));
        } else {
            this.setMessage(resource.queryString("_UI_DESCRIPTION_FOLDER"));
        }
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (ResourceChooserDialog.this.statusMessage != null && ResourceChooserDialog.this.validator != null) {
                    String errorMsg = ResourceChooserDialog.this.validator.isValid(ResourceChooserDialog.this.group.getSelection());
                    if (errorMsg == null || errorMsg.equals("")) {
                        ResourceChooserDialog.this.statusMessage.setText("");
                        ResourceChooserDialog.this.getOkButton().setEnabled(true);
                    } else {
                        ResourceChooserDialog.this.statusMessage.setForeground(JFaceColors.getErrorText((Display)ResourceChooserDialog.this.statusMessage.getDisplay()));
                        ResourceChooserDialog.this.statusMessage.setText(errorMsg);
                        ResourceChooserDialog.this.getOkButton().setEnabled(false);
                    }
                }
            }
        };
        this.group = new DataContainerSelectionGroup(area, listener, this.allowNewContainerName, this.getMessage(), this.showClosedProjects, this.projectNatureFilter, this.showFiles, this.fileFilter, this.allowMultipleSelection, this.filesToExclude);
        if (this.initialSelection != null) {
            this.group.setSelectedContainer(this.initialSelection);
        }
        this.statusMessage = new Label(parent, 0);
        this.statusMessage.setLayoutData((Object)new GridData(768));
        this.statusMessage.setFont(parent.getFont());
        return this.dialogArea;
    }

    protected void okPressed() {
        ArrayList<IStructuredSelection> selectionList = new ArrayList<IStructuredSelection>();
        IStructuredSelection returnValue = this.group.getSelection();
        if (returnValue != null) {
            selectionList.add(returnValue);
        }
        this.setResult(selectionList);
        super.okPressed();
    }

    public void setValidator(IDataSelectionValidator validator) {
        this.validator = validator;
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }

    public void setFileFilter(String[] filter) {
        this.fileFilter = filter;
    }

    public void setProjectNatureFilter(String[] naturesToShow) {
        this.projectNatureFilter = naturesToShow;
    }

    public void allowMultipleSelections(boolean allow) {
        this.allowMultipleSelection = allow;
    }

    public void setExcludedFiles(String[] filesToExclude) {
        this.filesToExclude = filesToExclude;
    }

    public boolean isHelpAvailable() {
        return false;
    }
}

