/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.webservice.startup;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceViewerSynchronization;
import org.eclipse.ui.IStartup;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectPropertyTester;

public class WebserviceListener
implements IStartup,
IResourceChangeListener,
IResourceDeltaVisitor {
    private boolean listening = false;
    private static final String PROJECT_FACET = "projectFacet";
    private static final String EAR_FACET = "jst.ear";
    private static final String APPCLIENT_FACET = "jst.appclient";
    private static final String WEB_FACET = "jst.web";
    private static final String EJB_FACET = "jst.ejb";
    private static final String WSDL_EXT = "wsdl";
    private static final String WSIL_EXT = "wsil";
    private static final String WEB_SERVICES_CLIENT_SHORTNAME = "webservicesclient.xml";
    private static final String WEB_SERVICES_DD_URI = "webservices.xml";
    private static final FacetedProjectPropertyTester facetPropertyTester = new FacetedProjectPropertyTester();
    private static WebserviceListener INSTANCE;

    public static WebserviceListener getInstance() {
        return INSTANCE;
    }

    private static final boolean isInteresting(IProject project) {
        return WebserviceListener.hasFacet(project, WEB_FACET) || WebserviceListener.hasFacet(project, EJB_FACET) || WebserviceListener.hasFacet(project, APPCLIENT_FACET);
    }

    private static final boolean hasFacet(Object element, String facet) {
        return facetPropertyTester.test(element, PROJECT_FACET, new Object[0], (Object)facet);
    }

    private static final boolean isFileInteresting(IFile aFile) {
        if (aFile != null && aFile.getFileExtension() != null) {
            String extension = aFile.getFileExtension();
            return extension.equals(WSDL_EXT) || extension.equals(WSIL_EXT) || aFile.getName().equals(WEB_SERVICES_CLIENT_SHORTNAME) || aFile.getName().equals(WEB_SERVICES_DD_URI);
        }
        return false;
    }

    public boolean isListening() {
        return this.listening;
    }

    public void earlyStartup() {
        INSTANCE = this;
        this.startListening();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)this);
        }
        catch (CoreException coreException) {}
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                return true;
            }
            case 4: {
                if (!this.isListening() || delta.getKind() != 1 && delta.getKind() != 4 || !WebserviceListener.isInteresting(resource.getProject())) break;
                return true;
            }
            case 2: {
                if (!this.isListening() || delta.getKind() != 1 && delta.getKind() != 4) break;
                return true;
            }
            case 1: {
                if (!this.isListening() || delta.getKind() != 1 || !WebserviceListener.isFileInteresting((IFile)resource)) break;
                this.stopListening();
                if (!WebServiceViewerSynchronization.isThereWebServicesPreferenceSet()) break;
                WebServiceViewerSynchronization.setAreThereWebServices(true);
            }
        }
        return false;
    }

    public void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.listening = true;
    }

    public void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.listening = false;
    }
}

