/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ModuleFile;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public class ModulePublishInfo {
    private static final String MODULE_ID = "module-ids";
    private static final String NAME = "name";
    private static final String MODULE_TYPE_ID = "module-type-id";
    private static final String MODULE_TYPE_VERSION = "module-type-version";
    private static final String PATH = "path";
    private static final String STAMP = "stamp";
    private static final String FILE = "file";
    private static final String FOLDER = "folder";
    private String moduleId;
    private String name;
    private IModuleResource[] resources = new IModuleResource[0];
    private IModuleType moduleType;
    private boolean useCache;
    private IModuleResource[] currentResources = null;
    private IModuleResourceDelta[] delta = null;
    private boolean hasDelta;
    static /* synthetic */ Class class$0;

    public ModulePublishInfo(String moduleId, String name, IModuleType moduleType) {
        this.moduleId = moduleId;
        this.name = name;
        this.moduleType = moduleType;
    }

    public ModulePublishInfo(IMemento memento) {
        this.load(memento);
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getName() {
        return this.name;
    }

    public IModuleType getModuleType() {
        return this.moduleType;
    }

    public IModuleResource[] getResources() {
        return this.resources;
    }

    public void setResources(IModuleResource[] res) {
        this.resources = res;
    }

    protected void load(IMemento memento) {
        Trace.trace(Trace.FINEST, "Loading module publish info for: " + memento);
        try {
            this.moduleId = memento.getString(MODULE_ID);
            this.name = memento.getString(NAME);
            String mt = memento.getString(MODULE_TYPE_ID);
            String mv = memento.getString(MODULE_TYPE_VERSION);
            if (mt != null && mt.length() > 0) {
                this.moduleType = new ModuleType(mt, mv);
            }
            this.resources = this.loadResource(memento, (IPath)new Path(""));
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load module publish info information: " + e.getMessage());
        }
    }

    protected IModuleResource[] loadResource(IMemento memento, IPath path) {
        String name2;
        int i;
        int size;
        if (memento == null) {
            return new IModuleResource[0];
        }
        ArrayList<IModuleResource> list = new ArrayList<IModuleResource>(10);
        IMemento[] children = memento.getChildren(FILE);
        if (children != null) {
            size = children.length;
            i = 0;
            while (i < size) {
                name2 = children[i].getString(NAME);
                long stamp = Long.parseLong(children[i].getString(STAMP));
                ModuleFile file = new ModuleFile(name2, path, stamp);
                list.add(file);
                ++i;
            }
        }
        if ((children = memento.getChildren(FOLDER)) != null) {
            size = children.length;
            i = 0;
            while (i < size) {
                name2 = children[i].getString(NAME);
                ModuleFolder folder = new ModuleFolder(null, name2, path);
                folder.setMembers(this.loadResource(children[i], path.append(name2)));
                list.add(folder);
                ++i;
            }
        }
        IModuleResource[] resources2 = new IModuleResource[list.size()];
        list.toArray(resources2);
        return resources2;
    }

    protected void save(IMemento memento) {
        try {
            memento.putString(MODULE_ID, this.moduleId);
            if (this.name != null) {
                memento.putString(NAME, this.name);
            }
            if (this.moduleType != null) {
                memento.putString(MODULE_TYPE_ID, this.moduleType.getId());
                memento.putString(MODULE_TYPE_VERSION, this.moduleType.getVersion());
            }
            this.saveResource(memento, this.resources);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save module publish info", e);
        }
    }

    protected void saveResource(IMemento memento, IModuleResource[] resources2) {
        if (resources2 == null) {
            return;
        }
        int size = resources2.length;
        int i = 0;
        while (i < size) {
            IMemento child;
            if (resources2[i] instanceof IModuleFile) {
                IModuleFile file = (IModuleFile)resources2[i];
                child = memento.createChild(FILE);
                child.putString(NAME, file.getName());
                child.putString(PATH, file.getModuleRelativePath().toPortableString());
                child.putString(STAMP, "" + file.getModificationStamp());
            } else {
                IModuleFolder folder = (IModuleFolder)resources2[i];
                child = memento.createChild(FOLDER);
                child.putString(NAME, folder.getName());
                child.putString(PATH, folder.getModuleRelativePath().toPortableString());
                IModuleResource[] resources3 = folder.members();
                this.saveResource(child, resources3);
            }
            ++i;
        }
    }

    protected void startCaching() {
        this.useCache = true;
        this.currentResources = null;
    }

    private void fillCache(IModule[] module) {
        if (this.currentResources != null) {
            return;
        }
        try {
            ModuleDelegate pm;
            long time = System.currentTimeMillis();
            int size = module.length;
            IModule iModule = module[size - 1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.currentResources = (pm = (ModuleDelegate)iModule.loadAdapter(clazz, null)) != null ? pm.members() : new IModuleResource[0];
            this.delta = ServerPublishInfo.getDelta(this.resources, this.currentResources);
            this.hasDelta = this.delta != null && this.delta.length > 0;
            Trace.trace(Trace.PERFORMANCE, "Filling publish cache for " + module[size - 1].getName() + ": " + (System.currentTimeMillis() - time));
        }
        catch (CoreException coreException) {
            Trace.trace(Trace.WARNING, "Couldn't fill publish cache for " + module);
        }
        if (this.delta == null) {
            this.delta = new IModuleResourceDelta[0];
        }
    }

    protected void clearCache() {
        this.useCache = false;
        this.currentResources = null;
        this.delta = null;
    }

    protected IModuleResource[] getModuleResources(IModule[] module) {
        if (module == null) {
            return new IModuleResource[0];
        }
        if (this.useCache) {
            this.fillCache(module);
            return this.currentResources;
        }
        long time = System.currentTimeMillis();
        int size = module.length;
        IModule iModule = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)iModule.loadAdapter(clazz, null);
        IModuleResource[] x = new IModuleResource[]{};
        try {
            if (pm != null) {
                x = pm.members();
            }
        }
        catch (CoreException coreException) {}
        Trace.trace(Trace.PERFORMANCE, "Time to get members() for " + module[size - 1].getName() + ": " + (System.currentTimeMillis() - time));
        return x;
    }

    protected IModuleResourceDelta[] getDelta(IModule[] module) {
        if (module == null) {
            return new IModuleResourceDelta[0];
        }
        if (this.useCache) {
            this.fillCache(module);
            return this.delta;
        }
        int size = module.length;
        IModule iModule = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)iModule.loadAdapter(clazz, null);
        IModuleResource[] resources2 = null;
        try {
            if (pm != null) {
                resources2 = pm.members();
            }
        }
        catch (CoreException coreException) {}
        if (resources2 == null) {
            resources2 = new IModuleResource[]{};
        }
        return ServerPublishInfo.getDelta(this.getResources(), resources2);
    }

    protected boolean hasDelta(IModule[] module) {
        if (module == null) {
            return false;
        }
        if (this.useCache) {
            this.fillCache(module);
            return this.hasDelta;
        }
        int size = module.length;
        IModule iModule = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)iModule.loadAdapter(clazz, null);
        IModuleResource[] resources2 = null;
        try {
            if (pm != null) {
                resources2 = pm.members();
            }
        }
        catch (CoreException coreException) {}
        if (resources2 == null) {
            resources2 = new IModuleResource[]{};
        }
        return ServerPublishInfo.hasDelta(this.getResources(), resources2);
    }

    public void fill(IModule[] module) {
        if (module == null) {
            return;
        }
        if (this.useCache) {
            this.fillCache(module);
            this.setResources(this.currentResources);
            return;
        }
        int size = module.length;
        IModule iModule = module[size - 1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ModuleDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ModuleDelegate pm = (ModuleDelegate)iModule.loadAdapter(clazz, null);
        try {
            if (pm != null) {
                this.setResources(pm.members());
            }
        }
        catch (CoreException coreException) {}
    }

    public String toString() {
        return "ModulePublishInfo [" + this.moduleId + "]";
    }
}

