/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.wst.xsl.jaxp.debug.invoker.PipelineDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TransformDefinition;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TypedValue;
import org.eclipse.wst.xsl.jaxp.launching.IAttribute;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorType;
import org.eclipse.wst.xsl.jaxp.launching.ITransformerFactory;
import org.eclipse.wst.xsl.jaxp.launching.JAXPRuntime;
import org.eclipse.wst.xsl.jaxp.launching.LaunchAttributes;
import org.eclipse.wst.xsl.jaxp.launching.LaunchProperties;
import org.eclipse.wst.xsl.jaxp.launching.internal.JAXPLaunchingPlugin;
import org.eclipse.wst.xsl.jaxp.launching.internal.Messages;
import org.eclipse.wst.xsl.launching.config.BaseLaunchHelper;
import org.eclipse.wst.xsl.launching.config.LaunchAttribute;
import org.eclipse.wst.xsl.launching.config.LaunchTransform;
import org.eclipse.wst.xsl.launching.config.PreferenceUtil;
import org.w3c.dom.Document;

public class LaunchHelper
extends BaseLaunchHelper {
    private final LaunchAttributes attributes;
    private final LaunchProperties outputProperties;
    private final ITransformerFactory transformerFactory;

    public LaunchHelper(ILaunchConfiguration configuration) throws CoreException {
        super(configuration);
        this.attributes = LaunchHelper.hydrateAttributes(configuration);
        this.outputProperties = LaunchHelper.hydrateOutputProperties(configuration);
        this.transformerFactory = LaunchHelper.hydrateTransformerFactory(configuration);
    }

    public LaunchProperties getProperties() {
        return this.outputProperties;
    }

    public LaunchAttributes getAttributes() {
        return this.attributes;
    }

    public void save(File file) throws CoreException {
        BufferedWriter writer = null;
        try {
            try {
                file.createNewFile();
                writer = new BufferedWriter(new FileWriter(file));
                PipelineDefinition pdef = new PipelineDefinition();
                for (LaunchAttribute att : this.attributes.getAttributes()) {
                    pdef.addAttribute(new TypedValue(att.uri, "string", att.value));
                }
                Iterator<Object> iter = this.pipeline.getTransformDefs().iterator();
                while (iter.hasNext()) {
                    LaunchTransform lt = (LaunchTransform)iter.next();
                    TransformDefinition tdef = new TransformDefinition();
                    URL url = LaunchHelper.pathToURL((IPath)lt.getLocation());
                    tdef.setStylesheetURL(url.toExternalForm());
                    tdef.setResolverClass(lt.getResolver());
                    for (LaunchAttribute att : lt.getParameters()) {
                        tdef.addParameter(new TypedValue(att.uri, "string", att.getResolvedValue()));
                    }
                    if (!iter.hasNext()) {
                        for (Map.Entry<String, String> entry : this.outputProperties.getProperties().entrySet()) {
                            String name = entry.getKey();
                            String value = entry.getValue();
                            if (name == null || value == null) continue;
                            tdef.setOutputProperty(name, value);
                        }
                    }
                    pdef.addTransformDef(tdef);
                }
                Document doc = pdef.toXML();
                String s = PreferenceUtil.serializeDocument((Document)doc);
                writer.write(s);
            }
            catch (FileNotFoundException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 4, Messages.LaunchHelper_0, (Throwable)e));
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 4, Messages.LaunchHelper_1, (Throwable)e));
            }
            catch (ParserConfigurationException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 4, "ParserConfigurationException", (Throwable)e));
            }
            catch (TransformerException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.xsl.jaxp.launching", 4, "TransformerException", (Throwable)e));
            }
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    JAXPLaunchingPlugin.log(e);
                }
            }
        }
    }

    public static LaunchProperties hydrateOutputProperties(ILaunchConfiguration configuration) throws CoreException {
        LaunchProperties properties = new LaunchProperties();
        boolean usePreferenceProperties = false;
        IProcessorType pt = LaunchHelper.getProcessorInstall(configuration).getProcessorType();
        if (usePreferenceProperties) {
            for (Map.Entry<String, String> entry : pt.getOutputPropertyValues().entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                properties.setProperty(name, value);
            }
        } else {
            String s = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_OUTPUT_PROPERTIES", null);
            if (s != null && s.length() > 0) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
                properties = LaunchProperties.fromXML(inputStream);
            }
        }
        return properties;
    }

    private static LaunchAttributes hydrateAttributes(ILaunchConfiguration configuration) throws CoreException {
        LaunchAttributes attributes = new LaunchAttributes();
        boolean useDefaultAttributes = false;
        if (useDefaultAttributes) {
            IProcessorType pt = LaunchHelper.getProcessorInstall(configuration).getProcessorType();
            Map<String, String> fvals = pt.getAttributeValues();
            for (Map.Entry<String, String> entry : fvals.entrySet()) {
                String uri = entry.getKey();
                LaunchHelper.getAttribute(pt.getAttributes(), uri);
                attributes.addAttribute(new LaunchAttribute(uri, "string", entry.getValue()));
            }
        } else {
            String s = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_ATTRIBUTES", null);
            if (s != null && s.length() > 0) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(s.getBytes());
                attributes = LaunchAttributes.fromXML(inputStream);
            }
        }
        return attributes;
    }

    private static IAttribute getAttribute(IAttribute[] attributes, String uri) {
        IAttribute[] iAttributeArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attribute = iAttributeArray[n2];
            if (attribute.getURI().equals(uri)) {
                return attribute;
            }
            ++n2;
        }
        return null;
    }

    public static IProcessorInstall getProcessorInstall(ILaunchConfiguration configuration) throws CoreException {
        boolean useDefaultProcessor = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
        if (useDefaultProcessor) {
            return JAXPRuntime.getDefaultProcessor();
        }
        String processorId = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_PROCESSOR", "");
        IProcessorInstall processor = JAXPRuntime.getProcessor(processorId);
        return processor;
    }

    private static ITransformerFactory hydrateTransformerFactory(ILaunchConfiguration configuration) throws CoreException {
        IProcessorType type = LaunchHelper.getProcessorInstall(configuration).getProcessorType();
        boolean useDefaultFactory = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_USE_DEFAULT_PROCESSOR", true);
        if (useDefaultFactory) {
            return type.getDefaultTransformerFactory();
        }
        String factoryId = configuration.getAttribute("org.eclipse.wst.xsl.jaxp.launching.ATTR_TRANSFORMER_FACTORY", null);
        if (factoryId == null) {
            return null;
        }
        ITransformerFactory[] iTransformerFactoryArray = type.getTransformerFactories();
        int n = iTransformerFactoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITransformerFactory factory = iTransformerFactoryArray[n2];
            if (factory.getFactoryClass().equals(factoryId)) {
                return factory;
            }
            ++n2;
        }
        return null;
    }

    public ITransformerFactory getTransformerFactory() {
        return this.transformerFactory;
    }
}

