/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.MultiOperation;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class DeleteResourceElementsOperation
extends MultiOperation {
    protected DeleteResourceElementsOperation(IJavaScriptElement[] elementsToProcess, boolean force) {
        super(elementsToProcess, force);
    }

    private void deletePackageFragment(IPackageFragment frag) throws JavaScriptModelException {
        IResource res = frag.getResource();
        if (res != null) {
            IResource fragResource;
            IResource[] remainingFiles;
            IJavaScriptElement[] childrenOfInterest = frag.getChildren();
            if (childrenOfInterest.length > 0) {
                IResource[] resources = new IResource[childrenOfInterest.length];
                int i = 0;
                while (i < childrenOfInterest.length) {
                    resources[i] = childrenOfInterest[i].getCorrespondingResource();
                    ++i;
                }
                this.deleteResources(resources, this.force);
            }
            Object[] nonJavaResources = frag.getNonJavaScriptResources();
            int actualResourceCount = 0;
            int i = 0;
            int max = nonJavaResources.length;
            while (i < max) {
                if (nonJavaResources[i] instanceof IResource) {
                    ++actualResourceCount;
                }
                ++i;
            }
            IResource[] actualNonJavaResources = new IResource[actualResourceCount];
            int i2 = 0;
            int max2 = nonJavaResources.length;
            int index = 0;
            while (i2 < max2) {
                if (nonJavaResources[i2] instanceof IResource) {
                    actualNonJavaResources[index++] = (IResource)nonJavaResources[i2];
                }
                ++i2;
            }
            this.deleteResources(actualNonJavaResources, this.force);
            try {
                remainingFiles = ((IContainer)res).members();
            }
            catch (CoreException ce) {
                throw new JavaScriptModelException(ce);
            }
            boolean isEmpty = true;
            int i3 = 0;
            int length = remainingFiles.length;
            while (i3 < length) {
                IResource file = remainingFiles[i3];
                if (file instanceof IFile && Util.isClassFileName(file.getName())) {
                    this.deleteResource(file, 3);
                } else {
                    isEmpty = false;
                }
                ++i3;
            }
            if (isEmpty && !frag.isDefaultPackage() && (fragResource = frag.getResource()) != null) {
                this.deleteEmptyPackageFragment(frag, false, (IResource)fragResource.getParent());
            }
        }
    }

    @Override
    protected String getMainTaskName() {
        return Messages.operation_deleteResourceProgress;
    }

    @Override
    protected void processElement(IJavaScriptElement element) throws JavaScriptModelException {
        switch (element.getElementType()) {
            case 5: 
            case 6: {
                this.deleteResource(element.getResource(), this.force ? 3 : 2);
                break;
            }
            case 4: {
                this.deletePackageFragment((IPackageFragment)element);
                break;
            }
            default: {
                throw new JavaScriptModelException(new JavaModelStatus(967, element));
            }
        }
        if (element instanceof IOpenable) {
            ((IOpenable)((Object)element)).close();
        }
    }

    @Override
    protected void verify(IJavaScriptElement element) throws JavaScriptModelException {
        IResource resource;
        int type;
        if (element == null || !element.exists()) {
            this.error(969, element);
        }
        if ((type = element.getElementType()) <= 3 || type > 5) {
            this.error(967, element);
        }
        if ((resource = element.getResource()) instanceof IFolder && resource.isLinked()) {
            this.error(995, element);
        }
    }
}

