/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jst.jsf.common.internal.types.LiteralType;
import org.eclipse.jst.jsf.common.internal.types.TypeCoercionException;

public class StringLiteralType
extends LiteralType {
    private final String _literalValue;

    public StringLiteralType(String value) {
        super("Ljava.lang.String;");
        this._literalValue = value;
    }

    @Override
    public Number coerceToNumber(Class T) throws TypeCoercionException {
        try {
            if (T == BigInteger.class) {
                if ("".equals(this._literalValue)) {
                    return BigInteger.ZERO;
                }
                return new BigInteger(this._literalValue);
            }
            if (T == BigDecimal.class) {
                if ("".equals(this._literalValue)) {
                    return new BigDecimal(0.0);
                }
                return new BigDecimal(this._literalValue);
            }
            if (T == Double.class || T == Double.TYPE) {
                if ("".equals(this._literalValue)) {
                    return new Double(0.0);
                }
                return Double.valueOf(this._literalValue);
            }
            if (T == Float.class || T == Float.TYPE) {
                if ("".equals(this._literalValue)) {
                    return new Float(0.0);
                }
                return Float.valueOf(this._literalValue);
            }
            if (T == Long.class || T == Long.TYPE) {
                if ("".equals(this._literalValue)) {
                    return 0L;
                }
                return Long.valueOf(this._literalValue);
            }
            if (T == Integer.class || T == Integer.TYPE) {
                if ("".equals(this._literalValue)) {
                    return 0;
                }
                return Integer.valueOf(this._literalValue);
            }
            if (T == Short.class || T == Short.TYPE) {
                if ("".equals(this._literalValue)) {
                    return (short)0;
                }
                return Short.valueOf(this._literalValue);
            }
            if (T == Byte.class || T == Byte.TYPE) {
                if ("".equals(this._literalValue)) {
                    return (byte)0;
                }
                return Byte.valueOf(this._literalValue);
            }
            throw new IllegalArgumentException("Not a target numeric type: " + String.valueOf(T));
        }
        catch (NumberFormatException nfe) {
            throw new TypeCoercionException(nfe);
        }
    }

    @Override
    public String getLiteralValue() {
        return this._literalValue;
    }

    @Override
    public Object getLiteralValueRaw() {
        return this._literalValue;
    }

    @Override
    public Boolean coerceToBoolean() throws TypeCoercionException {
        return Boolean.valueOf(this._literalValue);
    }
}

