/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.actions;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsView;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsViewCategoryFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class AnnotationsViewFilterAction
extends Action {
    private StructuredViewer viewer;
    private AnnotationsViewCategoryFilter categoryFilter;

    public AnnotationsViewFilterAction(AnnotationsView annotationsView, StructuredViewer viewer, String text) {
        super(text);
        this.viewer = viewer;
        this.setImageDescriptor(JAXWSUIPlugin.getImageDescriptor("icons/elcl16/filter_ps.gif"));
        this.categoryFilter = new AnnotationsViewCategoryFilter(annotationsView, viewer);
    }

    public void run() {
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(this.viewer.getControl().getShell(), (Object)AnnotationsManager.getAnnotationCategories(), (IStructuredContentProvider)new AnnotationsCategoryDialogContentProvider(), (ILabelProvider)new AnnotationsCategoryDialogLabelProvider(), JAXWSUIMessages.ANNOTATIONS_VIEW_FILTER_ACTION_SELECT_CATEGORIES_MESSAGE);
        listSelectionDialog.setInitialElementSelections(this.categoryFilter.getCategories());
        int returnValue = listSelectionDialog.open();
        if (returnValue == 0) {
            Object[] result = listSelectionDialog.getResult();
            this.categoryFilter.filterAnnotations(Arrays.asList(result));
        }
    }

    public void init() {
        this.categoryFilter.init();
    }

    public void saveState() {
        this.categoryFilter.saveState();
    }

    private static class AnnotationsCategoryDialogContentProvider
    implements IStructuredContentProvider {
        private AnnotationsCategoryDialogContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class AnnotationsCategoryDialogLabelProvider
    extends LabelProvider {
        private AnnotationsCategoryDialogLabelProvider() {
        }

        public String getText(Object element) {
            return element.toString();
        }

        public Image getImage(Object element) {
            return null;
        }
    }
}

