/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.factory.Factory;
import org.eclipse.jpt.common.utility.internal.ClassTools;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.Transformer;

public final class MapTools {
    public static <K, V> V get(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        if (value != null || map.containsKey(key)) {
            return value;
        }
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static <K, V> V get_(Map<K, V> map, K key, V defaultValue) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static <K, V> V get(Map<K, V> map, K key, Factory<? extends V> factory) {
        V value = map.get(key);
        if (value != null || map.containsKey(key)) {
            return value;
        }
        V defaultValue = factory.create();
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static <K, V> V get_(Map<K, V> map, K key, Factory<? extends V> factory) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        V defaultValue = factory.create();
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static <K, V, C extends V> V get(Map<K, V> map, K key, Class<C> clazz) {
        return MapTools.get(map, key, clazz, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <K, V, C extends V> V get_(Map<K, V> map, K key, Class<C> clazz) {
        return MapTools.get_(map, key, clazz, ClassTools.EMPTY_ARRAY, ObjectTools.EMPTY_OBJECT_ARRAY);
    }

    public static <K, V, C extends V> V get(Map<K, V> map, K key, Class<C> clazz, Class<?> parameterType, Object argument) {
        return MapTools.get(map, key, clazz, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <K, V, C extends V> V get_(Map<K, V> map, K key, Class<C> clazz, Class<?> parameterType, Object argument) {
        return MapTools.get_(map, key, clazz, new Class[]{parameterType}, new Object[]{argument});
    }

    public static <K, V> V get(Map<K, V> map, K key, Class<? extends V> clazz, Class<?>[] parameterTypes, Object[] arguments) {
        V value = map.get(key);
        if (value != null || map.containsKey(key)) {
            return value;
        }
        V defaultValue = ClassTools.newInstance(clazz, parameterTypes, arguments);
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static <K, V> V get_(Map<K, V> map, K key, Class<? extends V> clazz, Class<?>[] parameterTypes, Object[] arguments) {
        V value = map.get(key);
        if (value != null) {
            return value;
        }
        V defaultValue = ClassTools.newInstance(clazz, parameterTypes, arguments);
        map.put(key, defaultValue);
        return defaultValue;
    }

    public static <K, V, E extends V> V add(Map<K, V> map, E value, Transformer<? super E, ? extends K> keyTransformer) {
        return map.put(keyTransformer.transform(value), value);
    }

    public static <K, V, E> V add(Map<K, V> map, E element, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        return map.put(keyTransformer.transform(element), valueTransformer.transform(element));
    }

    public static <K, V, E extends V> void addAll(Map<K, V> map, Iterable<E> values, Transformer<? super E, ? extends K> keyTransformer) {
        MapTools.addAll(map, values.iterator(), keyTransformer);
    }

    public static <K, V, E extends V> void addAll(Map<K, V> map, Iterator<E> values, Transformer<? super E, ? extends K> keyTransformer) {
        while (values.hasNext()) {
            MapTools.add(map, values.next(), keyTransformer);
        }
    }

    public static <K, V, E extends V> void addAll(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, E ... values) {
        E[] EArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            E value = EArray[n2];
            MapTools.add(map, value, keyTransformer);
            ++n2;
        }
    }

    public static <K, V, E> void addAll(Map<K, V> map, Iterable<E> elements, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        MapTools.addAll(map, elements.iterator(), keyTransformer, valueTransformer);
    }

    public static <K, V, E> void addAll(Map<K, V> map, Iterator<E> elements, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer) {
        while (elements.hasNext()) {
            MapTools.add(map, elements.next(), keyTransformer, valueTransformer);
        }
    }

    public static <K, V, E> void addAll(Map<K, V> map, Transformer<? super E, ? extends K> keyTransformer, Transformer<? super E, ? extends V> valueTransformer, E ... elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            MapTools.add(map, element, keyTransformer, valueTransformer);
            ++n2;
        }
    }

    public static <K, V> void putAll(Map<K, V> map, List<? extends K> keys, List<? extends V> values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("unequal sizes - keys: " + keys.size() + " values: " + values.size());
        }
        int i = 0;
        while (i < keys.size()) {
            map.put(keys.get(i), values.get(i));
            ++i;
        }
    }

    public static <K, V> void putAll(Map<K, V> map, K[] keys, V[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("unequal lengths - keys: " + keys.length + " values: " + values.length);
        }
        int i = 0;
        while (i < keys.length) {
            map.put(keys[i], values[i]);
            ++i;
        }
    }

    public static boolean containsAllKeys(Map<?, ?> map, Iterable<?> keys) {
        return MapTools.containsAllKeys(map, keys.iterator());
    }

    public static boolean containsAllKeys(Map<?, ?> map, Iterator<?> keys) {
        while (keys.hasNext()) {
            if (map.containsKey(keys.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllKeys(Map<?, ?> map, Object ... keys) {
        int i = keys.length;
        while (i-- > 0) {
            if (map.containsKey(keys[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllValues(Map<?, ?> map, Iterable<?> values) {
        return MapTools.containsAllValues(map, values.iterator());
    }

    public static boolean containsAllValues(Map<?, ?> map, Iterator<?> values) {
        while (values.hasNext()) {
            if (map.containsValue(values.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean containsAllValues(Map<?, ?> map, Object ... values) {
        int i = values.length;
        while (i-- > 0) {
            if (map.containsValue(values[i])) continue;
            return false;
        }
        return true;
    }

    public static void removeAll(Map<?, ?> map, Iterable<?> keys) {
        MapTools.removeAll(map, keys.iterator());
    }

    public static void removeAll(Map<?, ?> map, Iterator<?> keys) {
        while (keys.hasNext()) {
            map.remove(keys.next());
        }
    }

    public static void removeAll(Map<?, ?> map, Object ... keys) {
        int i = keys.length;
        while (i-- > 0) {
            map.remove(keys[i]);
        }
    }

    public static void retainAll(Map<?, ?> map, Collection<?> keys) {
        if (keys.isEmpty()) {
            map.clear();
        } else {
            MapTools.retainAll_(map, keys);
        }
    }

    public static void retainAll(Map<?, ?> map, Iterable<?> keys) {
        MapTools.retainAll(map, keys.iterator());
    }

    public static void retainAll(Map<?, ?> map, Iterable<?> keys, int keysSize) {
        MapTools.retainAll(map, keys.iterator(), keysSize);
    }

    public static void retainAll(Map<?, ?> map, Iterator<?> keys) {
        if (keys.hasNext()) {
            MapTools.retainAll_(map, CollectionTools.hashSet(keys));
        } else {
            map.clear();
        }
    }

    public static void retainAll(Map<?, ?> map, Iterator<?> keys, int keysSize) {
        if (keys.hasNext()) {
            MapTools.retainAll_(map, CollectionTools.hashSet(keys, keysSize));
        } else {
            map.clear();
        }
    }

    public static void retainAll(Map<?, ?> map, Object ... keys) {
        if (keys.length > 0) {
            MapTools.retainAll_(map, CollectionTools.hashSet(keys));
        } else {
            map.clear();
        }
    }

    private static void retainAll_(Map<?, ?> map, Collection<?> keys) {
        Iterator<Map.Entry<?, ?>> stream = map.entrySet().iterator();
        while (stream.hasNext()) {
            Map.Entry<?, ?> entry = stream.next();
            if (keys.contains(entry.getKey())) continue;
            stream.remove();
        }
    }

    public static <K, V> HashMap<K, V> invert(Map<? extends V, ? extends K> map) {
        HashMap<K, V> result = new HashMap<K, V>((int)((double)map.size() / 0.75));
        for (Map.Entry<V, K> entry : map.entrySet()) {
            result.put(entry.getValue(), entry.getKey());
        }
        return result;
    }

    public static <K, V> HashMap<K, V> filter(Map<? extends K, ? extends V> map, Predicate<? super V> filter) {
        HashMap<K, V> result = new HashMap<K, V>((int)((double)map.size() / 0.75));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V value = entry.getValue();
            if (!filter.evaluate(value)) continue;
            result.put(entry.getKey(), value);
        }
        return result;
    }

    public static <K, V1, V2> HashMap<K, V2> transform(Map<? extends K, V1> map, Transformer<? super V1, ? extends V2> transformer) {
        HashMap<K, V2> result = new HashMap<K, V2>((int)((double)map.size() / 0.75));
        for (Map.Entry<K, V1> entry : map.entrySet()) {
            result.put(entry.getKey(), transformer.transform(entry.getValue()));
        }
        return result;
    }

    private MapTools() {
        throw new UnsupportedOperationException();
    }
}

