/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.validation;

import junit.framework.TestCase;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.validation.MarkupValidator;

public class TestMarkupValidator
extends TestCase {
    private MarkupValidator fValidator;
    private IReporter fReporter;
    private IStructuredDocument fDocument;

    private boolean validateError(String contents) {
        this.fDocument.set(contents);
        this.fValidator.validate((IRegion)new Region(0, this.fDocument.getLength()), null, this.fReporter);
        return this.fReporter.getMessages().isEmpty();
    }

    protected void setUp() throws Exception {
        if (this.fValidator == null) {
            this.fValidator = new MarkupValidator();
        }
        if (this.fReporter == null) {
            this.fReporter = new IncrementalReporter(null);
        }
        if (this.fDocument == null) {
            this.fDocument = StructuredModelManager.getModelManager().createStructuredDocumentFor("onfire.xml", "", null);
        }
        this.fValidator.connect((IDocument)this.fDocument);
    }

    protected void tearDown() throws Exception {
        this.fValidator.disconnect((IDocument)this.fDocument);
    }

    public void testAttributesInEndTag() {
        TestMarkupValidator.assertTrue((String)"Should get attributes in end tag error", (!this.validateError("<stop></stop drop=\"roll\">") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should not get attributes in end tag error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testClosingBracket() {
        TestMarkupValidator.assertTrue((String)"Should get closing bracket error", (!this.validateError("<stop </stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should not get closing bracket error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testEmptyTag() {
        TestMarkupValidator.assertTrue((String)"Should get empty tag error", (!this.validateError("<>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should not get empty tag error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testAttributeValue() {
        TestMarkupValidator.assertTrue((String)"Should get attribute has no value error", (!this.validateError("<stop drop></stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should get attribute missing value error", (!this.validateError("<stop drop=></stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should not get attribute missing value error", (boolean)this.validateError("<stop drop=\"roll\"></stop>"));
    }

    public void testSpaceBeforeName() {
        TestMarkupValidator.assertTrue((String)"Should get tag has space before name error", (!this.validateError("<    stop></stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should not get tag has space before name error", (boolean)this.validateError("<stop></stop>"));
    }

    public void testQuotesForAttributeValues() {
        TestMarkupValidator.assertTrue((String)"Should get missing end quote error", (!this.validateError("<stop drop=\"></stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should get missing end quote error", (!this.validateError("<stop drop=\"roll></stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should get missing end quote error", (!this.validateError("<stop drop='></stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should get missing quotes error", (!this.validateError("<stop drop=roll></stop>") ? 1 : 0) != 0);
        TestMarkupValidator.assertTrue((String)"Should not get missing end quote error", (boolean)this.validateError("<stop drop=\"\"></stop>"));
        TestMarkupValidator.assertTrue((String)"Should not get missing end quote error", (boolean)this.validateError("<stop drop=\"roll\"></stop>"));
        TestMarkupValidator.assertTrue((String)"Should not get missing end quote error", (boolean)this.validateError("<stop drop=''></stop>"));
        TestMarkupValidator.assertTrue((String)"Should not get missing quotes error", (boolean)this.validateError("<stop drop='roll'></stop>"));
    }
}

