/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.write;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.facesconfig.emf.AttributeType;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.PropertyType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorClassType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorIdType;
import org.eclipse.jst.jsf.facesconfig.emf.ValidatorType;
import org.eclipse.jst.jsf.facesconfig.tests.util.CommonStructuresUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.tests.util.WizardUtil;
import org.eclipse.jst.jsf.facesconfig.tests.write.BaseWriteTestCase;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class WriteValidatorTestCase
extends BaseWriteTestCase {
    IProject project = null;
    protected static final String VALIDATOR = "validator";
    private static final String VALIDATOR_CLASS = CommonStructuresUtil.createPreficedString("validator", "class");
    private static final String VALIDATOR_ID = CommonStructuresUtil.createPreficedString("validator", "id");

    public WriteValidatorTestCase(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        WizardUtil.createProject(this.getName());
        this.project = WizardUtil.getTestProject(this.getName());
    }

    public void testWriteValidator() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForWrite();
            WriteValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            FacesConfigPackage facesConfigPackage = FacesConfigPackage.eINSTANCE;
            FacesConfigFactory facesConfigFactory = facesConfigPackage.getFacesConfigFactory();
            ValidatorType validator = facesConfigFactory.createValidatorType();
            ValidatorIdType validatorIdType = facesConfigFactory.createValidatorIdType();
            validatorIdType.setTextContent(VALIDATOR_ID);
            validatorIdType.setId(CommonStructuresUtil.createPreficedString(VALIDATOR_ID, "id"));
            validator.setValidatorId(validatorIdType);
            ValidatorClassType validatorClassType = facesConfigFactory.createValidatorClassType();
            validatorClassType.setTextContent(VALIDATOR_CLASS);
            validatorClassType.setId(CommonStructuresUtil.createPreficedString(VALIDATOR_CLASS, "id"));
            validator.setValidatorClass(validatorClassType);
            validator.getDescription().add((Object)CommonStructuresUtil.createDescription(VALIDATOR));
            validator.getDisplayName().add((Object)CommonStructuresUtil.createDisplayName(VALIDATOR));
            validator.getIcon().add((Object)CommonStructuresUtil.createIcon(VALIDATOR));
            validator.getAttribute().add((Object)CommonStructuresUtil.createAttribute(VALIDATOR));
            validator.getProperty().add((Object)CommonStructuresUtil.createProperty(VALIDATOR));
            validator.setId(VALIDATOR_ID);
            edit.getFacesConfig().getValidator().add((Object)validator);
            edit.save(null);
        }
        finally {
            if (edit != null) {
                edit.dispose();
                WriteValidatorTestCase.assertTrue((boolean)edit.isDisposed());
                edit = null;
            }
        }
        try {
            edit = this.getArtifactEditForRead();
            WriteValidatorTestCase.assertNotNull((Object)edit.getFacesConfig());
            ValidatorType validator = (ValidatorType)FacesConfigModelUtil.findEObjectElementById((List)edit.getFacesConfig().getValidator(), VALIDATOR_ID);
            WriteValidatorTestCase.assertNotNull((Object)validator);
            ValidatorIdType validatorIdType = validator.getValidatorId();
            WriteValidatorTestCase.assertEquals((String)VALIDATOR_ID, (String)validatorIdType.getTextContent());
            WriteValidatorTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(VALIDATOR_ID, "id"), (String)validatorIdType.getId());
            ValidatorClassType validatorClassType = validator.getValidatorClass();
            WriteValidatorTestCase.assertEquals((String)VALIDATOR_CLASS, (String)validatorClassType.getTextContent());
            WriteValidatorTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(VALIDATOR_CLASS, "id"), (String)validatorClassType.getId());
            WriteValidatorTestCase.assertEquals((int)1, (int)validator.getDescription().size());
            CommonStructuresUtil.assertMatchesDescription(VALIDATOR, (DescriptionType)validator.getDescription().get(0));
            WriteValidatorTestCase.assertEquals((int)1, (int)validator.getDisplayName().size());
            CommonStructuresUtil.assertMatchesDisplayName(VALIDATOR, (DisplayNameType)validator.getDisplayName().get(0));
            WriteValidatorTestCase.assertEquals((int)1, (int)validator.getIcon().size());
            CommonStructuresUtil.assertMatchesIcon(VALIDATOR, (IconType)validator.getIcon().get(0));
            WriteValidatorTestCase.assertEquals((int)1, (int)validator.getAttribute().size());
            CommonStructuresUtil.assertMatchAttribute(VALIDATOR, (AttributeType)validator.getAttribute().get(0));
            WriteValidatorTestCase.assertEquals((int)1, (int)validator.getProperty().size());
            CommonStructuresUtil.assertMatchProperty(VALIDATOR, (PropertyType)validator.getProperty().get(0));
            WriteValidatorTestCase.assertEquals((String)CommonStructuresUtil.createPreficedString(VALIDATOR, "id"), (String)validator.getId());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

