/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.tests.read;

import java.util.List;
import org.eclipse.jst.jsf.facesconfig.emf.DescriptionType;
import org.eclipse.jst.jsf.facesconfig.emf.DisplayNameType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.IconType;
import org.eclipse.jst.jsf.facesconfig.emf.RenderKitType;
import org.eclipse.jst.jsf.facesconfig.tests.read.BaseReadTestCase;
import org.eclipse.jst.jsf.facesconfig.tests.util.FacesConfigModelUtil;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigArtifactEdit;

public class ReadRenderKitTestCase
extends BaseReadTestCase {
    public ReadRenderKitTestCase(String name) {
        super(name);
    }

    public void testSingleRenderKit() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRenderKitTestCase.assertNotNull((Object)edit.getFacesConfig());
            ReadRenderKitTestCase.assertNotNull((Object)this.getRenderKit1(edit.getFacesConfig()));
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    RenderKitType getRenderKit1(FacesConfigType facesConfig) {
        return (RenderKitType)FacesConfigModelUtil.findEObjectElementById((List)facesConfig.getRenderKit(), "renderKit1");
    }

    public void testDescriptionGroup() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRenderKitTestCase.assertNotNull((Object)edit.getFacesConfig());
            RenderKitType renderKit = this.getRenderKit1(edit.getFacesConfig());
            ReadRenderKitTestCase.assertNotNull((Object)renderKit);
            DescriptionType descType = (DescriptionType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getDescription(), "renderKit1Description");
            ReadRenderKitTestCase.assertNotNull((Object)descType);
            ReadRenderKitTestCase.assertEquals((String)"Render kit Desc", (String)descType.getTextContent());
            DisplayNameType displayName = (DisplayNameType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getDisplayName(), "renderKit1DisplayName");
            ReadRenderKitTestCase.assertNotNull((Object)displayName);
            ReadRenderKitTestCase.assertEquals((String)"Render kit disp name", (String)displayName.getTextContent());
            IconType iconType = (IconType)FacesConfigModelUtil.findEObjectElementById((List)renderKit.getIcon(), "renderKit1Icon");
            ReadRenderKitTestCase.assertNotNull((Object)iconType);
            ReadRenderKitTestCase.assertEquals((String)"small-renderkit-icon", (String)iconType.getSmallIcon().getTextContent());
            ReadRenderKitTestCase.assertEquals((String)"large-renderkit-icon", (String)iconType.getLargeIcon().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testSingleValuedProperties() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRenderKitTestCase.assertNotNull((Object)edit.getFacesConfig());
            RenderKitType renderKit = this.getRenderKit1(edit.getFacesConfig());
            ReadRenderKitTestCase.assertNotNull((Object)renderKit);
            ReadRenderKitTestCase.assertEquals((String)"render-kit-Id", (String)renderKit.getRenderKitId().getTextContent());
            ReadRenderKitTestCase.assertEquals((String)"render-kit-class", (String)renderKit.getRenderKitClass().getTextContent());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    public void testRenderer() {
        FacesConfigArtifactEdit edit = null;
        try {
            edit = this.getArtifactEditForRead();
            ReadRenderKitTestCase.assertNotNull((Object)edit.getFacesConfig());
            RenderKitType renderKit = this.getRenderKit1(edit.getFacesConfig());
            ReadRenderKitTestCase.assertNotNull((Object)renderKit);
            ReadRenderKitTestCase.assertEquals((int)1, (int)renderKit.getRenderer().size());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }
}

