/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.tests;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsf.context.symbol.IMapTypeDescriptor;
import org.eclipse.jst.jsf.context.symbol.IPropertySymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.tests.ContextSymbolTestPlugin;
import org.eclipse.jst.jsf.context.symbol.tests.ModelBaseTestCase;
import org.eclipse.jst.jsf.designtime.internal.symbols.ResourceBundleMapSourceFactory;
import org.eclipse.jst.jsf.test.util.JSFTestUtil;
import org.eclipse.jst.jsf.test.util.TestFileResource;

public class TestIMapTypeDescriptor
extends ModelBaseTestCase {
    private IFile _propertyFile;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestFileResource resource = new TestFileResource();
        resource.load(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/bundle.properties.data");
        this._propertyFile = this._jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "res", "Bundle.properties");
        TestIMapTypeDescriptor.assertTrue((boolean)this._propertyFile.isAccessible());
    }

    public void testResBoundDescriptor() throws JavaModelException, IOException, CoreException {
        Map mapSource = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject(), (String)"res.Bundle");
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource(mapSource);
        Map<String, IPropertySymbol> map = this.createMap(typeDesc);
        TestIMapTypeDescriptor.assertEquals((int)3, (int)map.size());
        TestIMapTypeDescriptor.assertTrue((boolean)map.containsKey("simpleprop"));
        TestIMapTypeDescriptor.assertFalse((boolean)map.get("simpleprop").isIntermediate());
        TestIMapTypeDescriptor.assertTrue((boolean)map.containsKey("two"));
        TestIMapTypeDescriptor.assertTrue((boolean)map.get("two").isIntermediate());
        TestIMapTypeDescriptor.assertTrue((boolean)map.containsKey("three"));
        TestIMapTypeDescriptor.assertTrue((boolean)map.get("three").isIntermediate());
    }

    public void testDeleteBundle() throws Exception {
        Map mapSource = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject(), (String)"res.Bundle");
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource(mapSource);
        Map<String, IPropertySymbol> map = this.createMap(typeDesc);
        TestIMapTypeDescriptor.assertEquals((int)3, (int)map.size());
        this.deleteAndWaitFor((IResource)this._propertyFile);
        EList properties = typeDesc.getProperties();
        TestIMapTypeDescriptor.assertEquals((int)0, (int)properties.size());
    }

    public void testDeleteAndRecreate() throws Exception {
        Map mapSource = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject(), (String)"res.Bundle");
        IMapTypeDescriptor typeDesc = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc.setMapSource(mapSource);
        Map<String, IPropertySymbol> map = this.createMap(typeDesc);
        TestIMapTypeDescriptor.assertEquals((int)3, (int)map.size());
        this.deleteAndWaitFor((IResource)this._propertyFile);
        TestFileResource resource = new TestFileResource();
        resource.load(ContextSymbolTestPlugin.getDefault().getBundle(), "/testdata/bundle2.properties.data");
        this._propertyFile = this._jdtTestEnvironment.addResourceFile("src", (InputStream)new ByteArrayInputStream(resource.toBytes()), "res", "Bundle.properties");
        Map mapSource2 = ResourceBundleMapSourceFactory.getResourceBundleMapSource((IProject)this._jdtTestEnvironment.getProjectEnvironment().getTestProject(), (String)"res.Bundle");
        IMapTypeDescriptor typeDesc2 = SymbolFactory.eINSTANCE.createIMapTypeDescriptor();
        typeDesc2.setMapSource(mapSource2);
        Map<String, IPropertySymbol> map2 = this.createMap(typeDesc2);
        TestIMapTypeDescriptor.assertEquals((int)4, (int)map2.size());
    }

    private void deleteAndWaitFor(IResource res) {
        JSFTestUtil.safeDelete((IResource)res, (int)10, (int)500);
        int i = 0;
        while (i < 10) {
            if (res.isAccessible()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++i;
        }
        TestIMapTypeDescriptor.assertFalse((boolean)res.isAccessible());
    }

    private Map<String, IPropertySymbol> createMap(IMapTypeDescriptor desc) {
        HashMap<String, IPropertySymbol> map = new HashMap<String, IPropertySymbol>();
        EList properties = desc.getProperties();
        for (IPropertySymbol prop : properties) {
            map.put(prop.getName(), prop);
        }
        return map;
    }
}

