/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.integration.navigator.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.jaxws.dom.integration.internal.plugin.DomIntegrationMessages;
import org.eclipse.jst.ws.jaxws.dom.runtime.DomUtil;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IJavaWebServiceElement;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IServiceEndpointInterface;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebMethod;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebParam;
import org.eclipse.jst.ws.jaxws.dom.runtime.api.IWebService;
import org.eclipse.jst.ws.jaxws.utils.logging.ILogger;
import org.eclipse.jst.ws.jaxws.utils.logging.Logger;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class OpenWSResourceAction
extends SelectionListenerAction
implements IActionDelegate2 {
    protected Object srcObject;
    private IJavaProject project;
    private IServiceEndpointInterface sei;
    private DomUtil util = DomUtil.INSTANCE;

    protected OpenWSResourceAction() {
        this(DomIntegrationMessages.OpenWSResourceAction_Name);
    }

    protected OpenWSResourceAction(String text) {
        super(text);
    }

    public boolean isEnabled() {
        boolean isEnabled;
        boolean bl = isEnabled = super.isEnabled() && this.project != null;
        if (this.srcObject instanceof IWebService) {
            return isEnabled;
        }
        if (this.srcObject instanceof IServiceEndpointInterface) {
            return isEnabled;
        }
        if (this.srcObject instanceof IWebMethod) {
            return isEnabled;
        }
        if (this.srcObject instanceof IWebParam) {
            return isEnabled;
        }
        return false;
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        IWebMethod webMethod = null;
        IWebParam webParam = null;
        if (this.srcObject instanceof IWebMethod) {
            webMethod = (IWebMethod)this.srcObject;
            this.srcObject = this.sei;
        }
        if (this.srcObject instanceof IWebParam) {
            webParam = (IWebParam)this.srcObject;
            webMethod = (IWebMethod)webParam.eContainer();
            this.srcObject = this.sei;
        }
        try {
            ICompilationUnit cu = this.project.findType(((IJavaWebServiceElement)this.srcObject).getImplementation()).getCompilationUnit();
            IWorkbenchPage page = this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorDescriptor desc = this.getWorkbench().getEditorRegistry().getDefaultEditor(cu.getResource().getName());
            cu = this.getCUToOpen(cu, webMethod);
            if (cu == null) {
                this.logger().logError("Unable to locate containing CU to open");
                return;
            }
            IFile file = this.getWorkspace().getRoot().findFilesForLocation(cu.getResource().getLocation())[0];
            IEditorPart editor = page.openEditor((IEditorInput)new FileEditorInput(file), desc.getId());
            IMarker marker = file.createMarker("org.eclipse.core.resources.textmarker");
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("charStart", this.getMarkerPosition(cu, webMethod, false));
            map.put("charEnd", this.getMarkerPosition(cu, webMethod, true));
            marker.setAttributes(map);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
        catch (PartInitException pie) {
            this.logger().logError("Unable to open part editor", (Throwable)pie);
        }
        catch (CoreException ce) {
            this.logger().logError(ce.getMessage(), (Throwable)ce);
        }
    }

    private int getMarkerPosition(ICompilationUnit cu, IWebMethod webMethod, boolean endPos) throws JavaModelException {
        IType[] types = cu.getTypes();
        int ii = 0;
        while (ii < types.length) {
            if (webMethod == null) {
                return this.getPosition((IMember)types[ii], endPos);
            }
            IMethod method = this.util.findMethod(types[ii], webMethod);
            if (method != null) {
                return this.getPosition((IMember)method, endPos);
            }
            ++ii;
        }
        return 0;
    }

    private int getPosition(IMember member, boolean endPos) throws JavaModelException {
        return member.getNameRange().getOffset() + (endPos ? member.getNameRange().getLength() : 0);
    }

    private ICompilationUnit getCUToOpen(ICompilationUnit cu, IWebMethod webMethod) {
        if (webMethod == null) {
            return cu;
        }
        try {
            IType[] types = cu.getTypes();
            int ii = 0;
            while (ii < types.length) {
                IMethod method = this.util.findMethod(types[ii], webMethod);
                if (method != null) {
                    return types[ii].getCompilationUnit();
                }
                ++ii;
            }
            ii = 0;
            while (ii < types.length) {
                ICompilationUnit cuToOpen;
                IType[] superIntfTypes = types[ii].newSupertypeHierarchy(null).getSuperInterfaces(types[ii]);
                int jj = 0;
                while (jj < superIntfTypes.length) {
                    cuToOpen = this.getCUToOpen(superIntfTypes[jj].getCompilationUnit(), webMethod);
                    if (cuToOpen != null) {
                        return cuToOpen;
                    }
                    ++jj;
                }
                IType superClassType = types[ii].newSupertypeHierarchy(null).getSuperclass(types[ii]);
                cuToOpen = this.getCUToOpen(superClassType.getCompilationUnit(), webMethod);
                if (cuToOpen != null) {
                    return cuToOpen;
                }
                ++ii;
            }
        }
        catch (JavaModelException jme) {
            this.logger().logError(jme.getMessage(), (Throwable)jme);
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.updateSelection((IStructuredSelection)selection);
    }

    public void selectionChanged(IStructuredSelection selection, IJavaProject project, IServiceEndpointInterface sei) {
        super.selectionChanged(selection);
        this.project = project;
        this.sei = sei;
    }

    public boolean updateSelection(IStructuredSelection s) {
        if (!super.updateSelection(s)) {
            return false;
        }
        this.srcObject = s.getFirstElement();
        return true;
    }

    public void dispose() {
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }

    private ILogger logger() {
        return new Logger();
    }

    private IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }
}

