/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.features.DefaultDeleteFeature;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ClickRemoveAttributeButtonFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.AbstractRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IBidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IUnidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IsARelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.IJPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteRelationFeature
extends DefaultDeleteFeature {
    private static IJPAEditorUtil ut = null;

    public DeleteRelationFeature(IJPAEditorFeatureProvider fp) {
        super((IFeatureProvider)fp);
        ut = fp.getJPAEditorUtil();
    }

    public boolean canDelete(IDeleteContext context) {
        return true;
    }

    public boolean isAvailable(IContext context) {
        return true;
    }

    public boolean canExecute(IContext context) {
        return true;
    }

    protected String getQuestionToUser() {
        return JPAEditorMessages.DeleteRelationFeature_deleteRelationQuestion;
    }

    public void delete(IDeleteContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object businessObjectForPictogramElement = this.getBusinessObjectForPictogramElement(pe);
        if (businessObjectForPictogramElement != null && !this.getUserDecision(context)) {
            return;
        }
        this.preDelete(context);
        if (businessObjectForPictogramElement instanceof AbstractRelation) {
            this.deleteAbstractRelation(businessObjectForPictogramElement);
        } else if (businessObjectForPictogramElement instanceof HasReferanceRelation) {
            this.deleteEmbeddedRelation(businessObjectForPictogramElement);
        } else if (businessObjectForPictogramElement instanceof IsARelation) {
            this.deleteInheritanceRelation(businessObjectForPictogramElement);
        }
        this.postDelete(context);
    }

    private void deleteInheritanceRelation(Object businessObjectForPictogramElement) {
        IsARelation rel = (IsARelation)businessObjectForPictogramElement;
        PersistentType superclass = rel.getSuperclass();
        PersistentType subclass = rel.getSubclass();
        JpaArtifactFactory.instance().buildHierarchy(superclass, subclass, false);
        ut.getCompilationUnit(subclass);
        this.getFeatureProvider().addJPTForUpdate(subclass.getName());
    }

    private void deleteEmbeddedRelation(Object businessObjectForPictogramElement) {
        HasReferanceRelation rel = (HasReferanceRelation)businessObjectForPictogramElement;
        PersistentAttribute attribute = rel.getEmbeddedAnnotatedAttribute();
        PictogramElement textShape = this.getFeatureProvider().getPictogramElementForBusinessObject(attribute);
        if (textShape == null) {
            return;
        }
        ClickRemoveAttributeButtonFeature feat = new ClickRemoveAttributeButtonFeature(this.getFeatureProvider());
        DeleteContext delCtx = new DeleteContext(textShape);
        feat.delete((IDeleteContext)delCtx, false);
    }

    private void deleteAbstractRelation(Object businessObjectForPictogramElement) {
        IRelation relation;
        AbstractRelation rel = (AbstractRelation)businessObjectForPictogramElement;
        if (rel instanceof IUnidirectionalRelation) {
            relation = (IUnidirectionalRelation)((Object)rel);
            PersistentAttribute attribute = relation.getAnnotatedAttribute();
            PictogramElement textShape = this.getFeatureProvider().getPictogramElementForBusinessObject(attribute);
            if (textShape == null) {
                return;
            }
            ClickRemoveAttributeButtonFeature feat = new ClickRemoveAttributeButtonFeature(this.getFeatureProvider());
            DeleteContext delCtx = new DeleteContext(textShape);
            feat.delete((IDeleteContext)delCtx, false);
        }
        if (rel instanceof IBidirectionalRelation) {
            relation = (IBidirectionalRelation)((Object)rel);
            ClickRemoveAttributeButtonFeature feat = new ClickRemoveAttributeButtonFeature(this.getFeatureProvider());
            PersistentAttribute ownerAttribute = relation.getOwnerAnnotatedAttribute();
            PictogramElement ownerAttributeTextShape = this.getFeatureProvider().getPictogramElementForBusinessObject(ownerAttribute);
            if (ownerAttributeTextShape == null) {
                return;
            }
            DeleteContext deleteOwnerAttributeContext = new DeleteContext(ownerAttributeTextShape);
            feat.delete((IDeleteContext)deleteOwnerAttributeContext, false);
            PersistentAttribute inverseAttribute = relation.getInverseAnnotatedAttribute();
            PictogramElement inverseAttributeTextShape = this.getFeatureProvider().getPictogramElementForBusinessObject(inverseAttribute);
            if (inverseAttributeTextShape == null) {
                return;
            }
            DeleteContext deleteInverseAttributeContext = new DeleteContext(inverseAttributeTextShape);
            feat.delete((IDeleteContext)deleteInverseAttributeContext, false);
        }
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    protected boolean getUserDecision(IDeleteContext context) {
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)JPAEditorMessages.DeleteFeature_deleteConfirm, (String)JPAEditorMessages.DeleteRelationFeature_deleteRelationQuestion);
    }
}

