/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.iterable;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;

public class FilteringIterable<E>
implements Iterable<E> {
    private final Iterable<? extends E> iterable;
    private final Predicate<? super E> predicate;

    public FilteringIterable(Iterable<? extends E> iterable, Predicate<? super E> predicate) {
        if (iterable == null || predicate == null) {
            throw new NullPointerException();
        }
        this.iterable = iterable;
        this.predicate = predicate;
    }

    @Override
    public Iterator<E> iterator() {
        return IteratorTools.filter(this.iterable.iterator(), this.predicate);
    }

    public String toString() {
        return ListTools.arrayList(this).toString();
    }
}

