/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.provider;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.section.ManagedBeanScopeTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ManagedBeanLabelProvider
extends LabelProvider {
    private static final String SCOPE_IMAGE_FILE = "Scope.gif";
    private static final String SCOPE_NONE_IMAGE_FILE = "Scope_None.gif";
    private static final String SCOPE_APPLICATION_IMAGE_FILE = "Scope_Application.gif";
    private static final String SCOPE_REQUEST_IMAGE_FILE = "Scope_Request.gif";
    private static final String SCOPE_SESSION_IMAGE_FILE = "Scope_Session.gif";
    private static final String SCOPE_VIEW_IMAGE_FILE = "Scope_View.gif";
    private static final String MANAGED_BEAN_IMAGE_FILE = "facesconfig/FacesConfig_ManagedBean.gif";
    private Map imageTable;

    public String getText(Object obj) {
        String text = "";
        if (obj instanceof ManagedBeanType) {
            ManagedBeanType bean = (ManagedBeanType)obj;
            if (bean.getManagedBeanName() != null) {
                text = bean.getManagedBeanName().getTextContent();
            }
            if ((text == null || text.length() < 1) && bean.getManagedBeanClass() != null) {
                text = bean.getManagedBeanClass().getTextContent();
            }
        } else if (obj instanceof ManagedBeanScopeTreeItem) {
            text = ((ManagedBeanScopeTreeItem)obj).getScope();
        }
        return text;
    }

    public Image getImage(Object obj) {
        ImageDescriptor imageDesc = null;
        if (obj instanceof ManagedBeanType) {
            imageDesc = EditorPlugin.getDefault().getImageDescriptor(MANAGED_BEAN_IMAGE_FILE);
        } else if (obj instanceof ManagedBeanScopeTreeItem) {
            ManagedBeanScopeTreeItem scopeTreeItem = (ManagedBeanScopeTreeItem)obj;
            imageDesc = "session".equals(scopeTreeItem.getScope()) ? EditorPlugin.getDefault().getImageDescriptor(SCOPE_SESSION_IMAGE_FILE) : ("request".equals(scopeTreeItem.getScope()) ? EditorPlugin.getDefault().getImageDescriptor(SCOPE_REQUEST_IMAGE_FILE) : ("application".equals(scopeTreeItem.getScope()) ? EditorPlugin.getDefault().getImageDescriptor(SCOPE_APPLICATION_IMAGE_FILE) : ("none".equals(scopeTreeItem.getScope()) ? EditorPlugin.getDefault().getImageDescriptor(SCOPE_NONE_IMAGE_FILE) : ("view".equals(scopeTreeItem.getScope()) ? EditorPlugin.getDefault().getImageDescriptor(SCOPE_VIEW_IMAGE_FILE) : EditorPlugin.getDefault().getImageDescriptor(SCOPE_IMAGE_FILE)))));
        }
        if (imageDesc != null) {
            Image image;
            if (this.imageTable == null) {
                this.imageTable = new Hashtable(40);
            }
            if ((image = (Image)this.imageTable.get(imageDesc)) == null) {
                image = imageDesc.createImage();
                this.imageTable.put(imageDesc, image);
            }
            return image;
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }
}

