/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.ui.common;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsf.common.ui.internal.utils.WebrootUtil;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.pagedesigner.PageDesignerResources;
import org.eclipse.jst.pagedesigner.ui.common.TreeViewerSelectionDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

class CommonResourceDialog
extends TreeViewerSelectionDialog {
    private static final int WEBROOT_FOLDER_DEPTH = 2;
    private static final String STATUS_MESSAGE = PageDesignerResources.getInstance().getString("CommonResourceDialog.statusMessage");
    private String[] _suffixs = null;
    private CommonResourceFilter _filter;
    private static Logger _log = PDPlugin.getLogger(CommonResourceDialog.class);

    public CommonResourceDialog(Shell parentShell, IProject project) {
        super(parentShell, STATUS_MESSAGE);
        this.setContentProvider(new ProjectFileDialogContentProvider());
        this.setLabelProvider(WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this._filter = new CommonResourceFilter(project);
        this.setFilter(this._filter);
    }

    protected Object findInputElement() {
        return ResourcesPlugin.getWorkspace();
    }

    protected boolean isValidSelection(Object selection) {
        if (this.getContainerFullPath(selection) == null) {
            return false;
        }
        int depth = this.getContainerFullPath(selection).segmentCount();
        if (selection instanceof IFile && depth >= 2) {
            if (this._suffixs == null) {
                return true;
            }
            if (this._suffixs != null && Arrays.asList(this._suffixs).contains(((IFile)selection).getFileExtension())) {
                return true;
            }
        }
        return false;
    }

    public Object[] getResult() {
        Object[] objects = super.getResult();
        if (objects == null || objects.length == 0) {
            return null;
        }
        IPath returnValue = this.getWebRelatedPath(objects[0]);
        if (returnValue != null && !returnValue.toString().startsWith("/") && !returnValue.toString().startsWith("\\")) {
            Path tempPath = new Path("/" + returnValue.toString());
            returnValue = tempPath;
        }
        return new Object[]{returnValue};
    }

    private IPath getContainerFullPath(Object _selectedElement) {
        if (_selectedElement == null) {
            return null;
        }
        if (_selectedElement instanceof IContainer) {
            return ((IContainer)_selectedElement).getFullPath();
        }
        if (_selectedElement instanceof IFile) {
            return ((IFile)_selectedElement).getFullPath();
        }
        return null;
    }

    private IPath getWebRelatedPath(Object _selectedElement) {
        IPath result = null;
        if (_selectedElement == null) {
            return null;
        }
        if (_selectedElement instanceof IContainer) {
            result = ((IContainer)_selectedElement).getFullPath();
        } else if (_selectedElement instanceof IFile) {
            result = ((IFile)_selectedElement).getFullPath();
        }
        if (result != null && result.segmentCount() > 2) {
            result = result.removeFirstSegments(2);
        }
        return result;
    }

    static class CommonResourceFilter
    extends ViewerFilter {
        private String[] _suffixs = new String[]{"properties"};
        private Logger _mylog = PDPlugin.getLogger(CommonResourceFilter.class);
        private IProject _project;

        public String[] getSuffixs() {
            return this._suffixs;
        }

        public void setSuffixs(String[] _suffixs) {
            this._suffixs = _suffixs;
        }

        public CommonResourceFilter(IProject project) {
            this._project = project;
        }

        public void setProject(IProject project) {
            this._project = project;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IWorkspace) {
                return true;
            }
            if (element instanceof IFile) {
                if (!Arrays.asList(this._suffixs).contains(((IFile)element).getFileExtension())) return false;
                return true;
            }
            if (!(element instanceof IContainer)) return false;
            if (!((IContainer)element).isAccessible()) {
                return false;
            }
            if (element instanceof IProject) {
                IProject container = (IProject)element;
                if (!this.isWebAppProject(container)) return false;
                if (!this.isSameProject(container, this._project)) return false;
                return true;
            }
            if (!(element instanceof IFolder)) return false;
            IContainer container = (IContainer)element;
            try {
                if (container.getName().equals("WEB-INF")) return false;
                if (container.getName().equals("META-INF")) {
                    return false;
                }
                IResource[] members = container.members();
                int i = 0;
                while (true) {
                    if (i >= members.length) {
                        return false;
                    }
                    if (this.select(viewer, members[i].getParent(), members[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                PDPlugin.getAlerts().detailError("Error.ImgFileFilter.0", "Error.ImgFileFilter.2");
                this._mylog.error("Error.ProjectFileDialogContentProvider.0", (Throwable)e);
                return false;
            }
        }

        private boolean isWebAppProject(IProject project) {
            return WebrootUtil.isValidWebProject((IProject)project);
        }

        private boolean isSameProject(IProject orig, IProject dst) {
            String currentProjectName = orig.getFullPath().toString().trim();
            String projectName = dst.getFullPath().toString().trim();
            return projectName.equalsIgnoreCase(currentProjectName);
        }
    }

    class ProjectFileDialogContentProvider
    implements ITreeContentProvider {
        ProjectFileDialogContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            if (element instanceof IWorkspace) {
                IWorkspaceRoot root = ((IWorkspace)element).getRoot();
                Object[] projects = root.getProjects();
                return projects;
            }
            if (element instanceof IContainer) {
                IContainer container;
                if (element instanceof IProject) {
                    IContainer container2 = (IContainer)element;
                    if (container2.isAccessible()) {
                        try {
                            Object[] members = container2.members();
                            return members;
                        }
                        catch (CoreException e) {
                            PDPlugin.getAlerts().error("Error.CommonResourceDialog.0.1", "Error.CommonResourceDialog.0.2");
                            _log.error("Error.ProjectFileDialogContentProvider.0", (Throwable)e);
                        }
                    }
                } else if (element instanceof IFolder && (container = (IContainer)element).isAccessible()) {
                    try {
                        ArrayList<IResource> children = new ArrayList<IResource>();
                        IResource[] members = container.members();
                        int i = 0;
                        while (i < members.length) {
                            if (!members[i].getName().equals("WEB-INF") && !members[i].getName().equals("META-INF")) {
                                children.add(members[i]);
                            }
                            ++i;
                        }
                        return children.toArray();
                    }
                    catch (CoreException e) {
                        PDPlugin.getAlerts().error("Error.CommonResourceDialog.0.1", "Error.CommonResourceDialog.0.2");
                        _log.error("Error.ProjectFileDialogContentProvider.0", (Throwable)e);
                    }
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

