/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.CSSPropertyMeta;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;

public class TextDecorationMeta
extends CSSPropertyMeta {
    private static final int NONE = 0;
    public static final int UNDERLINE = 1;
    public static final int OVERLINE = 2;
    public static final int LINETHROUGH = 4;
    private static final int BLINK = 8;
    static final String[] KEYWORDS = new String[]{"none", "underline", "overline", "line-through", "blink"};

    public TextDecorationMeta() {
        super(true, new Integer(0));
    }

    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    public Object calculateCSSValueResult(CSSValue value, String propertyName, ICSSStyle style) {
        int i;
        String[] decorations = null;
        if (value.getCssValueType() == 2) {
            CSSValueList valueList = (CSSValueList)value;
            decorations = new String[valueList.getLength()];
            i = 0;
            while (i < decorations.length) {
                decorations[i] = valueList.item(i).getCssText();
                ++i;
            }
        } else {
            decorations = new String[]{value.getCssText()};
        }
        int intvalue = 0;
        i = 0;
        while (i < decorations.length) {
            String key = super.checkKeywordValues(decorations[i]);
            if (key == "none") {
                intvalue = 0;
            } else if (key == "underline") {
                intvalue |= 1;
            } else if (key == "overline") {
                intvalue |= 2;
            } else if (key == "line-through") {
                intvalue |= 4;
            } else if (key == "blink") {
                intvalue |= 8;
            }
            ++i;
        }
        return new Integer(intvalue);
    }
}

