/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal;

import java.io.PrintStream;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.comparator.ComparatorTools;

public final class SystemTools {
    public static boolean jvmIsApple() {
        return SystemTools.jvmIs("Apple");
    }

    public static boolean jvmIsIBM() {
        return SystemTools.jvmIs("IBM");
    }

    public static boolean jvmIsOracle() {
        return SystemTools.jvmIsSun();
    }

    public static boolean jvmIsSun() {
        return SystemTools.jvmIsStrictlySun() || SystemTools.jvmIsStrictlyOracle();
    }

    public static boolean jvmIsStrictlyOracle() {
        return SystemTools.jvmIs("Oracle");
    }

    public static boolean jvmIsStrictlySun() {
        return SystemTools.jvmIs("Sun");
    }

    private static boolean jvmIs(String jvmVendorName) {
        return System.getProperty("java.vendor").startsWith(jvmVendorName);
    }

    public static boolean javaSpecificationVersionIsGreaterThan(String version) {
        return ComparatorTools.integerVersionComparator().compare(SystemTools.javaSpecificationVersion(), version) > 0;
    }

    public static boolean javaSpecificationVersionIsLessThanOrEqualTo(String version) {
        return !SystemTools.javaSpecificationVersionIsGreaterThan(version);
    }

    public static boolean javaSpecificationVersionIsLessThan(String version) {
        return ComparatorTools.integerVersionComparator().compare(SystemTools.javaSpecificationVersion(), version) < 0;
    }

    public static boolean javaSpecificationVersionIsGreaterThanOrEqualTo(String version) {
        return !SystemTools.javaSpecificationVersionIsLessThan(version);
    }

    public static String javaSpecificationVersion() {
        return System.getProperty("java.specification.version");
    }

    public static boolean fileEncodingIsWindows() {
        return SystemTools.fileEncoding().equals("Cp1252");
    }

    public static boolean fileEncodingIsUTF8() {
        return SystemTools.fileEncoding().equals("UTF-8");
    }

    private static String fileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static boolean osIsWindows() {
        return SystemTools.osIs("Windows");
    }

    public static boolean osIsLinux() {
        return SystemTools.osIs("Linux");
    }

    public static boolean osIsMac() {
        return SystemTools.osIs("Mac");
    }

    private static boolean osIs(String osName) {
        return System.getProperty("os.name").indexOf(osName) != -1;
    }

    public static String allThreadsToString() {
        StringBuilder sb = new StringBuilder(5000);
        SystemTools.dumpAllThreadsOn(sb);
        return sb.toString();
    }

    public static void dumpAllThreadsOn(StringBuilder sb) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            sb.append(entry.getKey().getName());
            sb.append(StringTools.CR);
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                sb.append(element);
                sb.append(StringTools.CR);
                ++n2;
            }
            sb.append(StringTools.CR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpAllThreads() {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            SystemTools.dumpAllThreadsOn(System.out);
        }
    }

    public static void dumpAllThreadsOn(PrintStream stream) {
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : stackTraces.entrySet()) {
            stream.println(entry.getKey().getName());
            StackTraceElement[] stackTraceElementArray = entry.getValue();
            int n = stackTraceElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                stream.println(element);
                ++n2;
            }
            stream.println();
        }
    }

    private SystemTools() {
        throw new UnsupportedOperationException();
    }
}

