/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.List;

public class SourceWrapSupport {
    private final List<Wrapper> wrappers;

    public SourceWrapSupport(List<Wrapper> wrappers) {
        this.wrappers = wrappers;
    }

    public Wrapper.Match chooseWrapper(String remoteContent) {
        for (Wrapper nextWrapper : this.wrappers) {
            Wrapper.Match match = nextWrapper.match(remoteContent);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public static class StringBasedWrapper
    implements Wrapper {
        private final String name;
        private final String prefix;
        private final String suffix;
        private final Wrapper.Match singleMatch = new Wrapper.Match(){

            @Override
            public Wrapper getWrapper() {
                return StringBasedWrapper.this;
            }

            @Override
            public String wrap(String localContent) {
                return String.valueOf(StringBasedWrapper.this.prefix) + localContent + StringBasedWrapper.this.suffix;
            }

            @Override
            public int getPrefixLength() {
                return StringBasedWrapper.this.prefix.length();
            }

            @Override
            public int getSuffixLength() {
                return StringBasedWrapper.this.suffix.length();
            }
        };

        public StringBasedWrapper(String name, String prefix, String suffix) {
            this.name = name;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Wrapper.Match match(String remoteContent) {
            if (remoteContent.length() < this.prefix.length() + this.suffix.length()) {
                return null;
            }
            if (!remoteContent.startsWith(this.prefix) || !remoteContent.endsWith(this.suffix)) {
                return null;
            }
            return this.singleMatch;
        }
    }

    public static interface Wrapper {
        public String getName();

        public Match match(String var1);

        public static interface Match {
            public Wrapper getWrapper();

            public String wrap(String var1);

            public int getPrefixLength();

            public int getSuffixLength();
        }
    }
}

