/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dtresourceprovider;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.jsp.core.taglib.ITaglibDescriptor;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.TaglibIndex;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dtresourceprovider.IDTResourceProvider;
import org.eclipse.jst.pagedesigner.dtresourceprovider.ProviderClassMap;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DTResourceProviderFactory {
    private static DTResourceProviderFactory instance;
    private ProviderClassMap providerClassMap;
    private Map<IProject, List<IDTResourceProvider>> providerMap;
    private Logger log = PDPlugin.getLogger(DTResourceProviderFactory.class);

    private DTResourceProviderFactory() {
        this.providerClassMap = new ProviderClassMap();
        this.loadExtensions();
        this.providerMap = new HashMap<IProject, List<IDTResourceProvider>>();
    }

    public static synchronized DTResourceProviderFactory getInstance() {
        if (instance == null) {
            instance = new DTResourceProviderFactory();
        }
        return instance;
    }

    public List<IDTResourceProvider> getActiveDTResourceProviders(IProject project) {
        ITaglibRecord[] taglibRecords;
        ArrayList<IDTResourceProvider> activeProviders = new ArrayList<IDTResourceProvider>();
        if (project != null && (taglibRecords = TaglibIndex.getAvailableTaglibRecords((IPath)project.getFullPath())) != null && taglibRecords.length > 0) {
            ITaglibRecord[] iTaglibRecordArray = taglibRecords;
            int n = taglibRecords.length;
            int n2 = 0;
            while (n2 < n) {
                String taglibURI;
                ITaglibRecord taglibRecord = iTaglibRecordArray[n2];
                ITaglibDescriptor taglibDescriptor = taglibRecord.getDescriptor();
                if (taglibDescriptor != null && (taglibURI = taglibDescriptor.getURI()) != null) {
                    activeProviders.addAll(this.getDTResourceProviders(project, taglibURI));
                }
                ++n2;
            }
        }
        return Collections.unmodifiableList(activeProviders);
    }

    public List<IDTResourceProvider> getActiveDTResourceProviders(IDOMNode domNode) {
        IDOMModel domModel = domNode.getModel();
        IProject project = null;
        if (domModel != null) {
            project = StructuredModelUtil.getProjectFor((IStructuredModel)domModel);
        }
        return this.getActiveDTResourceProviders(project);
    }

    public synchronized List<IDTResourceProvider> getDTResourceProviders(IProject project, String id) {
        ArrayList<IDTResourceProvider> providers = new ArrayList<IDTResourceProvider>();
        List<IDTResourceProvider> projectProviders = this.providerMap.get(project);
        if (projectProviders == null) {
            projectProviders = this.providerClassMap.createInstances();
            this.providerMap.put(project, projectProviders);
        }
        for (IDTResourceProvider curProvider : projectProviders) {
            if (!curProvider.getId().equals(id)) continue;
            providers.add(curProvider);
        }
        return providers;
    }

    private void loadExtensions() {
        try {
            IExtensionPoint extPoint = Platform.getExtensionRegistry().getExtensionPoint(PDPlugin.getPluginId(), "pageDesignerExtension");
            IExtension[] extensions = extPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] confElements = extension.getConfigurationElements();
                int j = 0;
                while (j < confElements.length) {
                    IConfigurationElement confElement = confElements[j];
                    if (confElement.getName().equals("dtResourceProvider")) {
                        String id = confElement.getAttribute("id");
                        String providerClassName = confElement.getAttribute("class");
                        Bundle bundle = Platform.getBundle((String)confElement.getContributor().getName());
                        if (bundle != null) {
                            try {
                                this.providerClassMap.add(id, bundle.loadClass(providerClassName));
                            }
                            catch (ClassNotFoundException cnfe) {
                                this.log.error("Warning.DTResourceProviderFactory.ClassNotFound", providerClassName, id, (Throwable)cnfe);
                            }
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (InvalidRegistryObjectException iroe) {
            this.log.error("Warning.DTResourceProviderFactory.RegistryError", String.valueOf(PDPlugin.getPluginId()) + "pageDesignerExtension" + "." + "dtResourceProvider", (Throwable)iroe);
        }
    }
}

