/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class ResourceTypeReaderHelper {
    private static String extensionPoint;
    private static String typeAttributeName;
    private static final String USAGE_TYPE = "type";
    private static final String USAGE_ATTRIBUTE_NAME = "usage";
    private static final String USAGE_COMMON = "Common";
    private static final String USAGE_EJB = "EJB Jar";
    private static final String SERVER_TARGET_IDS_ATTRIBUTE_NAME = "target-server-ids";
    private static final String SERVER_TARGET_IDS_SEPARATOR = ",";
    private boolean isEJBJar;
    public static final int RESOURCE_REF = 0;
    public static final int RESOURCE_ENV_REF = 1;
    private static final String[] EXTENSION_POINTS;

    static {
        EXTENSION_POINTS = new String[]{"org.eclipse.jst.j2ee.resourceRefType", "org.eclipse.jst.j2ee.resourceEnvRefType"};
    }

    public static String[] getAllReferences(int refType, String serverTargetID, boolean isEJBJar, String[] baseItems) {
        String extensionPointLocal = EXTENSION_POINTS[refType];
        ResourceTypeReaderHelper reader = new ResourceTypeReaderHelper(extensionPointLocal, USAGE_TYPE, isEJBJar);
        String[] extendedItems = serverTargetID == null ? reader.getResTypes() : reader.getResTypes(serverTargetID);
        Object[] allItems = null;
        if (extendedItems == null || extendedItems.length == 0) {
            allItems = baseItems;
        } else {
            allItems = new String[baseItems.length + extendedItems.length];
            System.arraycopy(baseItems, 0, allItems, 0, baseItems.length);
            System.arraycopy(extendedItems, 0, allItems, baseItems.length, extendedItems.length);
        }
        Arrays.sort(allItems);
        return allItems;
    }

    private ResourceTypeReaderHelper(String extPoint, String typeAttName, boolean ejbJar) {
        extensionPoint = extPoint;
        typeAttributeName = typeAttName;
        this.isEJBJar = ejbJar;
    }

    private IExtensionPoint getExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint exPoint = registry.getExtensionPoint(extensionPoint);
        return exPoint;
    }

    private ArrayList processExtensions() {
        IExtension[] allExtensions = this.getExtensionPoint().getExtensions();
        ArrayList<Object> tempTypes = new ArrayList<Object>();
        int x = 0;
        while (x < allExtensions.length) {
            IExtension config = allExtensions[x];
            IConfigurationElement[] cElems = config.getConfigurationElements();
            int i = 0;
            while (i < cElems.length) {
                if (this.getValidTypes(cElems[i]) != null) {
                    tempTypes.add(this.getValidTypes(cElems[i]));
                }
                ++i;
            }
            ++x;
        }
        return tempTypes;
    }

    public String[] getResTypes() {
        ArrayList types = this.processExtensions();
        String[] allTypes = new String[types.size()];
        int z = 0;
        while (z < types.size()) {
            allTypes[z] = (String)types.get(z);
            ++z;
        }
        return allTypes;
    }

    private ArrayList processExtensions(String targetServer) {
        IExtension[] allExtensions = this.getExtensionPoint().getExtensions();
        ArrayList<Object> tempTypes = new ArrayList<Object>();
        int x = 0;
        while (x < allExtensions.length) {
            IExtension config = allExtensions[x];
            IConfigurationElement[] cElems = config.getConfigurationElements();
            int i = 0;
            while (i < cElems.length) {
                if (this.getValidTypes(cElems[i], targetServer) != null) {
                    tempTypes.add(this.getValidTypes(cElems[i], targetServer));
                }
                ++i;
            }
            ++x;
        }
        return tempTypes;
    }

    private Object getValidTypes(IConfigurationElement element, String targetServer) {
        String elementServerIDs = element.getAttribute(SERVER_TARGET_IDS_ATTRIBUTE_NAME);
        if (elementServerIDs == null || this.isValidTargeted(elementServerIDs, targetServer)) {
            String usage = element.getAttribute(USAGE_ATTRIBUTE_NAME);
            if (usage.equals(USAGE_COMMON)) {
                return element.getAttribute(typeAttributeName);
            }
            if (this.isEJBJar && usage.equals(USAGE_EJB)) {
                return element.getAttribute(typeAttributeName);
            }
        }
        return null;
    }

    private Object getValidTypes(IConfigurationElement element) {
        return this.getValidTypes(element, null);
    }

    public String[] getResTypes(String targetServer) {
        ArrayList types = this.processExtensions(targetServer);
        String[] allTypes = new String[types.size()];
        int z = 0;
        while (z < types.size()) {
            allTypes[z] = (String)types.get(z);
            ++z;
        }
        return allTypes;
    }

    private boolean isValidTargeted(String attribute, String targetServerId) {
        if (attribute == null || targetServerId == null) {
            return false;
        }
        if (attribute.trim().equalsIgnoreCase(targetServerId.trim())) {
            return true;
        }
        if (attribute.indexOf(String.valueOf(targetServerId.trim()) + SERVER_TARGET_IDS_SEPARATOR) >= 0) {
            return true;
        }
        return attribute.trim().length() > targetServerId.trim().length() + 1 && attribute.substring(attribute.trim().length() - targetServerId.length()).equalsIgnoreCase(targetServerId.trim());
    }
}

