/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.jst.server.generic.internal.core.util.ExtensionPointUtil;
import org.eclipse.jst.server.generic.internal.core.util.ServerRuntimeMergeUtil;
import org.eclipse.jst.server.generic.internal.xml.XMLUtils;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;

public class ServerTypeDefinitionManager {
    private XMLUtils fXmlUtils = new XMLUtils();

    protected ServerTypeDefinitionManager(URL serverDefinitionURL) {
        ExtensionPointUtil.addRegistryListener(new RegistryChangeListener());
    }

    public ServerRuntime getServerRuntimeDefinition(String serverTypeId, String runtimeTypeId, Map properties) {
        ServerRuntime runtimedef;
        ServerRuntime serverdef = this.fXmlUtils.getServerTypeDefinition(serverTypeId);
        serverdef = serverdef != null ? ((runtimedef = this.fXmlUtils.getRuntimeTypeDefinition(runtimeTypeId)) == null ? this.fXmlUtils.getServerTypeDefinition(runtimeTypeId) : ServerRuntimeMergeUtil.combine(serverdef, runtimedef)) : this.fXmlUtils.getServerTypeDefinition(runtimeTypeId);
        if (serverdef != null) {
            serverdef.setPropertyValues(properties);
        }
        return serverdef;
    }

    public ServerRuntime getServerRuntimeDefinition(String runtimeTypeId, Map properties) {
        ServerRuntime definition = this.fXmlUtils.getRuntimeTypeDefinition(runtimeTypeId);
        if (definition == null) {
            definition = this.fXmlUtils.getServerTypeDefinition(runtimeTypeId);
        }
        if (definition != null) {
            definition.setPropertyValues(properties);
        }
        return definition;
    }

    public ServerRuntime[] getServerTypeDefinitions() {
        List definitionList = this.fXmlUtils.getServerTypeDefinitions();
        return definitionList.toArray(new ServerRuntime[definitionList.size()]);
    }

    private void handleDefinitionsChanged() {
        XMLUtils utils;
        this.fXmlUtils = utils = new XMLUtils();
    }

    private class RegistryChangeListener
    implements IRegistryChangeListener {
        private RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.jst.server.generic.core", "serverdefinition");
            if (deltas != null && deltas.length > 0) {
                ServerTypeDefinitionManager.this.handleDefinitionsChanged();
            } else {
                deltas = event.getExtensionDeltas("org.eclipse.jst.server.generic.core", "runtimedefinition");
                if (deltas != null && deltas.length > 0) {
                    ServerTypeDefinitionManager.this.handleDefinitionsChanged();
                }
            }
        }
    }
}

