/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.newtypes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.newtypes.DeclaredFunctionType;
import com.google.javascript.jscomp.newtypes.FunctionTypeBuilder;
import com.google.javascript.jscomp.newtypes.JSType;
import com.google.javascript.jscomp.newtypes.JSTypes;
import com.google.javascript.jscomp.newtypes.NominalType;
import com.google.javascript.jscomp.newtypes.ObjectType;
import com.google.javascript.jscomp.newtypes.SubtypeCache;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class FunctionType {
    private final ImmutableList<JSType> requiredFormals;
    private final ImmutableList<JSType> optionalFormals;
    private final JSType restFormals;
    private final JSType returnType;
    private final boolean isLoose;
    private final ImmutableMap<String, JSType> outerVarPreconditions;
    private final JSType nominalType;
    private final JSType receiverType;
    private final ImmutableList<String> typeParameters;
    private static final boolean DEBUGGING = false;
    static final FunctionType TOP_FUNCTION = new FunctionType(false);
    private static final FunctionType LOOSE_TOP_FUNCTION = new FunctionType(true);
    static final FunctionType QMARK_FUNCTION = FunctionType.normalized(null, null, JSType.UNKNOWN, JSType.UNKNOWN, null, null, null, null, true);
    private static final FunctionType BOTTOM_FUNCTION = FunctionType.normalized(null, null, null, JSType.BOTTOM, null, null, null, null, false);

    private FunctionType(ImmutableList<JSType> requiredFormals, ImmutableList<JSType> optionalFormals, JSType restFormals, JSType retType, JSType nominalType, JSType receiverType, ImmutableMap<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        this.requiredFormals = requiredFormals;
        this.optionalFormals = optionalFormals;
        this.restFormals = restFormals;
        this.returnType = retType;
        this.nominalType = nominalType;
        this.receiverType = receiverType;
        this.outerVarPreconditions = outerVars;
        this.typeParameters = typeParameters;
        this.isLoose = isLoose;
        this.checkValid();
    }

    private FunctionType(boolean isLoose) {
        this.requiredFormals = null;
        this.optionalFormals = null;
        this.restFormals = null;
        this.returnType = null;
        this.nominalType = null;
        this.receiverType = null;
        this.outerVarPreconditions = null;
        this.typeParameters = ImmutableList.of();
        this.isLoose = isLoose;
    }

    void checkValid() {
        if (this.isTopFunction() || this.isQmarkFunction()) {
            return;
        }
        Preconditions.checkNotNull(this.requiredFormals, (String)"null required formals for function: %s", (Object[])new Object[]{this});
        for (JSType formal : this.requiredFormals) {
            Preconditions.checkNotNull((Object)formal);
            Preconditions.checkState((this.isLoose || !formal.isBottom() ? 1 : 0) != 0);
        }
        Preconditions.checkNotNull(this.optionalFormals, (String)"null optional formals for function: %s", (Object[])new Object[]{this});
        for (JSType formal : this.optionalFormals) {
            Preconditions.checkNotNull((Object)formal);
            Preconditions.checkState((!formal.isBottom() ? 1 : 0) != 0);
        }
        Preconditions.checkState((this.restFormals == null || !this.restFormals.isBottom() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)this.returnType);
    }

    public boolean isLoose() {
        return this.isLoose;
    }

    FunctionType withLoose() {
        if (this.isLoose()) {
            return this;
        }
        if (this.isTopFunction()) {
            return LOOSE_TOP_FUNCTION;
        }
        return new FunctionType(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType, this.outerVarPreconditions, this.typeParameters, true);
    }

    static FunctionType normalized(List<JSType> requiredFormals, List<JSType> optionalFormals, JSType restFormals, JSType retType, JSType nominalType, JSType receiverType, Map<String, JSType> outerVars, ImmutableList<String> typeParameters, boolean isLoose) {
        if (requiredFormals == null) {
            requiredFormals = ImmutableList.of();
        }
        if (optionalFormals == null) {
            optionalFormals = ImmutableList.of();
        }
        if (outerVars == null) {
            outerVars = ImmutableMap.of();
        }
        if (typeParameters == null) {
            typeParameters = ImmutableList.of();
        }
        if (restFormals != null) {
            for (int i = optionalFormals.size() - 1; i >= 0 && restFormals.equals(optionalFormals.get(i)); --i) {
                optionalFormals.remove(i);
            }
        }
        return new FunctionType((ImmutableList<JSType>)ImmutableList.copyOf((Collection)requiredFormals), (ImmutableList<JSType>)ImmutableList.copyOf((Collection)optionalFormals), restFormals, retType, nominalType, receiverType, (ImmutableMap<String, JSType>)ImmutableMap.copyOf((Map)outerVars), (ImmutableList<String>)typeParameters, isLoose);
    }

    public boolean isTopFunction() {
        return this == TOP_FUNCTION || this == LOOSE_TOP_FUNCTION;
    }

    private static NominalType getNominalTypeIfSingletonObj(JSType t) {
        return t == null ? null : t.getNominalTypeIfSingletonObj();
    }

    public boolean isSomeConstructorOrInterface() {
        return this.nominalType != null;
    }

    public boolean isUniqueConstructor() {
        NominalType nt = FunctionType.getNominalTypeIfSingletonObj(this.nominalType);
        return nt != null && nt.isClass();
    }

    public boolean isInterfaceDefinition() {
        NominalType nt = FunctionType.getNominalTypeIfSingletonObj(this.nominalType);
        return nt != null && nt.isInterface();
    }

    public JSType getSuperPrototype() {
        Preconditions.checkState((boolean)this.isUniqueConstructor());
        NominalType nt = FunctionType.getNominalTypeIfSingletonObj(this.nominalType);
        NominalType superClass = nt.getInstantiatedSuperclass();
        return superClass == null ? null : superClass.getPrototype();
    }

    public boolean isQmarkFunction() {
        return this == QMARK_FUNCTION;
    }

    static boolean isInhabitable(FunctionType f) {
        return f != BOTTOM_FUNCTION;
    }

    public boolean hasRestFormals() {
        return this.restFormals != null;
    }

    public JSType getRestFormalsType() {
        Preconditions.checkNotNull((Object)this.restFormals);
        return this.restFormals;
    }

    public JSType getFormalType(int argpos) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        int numReqFormals = this.requiredFormals.size();
        if (argpos < numReqFormals) {
            Preconditions.checkState((null != this.requiredFormals.get(argpos) ? 1 : 0) != 0);
            return (JSType)this.requiredFormals.get(argpos);
        }
        if (argpos < numReqFormals + this.optionalFormals.size()) {
            Preconditions.checkState((null != this.optionalFormals.get(argpos - numReqFormals) ? 1 : 0) != 0);
            return (JSType)this.optionalFormals.get(argpos - numReqFormals);
        }
        return this.restFormals;
    }

    public JSType getReturnType() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return this.returnType;
    }

    public JSType getOuterVarPrecondition(String name) {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return (JSType)this.outerVarPreconditions.get((Object)name);
    }

    public int getMinArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        return this.requiredFormals.size();
    }

    public int getMaxArity() {
        Preconditions.checkArgument((!this.isTopFunction() ? 1 : 0) != 0);
        if (this.restFormals != null) {
            return Integer.MAX_VALUE;
        }
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public int getMaxArityWithoutRestFormals() {
        return this.requiredFormals.size() + this.optionalFormals.size();
    }

    public boolean isRequiredArg(int i) {
        return i < this.requiredFormals.size();
    }

    public boolean isOptionalArg(int i) {
        return i >= this.requiredFormals.size() && i < this.requiredFormals.size() + this.optionalFormals.size();
    }

    public JSType getInstanceTypeOfCtor() {
        if (!this.isGeneric()) {
            return this.nominalType;
        }
        return FunctionType.getNominalTypeIfSingletonObj(this.nominalType).instantiateGenerics(JSType.MAP_TO_UNKNOWN).getInstanceAsJSType();
    }

    public JSType getThisType() {
        return this.receiverType != null ? this.receiverType : this.nominalType;
    }

    public FunctionType transformByCallProperty() {
        if (this.isTopFunction() || this.isQmarkFunction() || this.isLoose) {
            return QMARK_FUNCTION;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        builder.addReqFormal(this.fromReceiverToFirstFormal());
        for (JSType type : this.requiredFormals) {
            builder.addReqFormal(type);
        }
        for (JSType type : this.optionalFormals) {
            builder.addOptFormal(type);
        }
        builder.addRestFormals(this.restFormals);
        builder.addRetType(this.returnType);
        builder.addTypeParameters(this.typeParameters);
        return builder.buildFunction();
    }

    public FunctionType transformByApplyProperty(JSTypes commonTypes) {
        if (this.isTopFunction() || this.isQmarkFunction() || this.isLoose) {
            return QMARK_FUNCTION;
        }
        if (this.isGeneric()) {
            return FunctionType.instantiateGenericsWithUnknown(this).transformByApplyProperty(commonTypes);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        builder.addReqFormal(this.fromReceiverToFirstFormal());
        builder.addOptFormal(JSType.join(commonTypes.getArrayInstance(), commonTypes.getArgumentsArrayType()));
        builder.addRetType(this.returnType);
        return builder.buildFunction();
    }

    private JSType fromReceiverToFirstFormal() {
        if (this.receiverType == null) {
            return JSType.UNKNOWN;
        }
        NominalType nt = this.receiverType.getNominalTypeIfSingletonObj();
        if (nt == null || nt.isBuiltinObject()) {
            return this.receiverType;
        }
        if (nt.isGeneric()) {
            return nt.instantiateGenerics(JSType.MAP_TO_UNKNOWN).getInstanceAsJSType();
        }
        return nt.getInstanceAsJSType();
    }

    public DeclaredFunctionType toDeclaredFunctionType() {
        if (this.isQmarkFunction()) {
            return FunctionTypeBuilder.qmarkFunctionBuilder().buildDeclaration();
        }
        Preconditions.checkState((!this.isLoose() ? 1 : 0) != 0, (String)"Loose function: %s", (Object[])new Object[]{this});
        Preconditions.checkState((!this.isGeneric() ? 1 : 0) != 0, (String)"Generic function: %s", (Object[])new Object[]{this});
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType type : this.requiredFormals) {
            builder.addReqFormal(type);
        }
        for (JSType type : this.optionalFormals) {
            builder.addOptFormal(type);
        }
        builder.addRestFormals(this.restFormals);
        builder.addRetType(this.returnType);
        builder.addNominalType(this.nominalType);
        builder.addReceiverType(this.receiverType);
        return builder.buildDeclaration();
    }

    private static JSType nullAcceptingMeet(JSType t1, JSType t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        JSType tmp = JSType.meet(t1, t2);
        return tmp.isBottom() ? null : tmp;
    }

    private static FunctionType looseJoin(FunctionType f1, FunctionType f2) {
        JSType t;
        Preconditions.checkArgument((f1.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.getMinArity(), f2.getMinArity());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; !(i >= maxTotalArity || (t = JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i))) != null && t.isBottom()); ++i) {
            builder.addOptFormal(t);
        }
        return builder.addRetType(JSType.nullAcceptingJoin(f1.returnType, f2.returnType)).addLoose().buildFunction();
    }

    public boolean isValidOverride(FunctionType other) {
        return this.isSubtypeOfHelper(other, false, SubtypeCache.create());
    }

    boolean isSubtypeOf(FunctionType other, SubtypeCache subSuperMap) {
        return this.isSubtypeOfHelper(other, true, subSuperMap);
    }

    private boolean acceptsAnyArguments() {
        return this.requiredFormals.isEmpty() && this.optionalFormals.isEmpty() && this.restFormals != null && this.restFormals.isUnknown();
    }

    private boolean isSubtypeOfHelper(FunctionType other, boolean checkThisType, SubtypeCache subSuperMap) {
        if (other.isTopFunction() || other.isQmarkFunction() || this.isQmarkFunction()) {
            return true;
        }
        if (this.isTopFunction()) {
            return false;
        }
        Preconditions.checkState((!this.isLoose() && !other.isLoose() ? 1 : 0) != 0);
        if (this.isGeneric()) {
            if (this.equals(other)) {
                return true;
            }
            return FunctionType.instantiateGenericsWithUnknown(this).isSubtypeOfHelper(other, checkThisType, subSuperMap);
        }
        if (!other.acceptsAnyArguments()) {
            if (this.requiredFormals.size() > other.requiredFormals.size()) {
                return false;
            }
            int otherMaxTotalArity = other.requiredFormals.size() + other.optionalFormals.size();
            for (int i = 0; i < otherMaxTotalArity; ++i) {
                JSType thisFormal = this.getFormalType(i);
                JSType otherFormal = other.getFormalType(i);
                if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal, subSuperMap)) continue;
                return false;
            }
            if (other.restFormals != null) {
                int thisMaxTotalArity = this.requiredFormals.size() + this.optionalFormals.size();
                if (this.restFormals != null) {
                    ++thisMaxTotalArity;
                }
                for (int i = otherMaxTotalArity; i < thisMaxTotalArity; ++i) {
                    JSType thisFormal = this.getFormalType(i);
                    JSType otherFormal = other.getFormalType(i);
                    if (thisFormal == null || thisFormal.isUnknown() || otherFormal.isUnknown() || otherFormal.isSubtypeOf(thisFormal, subSuperMap)) continue;
                    return false;
                }
            }
        }
        if (this.nominalType == null && other.nominalType != null || this.nominalType != null && other.nominalType == null || this.nominalType != null && other.nominalType != null && !this.nominalType.isSubtypeOf(other.nominalType)) {
            return false;
        }
        if (checkThisType && (this.receiverType != null && other.receiverType == null || this.receiverType != null && other.receiverType != null && !other.receiverType.isSubtypeOf(this.receiverType, subSuperMap) && !this.receiverType.isSubtypeOf(other.receiverType, subSuperMap))) {
            return false;
        }
        return this.returnType.isUnknown() || other.returnType.isUnknown() || this.returnType.isSubtypeOf(other.returnType, subSuperMap);
    }

    private static JSType joinNominalTypes(JSType nt1, JSType nt2) {
        if (nt1 == null || nt2 == null) {
            return null;
        }
        NominalType n1 = FunctionType.getNominalTypeIfSingletonObj(nt1);
        NominalType n2 = FunctionType.getNominalTypeIfSingletonObj(nt2);
        if (n1 != null && n2 != null) {
            NominalType tmp = NominalType.pickSuperclass(n1, n2);
            return tmp == null ? null : tmp.getInstanceAsJSType();
        }
        return JSType.join(nt1, nt2);
    }

    private static JSType meetNominalTypes(JSType nt1, JSType nt2) {
        if (nt1 == null) {
            return nt2;
        }
        if (nt2 == null) {
            return nt1;
        }
        NominalType n1 = FunctionType.getNominalTypeIfSingletonObj(nt1);
        NominalType n2 = FunctionType.getNominalTypeIfSingletonObj(nt2);
        if (n1 != null && n2 != null) {
            NominalType tmp = NominalType.pickSubclass(n1, n2);
            return tmp == null ? null : tmp.getInstanceAsJSType();
        }
        return JSType.meet(nt1, nt2);
    }

    static FunctionType join(FunctionType f1, FunctionType f2) {
        if (f1 == null) {
            return f2;
        }
        if (f2 == null || f1.equals(f2)) {
            return f1;
        }
        if (f1.isQmarkFunction()) {
            return f2 == QMARK_FUNCTION ? QMARK_FUNCTION : f1;
        }
        if (f2.isQmarkFunction()) {
            return f2;
        }
        if (f1.isTopFunction() || f2.isTopFunction()) {
            return TOP_FUNCTION;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        if (f1.isGeneric() && f2.isSubtypeOf(f1, SubtypeCache.create())) {
            return f1;
        }
        if (f2.isGeneric() && f1.isSubtypeOf(f2, SubtypeCache.create())) {
            return f2;
        }
        if (f1.isGeneric()) {
            f1 = FunctionType.instantiateGenericsWithUnknown(f1);
        }
        if (f2.isGeneric()) {
            f2 = FunctionType.instantiateGenericsWithUnknown(f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int maxRequiredArity = Math.max(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < maxRequiredArity; ++i) {
            JSType reqFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            if (reqFormal == null) {
                return BOTTOM_FUNCTION;
            }
            builder.addReqFormal(reqFormal);
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = maxRequiredArity; i < maxTotalArity; ++i) {
            JSType optFormal = FunctionType.nullAcceptingMeet(f1.getFormalType(i), f2.getFormalType(i));
            if (optFormal == null) {
                return BOTTOM_FUNCTION;
            }
            builder.addOptFormal(optFormal);
        }
        if (f1.restFormals != null && f2.restFormals != null) {
            JSType newRestFormals = FunctionType.nullAcceptingMeet(f1.restFormals, f2.restFormals);
            if (newRestFormals == null) {
                return BOTTOM_FUNCTION;
            }
            builder.addRestFormals(newRestFormals);
        }
        builder.addRetType(JSType.join(f1.returnType, f2.returnType));
        builder.addNominalType(FunctionType.joinNominalTypes(f1.nominalType, f2.nominalType));
        builder.addReceiverType(FunctionType.meetNominalTypes(f1.receiverType, f2.receiverType));
        return builder.buildFunction();
    }

    FunctionType specialize(FunctionType other) {
        JSType retType;
        if (other == null || other.isQmarkFunction() || other.isTopFunction() || this.equals(other) || !this.isLoose() && other.isLoose() || this.isGeneric() || other.isGeneric()) {
            return this;
        }
        if (this.isTopFunction() || this.isQmarkFunction()) {
            return this.isLoose() ? other.withLoose() : other;
        }
        if (this.isLoose()) {
            return FunctionType.looseJoin(this, other);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int i = 0;
        for (JSType formal : this.requiredFormals) {
            builder.addReqFormal(JSType.nullAcceptingJoin(formal, other.getFormalType(i)));
            ++i;
        }
        for (JSType formal : this.optionalFormals) {
            builder.addOptFormal(JSType.nullAcceptingJoin(formal, other.getFormalType(i)));
            ++i;
        }
        if (this.restFormals != null) {
            builder.addRestFormals(JSType.nullAcceptingJoin(this.restFormals, other.getFormalType(i)));
        }
        if ((retType = this.returnType.specialize(other.returnType)).isBottom()) {
            return BOTTOM_FUNCTION;
        }
        builder.addRetType(retType);
        builder.addNominalType(FunctionType.meetNominalTypes(this.nominalType, other.nominalType));
        builder.addReceiverType(FunctionType.meetNominalTypes(this.receiverType, other.receiverType));
        return builder.buildFunction();
    }

    static FunctionType meet(FunctionType f1, FunctionType f2) {
        JSType retType;
        if (f1 == null || f2 == null) {
            return null;
        }
        if (f2.isTopFunction() || f1.equals(f2)) {
            return f1;
        }
        if (f1.isTopFunction()) {
            return f2;
        }
        if (f1.isLoose() || f2.isLoose()) {
            return FunctionType.looseJoin(f1, f2);
        }
        if (f1.isGeneric() && f1.isSubtypeOf(f2, SubtypeCache.create())) {
            return f1;
        }
        if (f2.isGeneric() && f2.isSubtypeOf(f1, SubtypeCache.create())) {
            return f2;
        }
        if (f1.isGeneric()) {
            f1 = FunctionType.instantiateGenericsWithUnknown(f1);
        }
        if (f2.isGeneric()) {
            f2 = FunctionType.instantiateGenericsWithUnknown(f2);
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int minRequiredArity = Math.min(f1.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            builder.addReqFormal(JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i)));
        }
        int maxTotalArity = Math.max(f1.requiredFormals.size() + f1.optionalFormals.size(), f2.requiredFormals.size() + f2.optionalFormals.size());
        for (int i = minRequiredArity; i < maxTotalArity; ++i) {
            JSType optFormalType = JSType.nullAcceptingJoin(f1.getFormalType(i), f2.getFormalType(i));
            if (optFormalType.isBottom()) {
                return BOTTOM_FUNCTION;
            }
            builder.addOptFormal(optFormalType);
        }
        if (f1.restFormals != null || f2.restFormals != null) {
            JSType restFormalsType = JSType.nullAcceptingJoin(f1.restFormals, f2.restFormals);
            if (restFormalsType.isBottom()) {
                return BOTTOM_FUNCTION;
            }
            builder.addRestFormals(restFormalsType);
        }
        if ((retType = JSType.meet(f1.returnType, f2.returnType)).isBottom()) {
            return BOTTOM_FUNCTION;
        }
        builder.addRetType(retType);
        builder.addNominalType(FunctionType.meetNominalTypes(f1.nominalType, f2.nominalType));
        builder.addReceiverType(FunctionType.joinNominalTypes(f1.receiverType, f2.receiverType));
        return builder.buildFunction();
    }

    boolean isLooseSubtypeOf(FunctionType f2, SubtypeCache subSuperMap) {
        Preconditions.checkState((this.isLoose() || f2.isLoose() ? 1 : 0) != 0);
        if (this.isTopFunction() || f2.isTopFunction()) {
            return true;
        }
        int minRequiredArity = Math.min(this.requiredFormals.size(), f2.requiredFormals.size());
        for (int i = 0; i < minRequiredArity; ++i) {
            if (JSType.haveCommonSubtype(this.getFormalType(i), f2.getFormalType(i))) continue;
            return false;
        }
        return JSType.haveCommonSubtype(this.getReturnType(), f2.getReturnType());
    }

    public boolean isGeneric() {
        return !this.typeParameters.isEmpty();
    }

    public List<String> getTypeParameters() {
        return this.typeParameters;
    }

    boolean unifyWithSubtype(FunctionType other, List<String> typeParameters, Multimap<String, JSType> typeMultimap, SubtypeCache subSuperMap) {
        Preconditions.checkState((boolean)this.typeParameters.isEmpty());
        Preconditions.checkState((boolean)this.outerVarPreconditions.isEmpty());
        Preconditions.checkState((this != TOP_FUNCTION ? 1 : 0) != 0);
        if (this == LOOSE_TOP_FUNCTION || other.isTopFunction() || other.isLoose()) {
            return true;
        }
        if (!this.acceptsAnyArguments()) {
            JSType otherRestFormals;
            if (other.requiredFormals.size() > this.requiredFormals.size()) {
                return false;
            }
            int maxNonInfiniteArity = this.getMaxArityWithoutRestFormals();
            for (int i = 0; i < maxNonInfiniteArity; ++i) {
                JSType thisFormal = this.getFormalType(i);
                JSType otherFormal = other.getFormalType(i);
                if (otherFormal == null || thisFormal.unifyWithSubtype(otherFormal, typeParameters, typeMultimap, subSuperMap) || thisFormal.isSubtypeOf(otherFormal, SubtypeCache.create())) continue;
                return false;
            }
            if (this.restFormals != null && (otherRestFormals = other.getFormalType(maxNonInfiniteArity)) != null && !this.restFormals.unifyWithSubtype(otherRestFormals, typeParameters, typeMultimap, subSuperMap) && !this.restFormals.isSubtypeOf(otherRestFormals, SubtypeCache.create())) {
                return false;
            }
        }
        if (this.nominalType == null && other.nominalType != null || this.nominalType != null && other.nominalType == null) {
            return false;
        }
        if (this.nominalType != null && !this.nominalType.unifyWithSubtype(other.nominalType, typeParameters, typeMultimap, subSuperMap)) {
            return false;
        }
        if (this.receiverType != null && other.receiverType != null && !this.receiverType.unifyWithSubtype(other.receiverType, typeParameters, typeMultimap, subSuperMap) && !this.receiverType.isSubtypeOf(other.receiverType, SubtypeCache.create())) {
            return false;
        }
        return this.returnType.unifyWithSubtype(other.returnType, typeParameters, typeMultimap, subSuperMap);
    }

    private static FunctionType instantiateGenericsWithUnknown(FunctionType f) {
        if (!f.isGeneric()) {
            return f;
        }
        return f.instantiateGenerics(JSType.MAP_TO_UNKNOWN);
    }

    static FunctionType unifyUnknowns(FunctionType f1, FunctionType f2) {
        JSType t;
        Preconditions.checkState((f1 != null || f2 != null ? 1 : 0) != 0);
        if (f1 == null || f2 == null) {
            return null;
        }
        if (!f1.typeParameters.isEmpty()) {
            f1 = FunctionType.instantiateGenericsWithUnknown(f1);
        }
        if (!f2.typeParameters.isEmpty()) {
            f2 = FunctionType.instantiateGenericsWithUnknown(f2);
        }
        Preconditions.checkState((!f1.isLoose() && !f2.isLoose() ? 1 : 0) != 0);
        if (f1.equals(f2)) {
            return f1;
        }
        ImmutableList<JSType> formals1 = f1.requiredFormals;
        ImmutableList<JSType> formals2 = f2.requiredFormals;
        if (formals1.size() != formals2.size()) {
            return null;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        int numReqFormals = formals1.size();
        for (int i = 0; i < numReqFormals; ++i) {
            JSType t2 = JSType.unifyUnknowns((JSType)formals1.get(i), (JSType)formals2.get(i));
            if (t2 == null) {
                return null;
            }
            builder.addReqFormal(t2);
        }
        formals1 = f1.optionalFormals;
        formals2 = f2.optionalFormals;
        if (formals1.size() != formals2.size()) {
            return null;
        }
        int numOptFormals = formals1.size();
        for (int i = 0; i < numOptFormals; ++i) {
            JSType t3 = JSType.unifyUnknowns((JSType)formals1.get(i), (JSType)formals2.get(i));
            if (t3 == null) {
                return null;
            }
            builder.addOptFormal(t3);
        }
        if (f1.restFormals == null && f2.restFormals != null || f1.restFormals != null && f2.restFormals == null) {
            return null;
        }
        if (f1.restFormals != null) {
            JSType t4 = JSType.unifyUnknowns(f1.restFormals, f2.restFormals);
            if (t4 == null) {
                return null;
            }
            builder.addRestFormals(t4);
        }
        if ((t = JSType.unifyUnknowns(f1.returnType, f2.returnType)) == null) {
            return null;
        }
        builder.addRetType(t);
        if (!Objects.equals(f1.nominalType, f2.nominalType)) {
            return null;
        }
        builder.addNominalType(f1.nominalType);
        if (!Objects.equals(f1.receiverType, f2.receiverType)) {
            return null;
        }
        builder.addReceiverType(f1.receiverType);
        return builder.buildFunction();
    }

    private static JSType substGenericsInNomType(JSType nt, Map<String, JSType> typeMap) {
        if (nt == null) {
            return null;
        }
        NominalType tmp = nt.getNominalTypeIfSingletonObj();
        if (tmp == null) {
            return nt.substituteGenerics(typeMap);
        }
        if (!tmp.isGeneric()) {
            return tmp.getInstanceAsJSType();
        }
        if (typeMap.isEmpty()) {
            return nt;
        }
        return JSType.fromObjectType(ObjectType.fromNominalType(tmp.instantiateGenerics(typeMap)));
    }

    private FunctionType substituteNominalGenerics(Map<String, JSType> typeMap) {
        if (typeMap.isEmpty()) {
            return this;
        }
        ImmutableMap reducedMap = typeMap;
        if (!JSType.MAP_TO_UNKNOWN.equals(typeMap)) {
            boolean foundShadowedTypeParam = false;
            for (Object typeParam : this.typeParameters) {
                if (!typeMap.containsKey(typeParam)) continue;
                foundShadowedTypeParam = true;
                break;
            }
            if (foundShadowedTypeParam) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry entry : typeMap.entrySet()) {
                    if (this.typeParameters.contains(entry.getKey())) continue;
                    builder.put(entry);
                }
                reducedMap = builder.build();
            }
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal.substituteGenerics((Map<String, JSType>)reducedMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal.substituteGenerics((Map<String, JSType>)reducedMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics((Map<String, JSType>)reducedMap));
        }
        builder.addRetType(this.returnType.substituteGenerics((Map<String, JSType>)reducedMap));
        if (this.isLoose()) {
            builder.addLoose();
        }
        builder.addNominalType(FunctionType.substGenericsInNomType(this.nominalType, (Map<String, JSType>)typeMap));
        builder.addReceiverType(FunctionType.substGenericsInNomType(this.receiverType, (Map<String, JSType>)typeMap));
        for (String var : this.outerVarPreconditions.keySet()) {
            builder.addOuterVarPrecondition(var, (JSType)this.outerVarPreconditions.get((Object)var));
        }
        builder.addTypeParameters(this.typeParameters);
        return builder.buildFunction();
    }

    private FunctionType substituteParametricGenerics(Map<String, JSType> typeMap) {
        if (typeMap.isEmpty()) {
            return this;
        }
        FunctionTypeBuilder builder = new FunctionTypeBuilder();
        for (JSType reqFormal : this.requiredFormals) {
            builder.addReqFormal(reqFormal.substituteGenerics(typeMap));
        }
        for (JSType optFormal : this.optionalFormals) {
            builder.addOptFormal(optFormal.substituteGenerics(typeMap));
        }
        if (this.restFormals != null) {
            builder.addRestFormals(this.restFormals.substituteGenerics(typeMap));
        }
        builder.addRetType(this.returnType.substituteGenerics(typeMap));
        if (this.isLoose()) {
            builder.addLoose();
        }
        builder.addNominalType(FunctionType.substGenericsInNomType(this.nominalType, typeMap));
        if (this.receiverType != null) {
            NominalType recvType = FunctionType.getNominalTypeIfSingletonObj(this.receiverType);
            if (recvType != null && recvType.isUninstantiatedGenericType()) {
                builder.addReceiverType(this.receiverType);
            } else {
                builder.addReceiverType(FunctionType.substGenericsInNomType(this.receiverType, typeMap));
            }
        }
        for (String var : this.outerVarPreconditions.keySet()) {
            builder.addOuterVarPrecondition(var, (JSType)this.outerVarPreconditions.get((Object)var));
        }
        return builder.buildFunction();
    }

    FunctionType substituteGenerics(Map<String, JSType> concreteTypes) {
        if (!this.isGeneric() || JSType.MAP_TO_UNKNOWN.equals(concreteTypes)) {
            return this.substituteNominalGenerics(concreteTypes);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, JSType> concreteTypeEntry : concreteTypes.entrySet()) {
            if (this.typeParameters.contains((Object)concreteTypeEntry.getKey())) continue;
            builder.put(concreteTypeEntry);
        }
        return this.substituteNominalGenerics((Map<String, JSType>)builder.build());
    }

    public FunctionType instantiateGenerics(Map<String, JSType> typeMap) {
        Preconditions.checkState((boolean)this.isGeneric());
        return this.substituteParametricGenerics(typeMap);
    }

    public FunctionType instantiateGenericsFromArgumentTypes(List<JSType> argTypes) {
        Preconditions.checkState((boolean)this.isGeneric());
        if (argTypes.size() < this.getMinArity() || argTypes.size() > this.getMaxArity()) {
            return null;
        }
        LinkedHashMultimap typeMultimap = LinkedHashMultimap.create();
        int size = argTypes.size();
        for (int i = 0; i < size; ++i) {
            if (this.getFormalType(i).unifyWithSubtype(argTypes.get(i), (List<String>)this.typeParameters, (Multimap<String, JSType>)typeMultimap, SubtypeCache.create())) continue;
            return null;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String typeParam : this.typeParameters) {
            Collection types = typeMultimap.get((Object)typeParam);
            if (types.size() != 1) {
                return null;
            }
            builder.put((Object)typeParam, Iterables.getOnlyElement((Iterable)types));
        }
        return this.substituteParametricGenerics((Map<String, JSType>)builder.build());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        Preconditions.checkArgument((boolean)(obj instanceof FunctionType), (String)"obj is: %s", (Object[])new Object[]{obj});
        FunctionType f2 = (FunctionType)obj;
        return Objects.equals(this.requiredFormals, f2.requiredFormals) && Objects.equals(this.optionalFormals, f2.optionalFormals) && Objects.equals(this.restFormals, f2.restFormals) && Objects.equals(this.returnType, f2.returnType) && Objects.equals(this.nominalType, f2.nominalType) && Objects.equals(this.receiverType, f2.receiverType);
    }

    public int hashCode() {
        return Objects.hash(this.requiredFormals, this.optionalFormals, this.restFormals, this.returnType, this.nominalType, this.receiverType);
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int i;
        if (this == LOOSE_TOP_FUNCTION) {
            return builder.append("LOOSE_TOP_FUNCTION");
        }
        if (this == TOP_FUNCTION) {
            return builder.append("TOP_FUNCTION");
        }
        if (this == QMARK_FUNCTION) {
            return builder.append("Function");
        }
        builder.append("function(");
        if (this.nominalType != null) {
            builder.append("new:");
            builder.append(this.nominalType);
            builder.append(',');
        } else if (this.receiverType != null) {
            builder.append("this:");
            builder.append(this.receiverType);
            builder.append(',');
        }
        for (i = 0; i < this.requiredFormals.size(); ++i) {
            ((JSType)this.requiredFormals.get(i)).appendTo(builder);
            builder.append(',');
        }
        for (i = 0; i < this.optionalFormals.size(); ++i) {
            ((JSType)this.optionalFormals.get(i)).appendTo(builder);
            builder.append("=,");
        }
        if (this.restFormals != null) {
            builder.append("...");
            this.restFormals.appendTo(builder);
        }
        if (builder.charAt(builder.length() - 1) == ',') {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(')');
        if (this.returnType != null) {
            builder.append(':');
            this.returnType.appendTo(builder);
        }
        if (this.isLoose()) {
            builder.append(" (loose)");
        }
        return builder;
    }
}

