/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.common.core.JptWorkspace;
import org.eclipse.jpt.common.core.resource.ProjectResourceLocator;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.core.resource.ResourceLocatorManager;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

public class SimpleProjectResourceLocator
implements ProjectResourceLocator {
    protected final IProject project;

    public SimpleProjectResourceLocator(IProject project) {
        this.project = project;
    }

    @Override
    public boolean locationIsValid(IContainer container) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator != null && resourceLocator.locationIsValid(this.project, container);
    }

    @Override
    public IContainer getDefaultLocation() {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator == null ? this.project : resourceLocator.getDefaultLocation(this.project);
    }

    @Override
    public IPath getWorkspacePath(IPath runtimePath) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator == null ? null : resourceLocator.getWorkspacePath(this.project, runtimePath);
    }

    @Override
    public IPath getRuntimePath(IPath resourcePath) {
        ResourceLocator resourceLocator = this.getResourceLocator();
        return resourceLocator == null ? null : resourceLocator.getRuntimePath(this.project, resourcePath);
    }

    @Override
    public IFile getPlatformFile(IPath runtimePath) {
        IPath sourcePath = this.getWorkspacePath(runtimePath);
        return sourcePath == null ? null : this.project.getWorkspace().getRoot().getFile(sourcePath);
    }

    protected ResourceLocator getResourceLocator() {
        ResourceLocatorManager rlManager = this.getResourceLocatorManager();
        return rlManager == null ? null : rlManager.getResourceLocator(this.project);
    }

    private ResourceLocatorManager getResourceLocatorManager() {
        JptWorkspace jptWorkspace = this.getJptWorkspace();
        return jptWorkspace == null ? null : jptWorkspace.getResourceLocatorManager();
    }

    private JptWorkspace getJptWorkspace() {
        return (JptWorkspace)this.getWorkspace().getAdapter(JptWorkspace.class);
    }

    private IWorkspace getWorkspace() {
        return this.project.getWorkspace();
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (Object)this.project);
    }
}

