/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.InterruptibleTransformer;

public class ConditionalInterruptibleTransformer<I, O>
implements InterruptibleTransformer<I, O> {
    private final Predicate<? super I> predicate;
    private final InterruptibleTransformer<? super I, ? extends O> trueTransformer;
    private final InterruptibleTransformer<? super I, ? extends O> falseTransformer;

    public ConditionalInterruptibleTransformer(Predicate<? super I> predicate, InterruptibleTransformer<? super I, ? extends O> trueTransformer, InterruptibleTransformer<? super I, ? extends O> falseTransformer) {
        if (predicate == null || trueTransformer == null || falseTransformer == null) {
            throw new NullPointerException();
        }
        this.predicate = predicate;
        this.trueTransformer = trueTransformer;
        this.falseTransformer = falseTransformer;
    }

    @Override
    public O transform(I input) throws InterruptedException {
        return this.predicate.evaluate(input) ? this.trueTransformer.transform(input) : this.falseTransformer.transform(input);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.predicate);
    }
}

