/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.wst.jsdt.chromium.debug.core.model.ConnectedTargetData;
import org.eclipse.wst.jsdt.chromium.debug.core.model.DebugTargetImpl;
import org.eclipse.wst.jsdt.chromium.debug.core.model.EvaluateContext;
import org.eclipse.wst.jsdt.chromium.debug.core.model.Messages;

class TargetInitializeState
extends DebugTargetImpl.State {
    private final DebugTargetImpl debugTargetImpl;
    private final ITerminate terminateAspect = new ITerminate(){
        private final AtomicBoolean isTerminated = new AtomicBoolean();

        public void terminate() throws DebugException {
            boolean updated = this.isTerminated.compareAndSet(false, true);
            if (updated) {
                DebugTargetImpl.fireDebugEvent(new DebugEvent((Object)TargetInitializeState.this.debugTargetImpl, 8));
            }
        }

        public boolean isTerminated() {
            return this.isTerminated.get();
        }

        public boolean canTerminate() {
            return !this.isTerminated();
        }
    };
    private static final IBreakpointListener STUB_BREAKPOINT_LISTENER = new IBreakpointListener(){

        public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        }

        public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        }

        public void breakpointAdded(IBreakpoint breakpoint) {
        }
    };
    private static final ISuspendResume STUB_SUSPEND_RESUME = new ISuspendResume(){

        public void suspend() throws DebugException {
        }

        public void resume() throws DebugException {
        }

        public boolean isSuspended() {
            return false;
        }

        public boolean canSuspend() {
            return false;
        }

        public boolean canResume() {
            return false;
        }
    };
    public static final IDisconnect STUB_DISONNECT = new IDisconnect(){

        public boolean isDisconnected() {
            return false;
        }

        public void disconnect() throws DebugException {
        }

        public boolean canDisconnect() {
            return false;
        }
    };

    TargetInitializeState(DebugTargetImpl debugTargetImpl) {
        this.debugTargetImpl = debugTargetImpl;
    }

    @Override
    ITerminate getTerminate() {
        return this.terminateAspect;
    }

    @Override
    ISuspendResume getSuspendResume() {
        return STUB_SUSPEND_RESUME;
    }

    @Override
    IDisconnect getDisconnect() {
        return STUB_DISONNECT;
    }

    @Override
    IBreakpointListener getBreakpointListner() {
        return STUB_BREAKPOINT_LISTENER;
    }

    @Override
    IThread[] getThreads() throws DebugException {
        return DebugTargetImpl.EMPTY_THREADS;
    }

    @Override
    String getName() {
        if (this.terminateAspect.isTerminated()) {
            return Messages.TargetInitializeState_TERMINATED;
        }
        return Messages.TargetInitializeState_INITIALIZING;
    }

    @Override
    boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return false;
    }

    @Override
    String getVmStatus() {
        return null;
    }

    @Override
    EvaluateContext getEvaluateContext() {
        return null;
    }

    @Override
    ConnectedTargetData getConnectedTargetDataOrNull() {
        return null;
    }
}

