/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.sampleapp.codegen;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.codegen.Visitor;
import org.eclipse.jst.ws.internal.consumption.codegen.VisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.bean.AttributeVisitor;
import org.eclipse.jst.ws.internal.consumption.codegen.bean.FieldVisitor;
import org.eclipse.jst.ws.internal.consumption.codegen.bean.TypeVisitor;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.AttributeElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.BeanElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeElement;
import org.eclipse.jst.ws.internal.consumption.datamodel.beanmodel.TypeFactory;
import org.eclipse.wst.ws.internal.datamodel.Element;

public class LevelsDeepVisitorAction
implements VisitorAction {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private int fLevelsDeep;
    private int fDeepestLevel;

    public LevelsDeepVisitorAction() {
        this.fLevelsDeep = 0;
    }

    public LevelsDeepVisitorAction(int current, boolean increment) {
        this.fLevelsDeep = current;
        if (increment) {
            ++this.fLevelsDeep;
        }
        this.fDeepestLevel = this.fLevelsDeep;
    }

    @Override
    public void initialize(String resident) {
    }

    @Override
    public void setVisitor(Visitor visitor) {
    }

    public int getLevelsDeep() {
        return this.fDeepestLevel;
    }

    @Override
    public IStatus visit(Object object) {
        Element element = (Element)object;
        if (element instanceof AttributeElement || element instanceof TypeElement) {
            TypeVisitor typeVisitor = new TypeVisitor();
            LevelsDeepVisitorAction lvda = new LevelsDeepVisitorAction(this.fLevelsDeep, true);
            typeVisitor.run(element, lvda);
            if (lvda.getLevelsDeep() > this.fDeepestLevel) {
                this.fDeepestLevel = lvda.getLevelsDeep();
            }
        } else if (element instanceof BeanElement && !TypeFactory.recognizedBean(element.getName())) {
            AttributeVisitor attributeVisitor = new AttributeVisitor();
            LevelsDeepVisitorAction lvda = new LevelsDeepVisitorAction(this.fLevelsDeep, false);
            attributeVisitor.run(element, lvda);
            if (lvda.getLevelsDeep() > this.fDeepestLevel) {
                this.fDeepestLevel = lvda.getLevelsDeep();
            }
            FieldVisitor fieldVisitor = new FieldVisitor();
            LevelsDeepVisitorAction lvda2 = new LevelsDeepVisitorAction(this.fLevelsDeep, false);
            fieldVisitor.run(element, lvda2);
            if (lvda2.getLevelsDeep() > this.fDeepestLevel) {
                this.fDeepestLevel = lvda2.getLevelsDeep();
            }
        }
        return Status.OK_STATUS;
    }
}

