/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.strategy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jst.jsf.common.internal.strategy.ISimpleStrategy;
import org.eclipse.jst.jsf.common.internal.strategy.StrategyComposite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MergingCompositionStrategy<INPUT, OUTPUT, MERGETYPE, STRATEGY extends ISimpleStrategy<INPUT, OUTPUT>>
extends StrategyComposite.AbstractCompositionStrategy<INPUT, OUTPUT, MERGETYPE, STRATEGY> {
    protected final MERGETYPE _composedResult;

    public MergingCompositionStrategy(MERGETYPE composedResult, MERGETYPE noResultValue) {
        this._composedResult = composedResult;
    }

    @Override
    public boolean compose(StrategyComposite.CompositionArguments<INPUT, OUTPUT, STRATEGY> args) throws Exception {
        Object result = args.getStrategy().perform(args.getInput());
        if (result != args.getStrategy().getNoResult()) {
            this.doCompose(result);
        }
        return false;
    }

    protected abstract void doCompose(OUTPUT var1);

    @Override
    public MERGETYPE getComposedResult() {
        return this._composedResult;
    }

    @Override
    public abstract void reset();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListMergingCompositionStrategy<INPUT, OUTPUT, MERGETYPE extends List, STRATEGY extends ISimpleStrategy<INPUT, OUTPUT>>
    extends MergingCompositionStrategy<INPUT, OUTPUT, MERGETYPE, STRATEGY> {
        public ListMergingCompositionStrategy(MERGETYPE composedResult, MERGETYPE noResultValue) {
            super(composedResult, noResultValue);
        }

        @Override
        protected void doCompose(OUTPUT result) {
            if (result instanceof Collection) {
                ((List)this._composedResult).addAll((Collection)result);
            } else {
                ((List)this._composedResult).add(result);
            }
        }

        @Override
        public void reset() {
            ((List)this._composedResult).clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class MapMergingCompositionStrategy<INPUT, OUTPUT, MERGETYPE extends Map, STRATEGY extends ISimpleStrategy<INPUT, OUTPUT>>
    extends MergingCompositionStrategy<INPUT, OUTPUT, MERGETYPE, STRATEGY> {
        public MapMergingCompositionStrategy(MERGETYPE composedResult, MERGETYPE noResultValue) {
            super(composedResult, noResultValue);
        }

        @Override
        protected void doCompose(OUTPUT result) {
            if (result instanceof Map) {
                ((Map)this._composedResult).putAll((Map)result);
            } else {
                ((Map)this._composedResult).put(this.calculateKey(result), result);
            }
        }

        protected abstract Object calculateKey(OUTPUT var1);

        @Override
        public void reset() {
            ((Map)this._composedResult).clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetMergingCompositionStrategy<INPUT, OUTPUT, MERGETYPE extends Set, STRATEGY extends ISimpleStrategy<INPUT, OUTPUT>>
    extends MergingCompositionStrategy<INPUT, OUTPUT, MERGETYPE, STRATEGY> {
        public SetMergingCompositionStrategy(MERGETYPE composedResult, MERGETYPE noResultValue) {
            super(composedResult, noResultValue);
        }

        @Override
        protected void doCompose(OUTPUT result) {
            if (result instanceof Collection) {
                ((Set)this._composedResult).addAll((Collection)result);
            } else {
                ((Set)this._composedResult).add(result);
            }
        }

        @Override
        public void reset() {
            ((Set)this._composedResult).clear();
        }
    }
}

