/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.jpql;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.ui.internal.swt.listeners.SWTListenerTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.jpql.JpaJpqlQueryHelper;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlCompletionProposalComputer;
import org.eclipse.jpt.jpa.ui.internal.jpql.JpqlDefaultCompletionProposal;
import org.eclipse.jpt.jpa.ui.internal.jpql.TextTransferHandler;
import org.eclipse.osgi.util.NLS;
import org.eclipse.persistence.jpa.jpql.JPQLQueryProblem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public final class JpaJpqlContentProposalProvider
extends JpqlCompletionProposalComputer<ICompletionProposal> {
    private AnnotationModel annotationModel;
    private SourceViewerDecorationSupport decorationSupport;
    private IHandlerActivation handlerActivation;
    private int position;
    private PropertyValueModel<? extends NamedQuery> queryHolder;
    private ResourceBundle resourceBundle;
    private SourceViewer sourceViewer;
    private JpqlSourceViewerConfiguration sourceViewerConfiguration;
    private StyledText styledText;
    private PropertyChangeListener subjectChangeListener;
    private ModifiablePropertyValueModel<String> textHolder;
    private PropertyChangeListener textListener;
    private static final String CONTROL_ID = "jpql.focus.control";
    private static final String ERROR_TYPE = "org.eclipse.jdt.ui.error";
    public static final String HYPERLINK_DETECTOR_ID = "org.eclipse.jpt.jpa.ui.jpql";

    public JpaJpqlContentProposalProvider(Composite parent, PropertyValueModel<? extends NamedQuery> queryHolder, ModifiablePropertyValueModel<String> textHolder) {
        this.initialize(parent, queryHolder, textHolder);
    }

    private void activateHandler() {
        IFocusService focusService = (IFocusService)WorkbenchTools.getService(IFocusService.class);
        IHandlerService handlerService = (IHandlerService)WorkbenchTools.getService(IHandlerService.class);
        if (focusService != null && handlerService != null) {
            focusService.addFocusTracker((Control)this.styledText, CONTROL_ID + this.hashCode());
            Expression expression = this.buildExpression();
            IHandler handler = this.buildHandler();
            this.handlerActivation = handlerService.activateHandler("org.eclipse.ui.edit.text.contentAssist.proposals", handler, expression);
            this.handlerActivation = handlerService.activateHandler(ActionFactory.UNDO.getCommandId(), handler, expression);
            this.handlerActivation = handlerService.activateHandler(ActionFactory.REDO.getCommandId(), handler, expression);
        }
    }

    private List<AnnotationPreference> annotationPreferences() {
        return EditorsPlugin.getDefault().getMarkerAnnotationPreferences().getAnnotationPreferences();
    }

    private DisposeListener buildDisposeListener() {
        return new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JpaJpqlContentProposalProvider.this.dispose();
            }
        };
    }

    private IDocumentListener buildDocumentListener() {
        return new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                try {
                    IDocument document = event.getDocument();
                    String text = document.get(0, document.getLength());
                    JpaJpqlContentProposalProvider.this.textHolder.setValue((Object)text);
                    JpaJpqlContentProposalProvider.this.validate();
                }
                catch (BadLocationException badLocationException) {}
            }
        };
    }

    private Expression buildExpression() {
        return new Expression(){

            public void collectExpressionInfo(ExpressionInfo info) {
                info.addVariableNameAccess("activeFocusControl");
            }

            public EvaluationResult evaluate(IEvaluationContext context) {
                Object variable = context.getVariable("activeFocusControl");
                return variable == JpaJpqlContentProposalProvider.this.styledText ? EvaluationResult.TRUE : EvaluationResult.FALSE;
            }
        };
    }

    private IHandler buildHandler() {
        return new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                String commandId = event.getCommand().getId();
                if ("org.eclipse.ui.edit.text.contentAssist.proposals".equals(commandId)) {
                    JpaJpqlContentProposalProvider.this.sourceViewer.doOperation(13);
                } else if (ActionFactory.UNDO.getCommandId().equals(commandId)) {
                    if (JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().undoable()) {
                        JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().undo();
                        JpaJpqlContentProposalProvider.this.validate();
                    }
                } else if (ActionFactory.REDO.getCommandId().equals(commandId) && JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().redoable()) {
                    JpaJpqlContentProposalProvider.this.sourceViewer.getUndoManager().redo();
                    JpaJpqlContentProposalProvider.this.validate();
                }
                return null;
            }
        };
    }

    private String buildMessage(JPQLQueryProblem problem) {
        String message = this.resourceBundle().getString(problem.getMessageKey());
        message = MessageFormat.format(message, problem.getMessageArguments());
        return message;
    }

    private ModifyListener buildModifyListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JpaJpqlContentProposalProvider.this.validate();
            }
        };
    }

    private Comparator<JPQLQueryProblem> buildProblemComparator() {
        return new Comparator<JPQLQueryProblem>(){

            @Override
            public int compare(JPQLQueryProblem problem1, JPQLQueryProblem problem2) {
                int result = problem1.getStartPosition() - problem2.getStartPosition();
                if (result == 0) {
                    result = problem1.getEndPosition() - problem2.getEndPosition();
                }
                return result;
            }
        };
    }

    @Override
    ICompletionProposal buildProposal(String proposal, String displayString, String additionalInfo, Image image, int cursorOffset) {
        return new JpqlDefaultCompletionProposal(this.contentAssistProposals, proposal, displayString, additionalInfo, image, this.namedQuery, this.jpqlQuery, this.tokenStart, this.tokenEnd, this.position, cursorOffset);
    }

    private PropertyChangeListener buildSubjectChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                JpaJpqlContentProposalProvider.this.subjectChanged(e);
            }
        };
    }

    private PropertyChangeListener buildTextListener() {
        return SWTListenerTools.wrap((PropertyChangeListener)new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent event) {
                String text = (String)event.getNewValue();
                if (text == null) {
                    text = "";
                }
                if (!JpaJpqlContentProposalProvider.this.styledText.getText().equals(text)) {
                    JpaJpqlContentProposalProvider.this.sourceViewer.getDocument().set(text);
                }
            }
        });
    }

    private Image contentAssistImage() {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        return registry.getFieldDecoration("DEC_CONTENT_PROPOSAL").getImage();
    }

    private void dispose() {
        this.sessionEnded();
        this.decorationSupport.dispose();
        this.textHolder.removePropertyChangeListener("value", this.textListener);
        this.queryHolder.removePropertyChangeListener("value", this.subjectChangeListener);
        IHandlerService handlerService = (IHandlerService)WorkbenchTools.getService(IHandlerService.class);
        if (handlerService != null) {
            handlerService.deactivateHandler(this.handlerActivation);
        }
    }

    private KeyStroke findContentAssistTrigger() {
        IBindingService bindingService = (IBindingService)WorkbenchTools.getService(IBindingService.class);
        Binding[] bindingArray = bindingService.getBindings();
        int n = bindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger[] triggers;
            Binding binding = bindingArray[n2];
            if (this.isContentAssistBinding(binding) && (triggers = binding.getTriggerSequence().getTriggers()) != null && triggers.length > 0) {
                return (KeyStroke)triggers[0];
            }
            ++n2;
        }
        return KeyStroke.getInstance((int)262144, (int)32);
    }

    public StyledText getStyledText() {
        return this.styledText;
    }

    private void initialize(Composite parent, PropertyValueModel<? extends NamedQuery> queryHolder, ModifiablePropertyValueModel<String> textHolder) {
        this.queryHolder = queryHolder;
        this.annotationModel = new AnnotationModel();
        this.textHolder = textHolder;
        this.textListener = this.buildTextListener();
        textHolder.addPropertyChangeListener("value", this.textListener);
        this.subjectChangeListener = this.buildSubjectChangeListener();
        queryHolder.addPropertyChangeListener("value", this.subjectChangeListener);
        this.sourceViewer = new SourceViewer(parent, null, 8391490);
        this.sourceViewerConfiguration = new JpqlSourceViewerConfiguration();
        this.sourceViewer.configure((SourceViewerConfiguration)this.sourceViewerConfiguration);
        this.sourceViewer.setDocument((IDocument)new Document(), (IAnnotationModel)this.annotationModel);
        this.sourceViewer.getDocument().addDocumentListener(this.buildDocumentListener());
        this.styledText = this.sourceViewer.getTextWidget();
        this.styledText.addModifyListener(this.buildModifyListener());
        this.styledText.addDisposeListener(this.buildDisposeListener());
        this.installDecorationSupport();
        this.activateHandler();
        TextTransferHandler.installContextMenu(this.styledText, this.sourceViewer.getUndoManager());
        this.sourceViewer.getDocument().set((String)textHolder.getValue());
    }

    public void installControlDecoration() {
        KeyStroke contentAssistTrigger = this.findContentAssistTrigger();
        String key = SWTKeySupport.getKeyFormatterForPlatform().format(contentAssistTrigger);
        ControlDecoration decoration = new ControlDecoration((Control)this.styledText, 16512);
        decoration.setDescriptionText(NLS.bind((String)JptJpaUiMessages.JPQL_CONTENT_PROPOSAL_PROVIDER_DESCRIPTION, (Object)key));
        decoration.setImage(this.contentAssistImage());
        decoration.setShowOnlyOnFocus(true);
    }

    private void installDecorationSupport() {
        this.decorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.sourceViewer, null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), EditorsPlugin.getDefault().getSharedTextColors());
        for (AnnotationPreference preference : this.annotationPreferences()) {
            this.decorationSupport.setAnnotationPreference(preference);
        }
        this.decorationSupport.install(EditorsPlugin.getDefault().getPreferenceStore());
    }

    private boolean isContentAssistBinding(Binding binding) {
        ParameterizedCommand command = binding.getParameterizedCommand();
        return command != null && command.getCommand() != null && command.getCommand().getId().equals("org.eclipse.ui.edit.text.contentAssist.proposals");
    }

    private NamedQuery query() {
        return (NamedQuery)this.queryHolder.getValue();
    }

    private ResourceBundle resourceBundle() {
        if (this.resourceBundle == null) {
            this.resourceBundle = ResourceBundle.getBundle("jpt_jpa_core_jpql_validation", Locale.getDefault(), JpaJpqlQueryHelper.class.getClassLoader());
        }
        return this.resourceBundle;
    }

    private List<JPQLQueryProblem> sortProblems(List<JPQLQueryProblem> problems) {
        Collections.sort(problems, this.buildProblemComparator());
        return problems;
    }

    private void subjectChanged(PropertyChangeEvent e) {
        this.namedQuery = (NamedQuery)e.getNewValue();
        if (this.namedQuery != null) {
            this.sourceViewer.getUndoManager().reset();
            this.validate();
        } else {
            this.queryHelper = null;
            this.annotationModel.removeAllAnnotations();
        }
    }

    private void validate() {
        this.annotationModel.removeAllAnnotations();
        if (this.query() == null || this.styledText.isDisposed() || StringTools.isBlank((String)this.styledText.getText())) {
            return;
        }
        try {
            if (this.queryHelper == null) {
                this.namedQuery = this.query();
                this.queryHelper = this.namedQuery.getPersistenceUnit().createJpqlQueryHelper();
            }
            String jpqlQuery = this.styledText.getText();
            this.queryHelper.setQuery(this.query(), jpqlQuery);
            String parsedJpqlQuery = this.queryHelper.getParsedJPQLQuery();
            for (JPQLQueryProblem problem : this.sortProblems(this.queryHelper.validate())) {
                int[] positions = this.queryHelper.buildPositions(problem, parsedJpqlQuery, jpqlQuery, jpqlQuery, 0, JpaJpqlQueryHelper.EscapeType.NONE);
                Annotation annotation = new Annotation(ERROR_TYPE, true, this.buildMessage(problem));
                this.annotationModel.addAnnotation(annotation, new Position(positions[0], positions[1] - positions[0]));
            }
        }
        finally {
            this.queryHelper.dispose();
        }
    }

    private class ContentAssistProcessor
    implements IContentAssistProcessor {
        private ContentAssistProcessor() {
        }

        public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
            NamedQuery namedQuery = JpaJpqlContentProposalProvider.this.query();
            if (namedQuery == null) {
                return new ICompletionProposal[0];
            }
            JpaJpqlContentProposalProvider.this.position = offset;
            String jpqlQuery = viewer.getDocument().get();
            List<ICompletionProposal> proposals = JpaJpqlContentProposalProvider.this.buildProposals(namedQuery, jpqlQuery, 0, jpqlQuery.length(), JpaJpqlContentProposalProvider.this.position, JpaJpqlContentProposalProvider.this.getResourceManager());
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }

        public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
            return null;
        }

        public char[] getCompletionProposalAutoActivationCharacters() {
            return null;
        }

        public char[] getContextInformationAutoActivationCharacters() {
            return null;
        }

        public IContextInformationValidator getContextInformationValidator() {
            return null;
        }

        public String getErrorMessage() {
            return null;
        }
    }

    private class JpqlSourceViewerConfiguration
    extends TextSourceViewerConfiguration {
        ContentAssistant contentAssistant;

        JpqlSourceViewerConfiguration() {
            super(EditorsPlugin.getDefault().getPreferenceStore());
        }

        private IAdaptable buildAdaptable() {
            return new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (adapter == NamedQuery.class) {
                        return JpaJpqlContentProposalProvider.this.query();
                    }
                    return null;
                }
            };
        }

        private IInformationControlCreator buildInformationControlCreator() {
            return new IInformationControlCreator(){

                public IInformationControl createInformationControl(Shell parent) {
                    return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString(), (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
                }
            };
        }

        public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
            this.contentAssistant = new ContentAssistant();
            this.contentAssistant.setContentAssistProcessor((IContentAssistProcessor)new ContentAssistProcessor(), "__dftl_partition_content_type");
            this.contentAssistant.setInformationControlCreator(this.buildInformationControlCreator());
            return this.contentAssistant;
        }

        protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
            HashMap<String, IAdaptable> targets = new HashMap<String, IAdaptable>();
            targets.put(JpaJpqlContentProposalProvider.HYPERLINK_DETECTOR_ID, this.buildAdaptable());
            return targets;
        }
    }
}

