/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.internal.context.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetch;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkJoinFetchType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.JoinFetchAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.JoinFetchType;

public class EclipseLinkJavaJoinFetch
extends AbstractJavaContextModel<JavaAttributeMapping>
implements EclipseLinkJoinFetch {
    protected EclipseLinkJoinFetchType value = this.buildValue();

    public EclipseLinkJavaJoinFetch(JavaAttributeMapping parent) {
        super((JpaContextModel)parent);
    }

    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setValue_(this.buildValue());
    }

    @Override
    public EclipseLinkJoinFetchType getValue() {
        return this.value;
    }

    @Override
    public void setValue(EclipseLinkJoinFetchType value) {
        if (ObjectTools.notEquals((Object)((Object)value), (Object)((Object)this.value))) {
            JoinFetchAnnotation annotation = this.getJoinFetchAnnotation();
            if (value == null) {
                if (annotation != null) {
                    this.removeJoinFetchAnnotation();
                }
            } else {
                if (annotation == null) {
                    annotation = this.addJoinFetchAnnotation();
                }
                annotation.setValue(EclipseLinkJoinFetchType.toJavaResourceModel(value));
            }
            this.setValue_(value);
        }
    }

    protected void setValue_(EclipseLinkJoinFetchType value) {
        EclipseLinkJoinFetchType old = this.value;
        this.value = value;
        this.firePropertyChanged("value", (Object)old, (Object)value);
    }

    private EclipseLinkJoinFetchType buildValue() {
        JoinFetchAnnotation annotation = this.getJoinFetchAnnotation();
        if (annotation == null) {
            return null;
        }
        JoinFetchType annotationValue = annotation.getValue();
        return annotationValue != null ? EclipseLinkJoinFetchType.fromJavaResourceModel(annotationValue) : this.getDefaultValue();
    }

    protected EclipseLinkJoinFetchType getDefaultValue() {
        return DEFAULT_VALUE;
    }

    protected JoinFetchAnnotation getJoinFetchAnnotation() {
        return (JoinFetchAnnotation)this.getResourceAttribute().getAnnotation(this.getJoinFetchAnnotationName());
    }

    protected JoinFetchAnnotation addJoinFetchAnnotation() {
        return (JoinFetchAnnotation)this.getResourceAttribute().addAnnotation(this.getJoinFetchAnnotationName());
    }

    protected void removeJoinFetchAnnotation() {
        this.getResourceAttribute().removeAnnotation(this.getJoinFetchAnnotationName());
    }

    protected String getJoinFetchAnnotationName() {
        return "org.eclipse.persistence.annotations.JoinFetch";
    }

    protected JavaAttributeMapping getAttributeMapping() {
        return (JavaAttributeMapping)this.parent;
    }

    protected JavaResourceAttribute getResourceAttribute() {
        return this.getAttributeMapping().getResourceAttribute();
    }

    public TextRange getValidationTextRange() {
        TextRange textRange = this.getAnnotationTextRange();
        return textRange != null ? textRange : this.getAttributeMapping().getValidationTextRange();
    }

    protected TextRange getAnnotationTextRange() {
        JoinFetchAnnotation annotation = this.getJoinFetchAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

