/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.tests.contentassist;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.jsdt.web.ui.tests.contentassist.ContentAssistTestUtilities;
import org.eclipse.wst.jsdt.web.ui.tests.internal.TestProjectSetup;

public class GlobalVariableTests_Edited
extends TestCase {
    private static final String TEST_NAME = "Test Global Field Variables JavaScript Content Assist after Edit";
    private static TestProjectSetup fTestProjectSetup;

    public GlobalVariableTests_Edited() {
        super(TEST_NAME);
    }

    public GlobalVariableTests_Edited(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(GlobalVariableTests_Edited.class, TEST_NAME);
        fTestProjectSetup = new TestProjectSetup((Test)ts, "JSDTWebContentAssist", "WebContent", false){

            @Override
            public void additionalSetUp() throws Exception {
                this.editFile("Global.js", 1, 4, 12, "globalEditedNumber");
                this.editFile("Global.js", 7, 0, 12, "globalEditedString");
                this.editFile("Global.js", 11, 6, 1, "E");
                this.editFile("Global.js", 15, 1, 1, "E");
                this.editFile("Global.js", 17, 1, 1, "E");
                this.editFile("Global.html", 10, 6, 1, "E");
                this.editFile("Global.html", 12, 1, 1, "E");
                this.editFile("Global.html", 14, 1, 1, "E");
            }
        };
        return fTestProjectSetup;
    }

    public void testFindFieldSuggestions_AfterEdit_Expression_NotStarted() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalEditedString : String - Global", "globalEditedNumber : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global", "globalVar - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 6, 0, expectedProposals);
    }

    public void testFindFieldSuggestions_AfterEdit_ExpressionStarted_1() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalNum : Number - Global", "globalEditedString : String - Global", "globalVar - Global", "globalEditedNumber : Number - Global", "globalVarObject : {} - Global", "globalVarString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 8, 1, expectedProposals);
    }

    public void testFindFieldSuggestions_AfterEdit_ExpressionStarted_2() throws Exception {
        String[][] expectedProposals = new String[][]{{"globalEditedNumber : Number - Global", "globalEditedString : String - Global"}};
        ContentAssistTestUtilities.runProposalTest(fTestProjectSetup, "Global.html", 10, 6, expectedProposals);
    }
}

