/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.compiler.util;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ExclusionTests
extends TestCase {
    private static final String PROJECT_NAME = "ExclusionTests";
    private static IProject fProject;

    public ExclusionTests() {
        super("Exclusion Tests");
    }

    public ExclusionTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite ts = new TestSuite(ExclusionTests.class, "Exclusion Tests");
        return new ExclusionTestsSetup((Test)ts);
    }

    public void testExcluded_DirPathWorkspaceRelative_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathWorkspaceRelative_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelative_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelative_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelative_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelative_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelative_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelative() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelative_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelativeLeadingSeperator_DirExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathAbsolute_DirExcludedWorkspaceRelative() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathAbsolute_DirExcludedWorkspaceRelativeLeadingSeperator() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_DirExcludedWorkspaceRelative() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_DirExcludedWorkspaceRelativeLeadingSeperator() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathAbsolute_DirExcludedWorkspaceRelative() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathAbsolute_DirExcludedWorkspaceRelativeLeadingSeperator() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathAbsolute_DirExcludedWorkspaceRelative() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathAbsolute_DirExcludedWorkspaceRelativeLeadingSeperator() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathAbsolute_DirExcludedAbsolute() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/").toPortableString().toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_DirExcludedAbsolute() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/").toPortableString().toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathAbsolute_DirExcludedAbsolute() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/").toPortableString().toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathAbsolute_DirExcludedAbsolute() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/").toPortableString().toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelative_FileExcludedWorkspaceRelative() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelative_FileExcludedWorkspaceRelative_2() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelative() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelative_2() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelative_FileExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelative_FileExcludedWorkspaceRelativeLeadingSeperator_2() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelativeLeadingSeperator_2() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelative_FileExcludedWorkspaceRelative() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelative() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelative_FileExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("/ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelative_FileExcludedWorkspaceRelative() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelative() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelative_FileExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathWorkspaceRelativeLeadingSeperator_FileExcludedWorkspaceRelativeLeadingSeperator() {
        Path resourcePath = new Path("/foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_FileExcludedWorkspaceRelative() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_FileExcludedWorkspaceRelative_2() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_FileExcludedWorkspaceRelativeLeadingSeperator() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_FileExcludedWorkspaceRelativeLeadingSeperator_2() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathAbsolute_FileExcludedWorkspaceRelative() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathAbsolute_FileExcludedWorkspaceRelativeLeadingSeperator() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathAbsolute_FileExcludedWorkspaceRelative() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathAbsolute_FileExcludedWorkspaceRelativeLeadingSeperator() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "/ExclusionTests/WebContent/dojo/dijit/_Widget.js".toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_FileExcludedAbsolute() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js").toPortableString().toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_DirPathAbsolute_FileExcludedAbsolute_2() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js").toPortableString().toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_FilePathAbsolute_FileExcludedAbsolute() {
        IPath resourcePath = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js").toPortableString().toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testNotExcluded_FilePathAbsolute_FileExcludedAbsolute() {
        IPath resourcePath = fProject.getLocation().append("foo/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = fProject.getLocation().append("/WebContent/dojo/dijit/_Widget.js").toPortableString().toCharArray();
        ExclusionTests.assertFalse((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathWorkspaceRelative_DirExcludedWorkspaceRelativeStarWildCard() {
        Path resourcePath = new Path("ExclusionTests/WebContent/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/*/dijit/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    public void testExcluded_DirPathWorkspaceRelative_DirExcludedWorkspaceRelativeDoubleStarWildCard() {
        Path resourcePath = new Path("ExclusionTests/WebContent/foo/dojo/dijit/_Widget.js");
        char[][] inclusionPatterns = null;
        char[][] exclusionPatterns = new char[1][0];
        exclusionPatterns[0] = "ExclusionTests/WebContent/**/dijit/".toCharArray();
        ExclusionTests.assertTrue((boolean)Util.isExcluded((IPath)resourcePath, inclusionPatterns, (char[][])exclusionPatterns));
    }

    private static IProject createProject(String name, IPath location, String[] natureIds) {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (location != null) {
            description.setLocation(location);
        }
        if (natureIds != null) {
            description.setNatureIds(natureIds);
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return project;
    }

    private static class ExclusionTestsSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public ExclusionTestsSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            fProject = ExclusionTests.createProject(ExclusionTests.PROJECT_NAME, null, null);
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
        }

        public void tearDown() throws Exception {
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

