/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching;

import java.nio.charset.Charset;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.internal.core.StreamsProxy;
import org.eclipse.wst.jsdt.debug.internal.core.launching.JavaScriptProcess;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.RhinoUIPlugin;

public class RhinoProcess
extends JavaScriptProcess {
    public static final String TYPE = "rhino";
    private Process process = null;
    private StreamsProxy streamproxy = null;

    public RhinoProcess(ILaunch launch, Process p, String name) {
        super(launch, name);
        boolean needsstreams;
        this.process = p;
        String capture = launch.getAttribute("org.eclipse.debug.core.capture_output");
        boolean bl = needsstreams = capture == null ? true : Boolean.valueOf(capture);
        if (needsstreams) {
            this.streamproxy = new StreamsProxy(p, Charset.forName(launch.getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING")), "js");
        }
        this.setAttribute(IProcess.ATTR_PROCESS_TYPE, TYPE);
    }

    protected IStreamsProxy createStreamsProxy() {
        String encoding = this.getLaunch().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
        Charset charset = null;
        if (encoding != null) {
            try {
                charset = Charset.forName(encoding);
            }
            catch (Exception e) {
                RhinoUIPlugin.log(e);
                charset = Charset.defaultCharset();
            }
        }
        return new StreamsProxy(this.process, charset, "js");
    }

    public void terminate() throws DebugException {
        this.process.destroy();
        if (this.streamproxy != null) {
            this.streamproxy.close();
        }
        super.terminate();
    }

    public IStreamsProxy getStreamsProxy() {
        return this.streamproxy;
    }
}

