/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math3.fraction.Fraction;
import org.eclipse.jpt.common.utility.internal.SimplePair;
import org.eclipse.jpt.common.utility.internal.StringBuilderTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.tests.internal.AbstractStringBuilderToolsTests;
import org.junit.Assert;

public class StringBuilderToolsTests
extends AbstractStringBuilderToolsTests {
    public StringBuilderToolsTests(String name) {
        super(name);
    }

    @Override
    protected void verifyConvertToCharArray(String string) {
        StringBuilder sb = new StringBuilder();
        sb.append(string);
        Assert.assertArrayEquals((char[])string.toCharArray(), (char[])StringBuilderTools.convertToCharArray((StringBuilder)sb));
    }

    @Override
    protected void verifyReverse(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.reverse((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.reverse((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyCenter(String expected, String s, int len) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.center((StringBuilder)sb, (String)s, (int)len);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.center((StringBuilder)sb, (char[])s.toCharArray(), (int)len);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyPad(String expected, String string, int length) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.pad((StringBuilder)sb, (String)string, (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.pad((StringBuilder)sb, (char[])string.toCharArray(), (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyFit(String expected, String string, int length) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.fit((StringBuilder)sb, (String)string, (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.fit((StringBuilder)sb, (char[])string.toCharArray(), (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyZeroPad(String expected, String string, int length) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.zeroPad((StringBuilder)sb, (String)string, (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.zeroPad((StringBuilder)sb, (char[])string.toCharArray(), (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyZeroFit(String expected, String string, int length) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.zeroFit((StringBuilder)sb, (String)string, (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.zeroFit((StringBuilder)sb, (char[])string.toCharArray(), (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRepeat(String expected, String string, int length) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.repeat((StringBuilder)sb, (String)string, (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.repeat((StringBuilder)sb, (char[])string.toCharArray(), (int)length);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifySeparate(String expected, String string, char separator, int segmentLength) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.separate((StringBuilder)sb, (String)string, (char)separator, (int)segmentLength);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.separate((StringBuilder)sb, (char[])string.toCharArray(), (char)separator, (int)segmentLength);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyDelimit(String expected, String string, String delimiter) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.delimit((StringBuilder)sb, (String)string, (String)delimiter);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.delimit((StringBuilder)sb, (char[])string.toCharArray(), (char[])delimiter.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyQuote(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.quote((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.quote((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveFirstOccurrence(String expected, String string, char charToRemove) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.removeFirstOccurrence((StringBuilder)sb, (String)string, (char)charToRemove);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.removeFirstOccurrence((StringBuilder)sb, (char[])string.toCharArray(), (char)charToRemove);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveAllOccurrences(String expected, String string, char charToRemove) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.removeAllOccurrences((StringBuilder)sb, (String)string, (char)charToRemove);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.removeAllOccurrences((StringBuilder)sb, (char[])string.toCharArray(), (char)charToRemove);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveAllSpaces(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.removeAllSpaces((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.removeAllSpaces((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyRemoveAllWhitespace(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.removeAllWhitespace((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.removeAllWhitespace((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyCompressWhitespace(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.compressWhitespace((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.compressWhitespace((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyCapitalize(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.capitalize((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.capitalize((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyUncapitalize(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.uncapitalize((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.uncapitalize((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToHexString(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToHexString((StringBuilder)sb, (byte[])string.getBytes());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertCamelCaseToAllCaps(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertCamelCaseToAllCaps((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertCamelCaseToAllCaps((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertCamelCaseToAllCapsMaxLength(String expected, String string, int maxLength) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertCamelCaseToAllCaps((StringBuilder)sb, (String)string, (int)maxLength);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertCamelCaseToAllCaps((StringBuilder)sb, (char[])string.toCharArray(), (int)maxLength);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertAllCapsToCamelCase((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertAllCapsToCamelCase((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertAllCapsToCamelCase(String expected, String string, boolean capFirst) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertAllCapsToCamelCase((StringBuilder)sb, (String)string, (boolean)capFirst);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertAllCapsToCamelCase((StringBuilder)sb, (char[])string.toCharArray(), (boolean)capFirst);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyUndelimit(String expected, String s) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.undelimit((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.undelimit((StringBuilder)sb, (char[])s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyUndelimitCount(String expected, String s, int count) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.undelimit((StringBuilder)sb, (String)s, (int)count);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.undelimit((StringBuilder)sb, (char[])s.toCharArray(), (int)count);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToJavaStringLiteral(String expected, String s) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToJavaStringLiteral((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToJavaStringLiteral((StringBuilder)sb, (char[])s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToJavaStringLiteralContent(String expected, String s) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToJavaStringLiteralContent((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToJavaStringLiteralContent((StringBuilder)sb, (char[])s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlAttributeValue(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToXmlAttributeValue((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToXmlAttributeValue((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValue(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValue((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToDoubleQuotedXmlAttributeValueContent(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToDoubleQuotedXmlAttributeValueContent((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValue(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToSingleQuotedXmlAttributeValue((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToSingleQuotedXmlAttributeValueContent(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToSingleQuotedXmlAttributeValueContent((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlElementText(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToXmlElementText((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToXmlElementText((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlElementCDATA(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToXmlElementCDATA((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToXmlElementCDATA((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected void verifyConvertToXmlElementCDATAContent(String expected, String string) {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.convertToXmlElementCDATAContent((StringBuilder)sb, (String)string);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.convertToXmlElementCDATAContent((StringBuilder)sb, (char[])string.toCharArray());
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    @Override
    protected Class<?> getToolsClass() {
        return StringBuilderTools.class;
    }

    public void testAppendJSONMap() throws Exception {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("left", "name");
        map.put("right", "Fred");
        StringBuilderTools.appendJSON((StringBuilder)sb, map);
        StringBuilderToolsTests.assertEquals((String)"{\"left\":\"name\",\"right\":\"Fred\"}", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, map);
        StringBuilderToolsTests.assertEquals((String)"{\"left\":\"name\",\"right\":\"Fred\"}", (String)sb.toString());
    }

    public void testAppendJSONMap_reflection() throws Exception {
        StringBuilder sb = new StringBuilder();
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(42, "Fred");
        StringBuilderToolsTests.assertFalse((boolean)map.keySet().isEmpty());
        StringBuilderToolsTests.assertFalse((boolean)map.entrySet().isEmpty());
        StringBuilderTools.appendJSON((StringBuilder)sb, map);
        String expected = "{\"entrySet\":[{\"hash\":42,\"key\":42,\"next\":null,\"value\":\"Fred\"}],\"keySet\":[42],\"loadFactor\":0.75,\"modCount\":1,\"size\":1,\"table\":[null,null,null,null,null,null,null,null,null,null,{\"hash\":42,\"key\":42,\"next\":null,\"value\":\"Fred\"},null,null,null,null,null],\"threshold\":12,\"values\":null}";
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, map);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testAppendJSONMap_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, new HashMap());
        StringBuilderToolsTests.assertEquals((String)"{}", (String)sb.toString());
    }

    public void testAppendJSONMap_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Map map = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, map);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONString() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "foo";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"foo\"", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)s);
        StringBuilderToolsTests.assertEquals((String)"\"foo\"", (String)sb.toString());
    }

    public void testAppendJSONString_specialChars() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "\"foo\"";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\\"foo\\\"\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\\";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\\\\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\b";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\b\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\f";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\f\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\n";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\n\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\r";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\r\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\t";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\t\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\u0012";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\u0012\"", (String)sb.toString());
        sb = new StringBuilder();
        s = "\u0002";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\\u0002\"", (String)sb.toString());
    }

    public void testAppendJSONString_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "";
        StringBuilderTools.appendJSON((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"\"\"", (String)sb.toString());
    }

    public void testAppendJSONString_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, s);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONContentString() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "foo";
        StringBuilderTools.appendJSONContent((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"foo", (String)sb.toString());
    }

    public void testAppendJSONContentString_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "";
        StringBuilderTools.appendJSONContent((StringBuilder)sb, (String)s);
        StringBuilderToolsTests.assertEquals((String)"", (String)sb.toString());
    }

    public void testAppendJSONContentString_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = null;
        StringBuilderTools.appendJSONContent((StringBuilder)sb, s);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONCharArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "foo";
        StringBuilderTools.appendJSON((StringBuilder)sb, (char[])s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)"\"foo\"", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)"\"foo\"", (String)sb.toString());
    }

    public void testAppendJSONCharArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "";
        StringBuilderTools.appendJSON((StringBuilder)sb, (char[])s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)"\"\"", (String)sb.toString());
    }

    public void testAppendJSONCharArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        char[] s = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, s);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONContentCharArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "foo";
        StringBuilderTools.appendJSONContent((StringBuilder)sb, (char[])s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)"foo", (String)sb.toString());
    }

    public void testAppendJSONContentCharArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        String s = "";
        StringBuilderTools.appendJSONContent((StringBuilder)sb, (char[])s.toCharArray());
        StringBuilderToolsTests.assertEquals((String)"", (String)sb.toString());
    }

    public void testAppendJSONContentCharArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        char[] s = null;
        StringBuilderTools.appendJSONContent((StringBuilder)sb, s);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONIterable() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = new Object[4];
        objectArray[0] = new SimplePair((Object)"name", (Object)"Fred");
        objectArray[1] = new SimplePair((Object)"age", (Object)42);
        objectArray[2] = new SimplePair((Object)"sex", (Object)"male");
        Object[] array = objectArray;
        Iterable iterable = IterableTools.iterable((Object[])array);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Iterable)iterable);
        String expected = "[{\"left\":\"name\",\"right\":\"Fred\"},{\"left\":\"age\",\"right\":42},{\"left\":\"sex\",\"right\":\"male\"},null]";
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)iterable);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testAppendJSONIterable_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = new Object[]{};
        Iterable iterable = IterableTools.iterable((Object[])array);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Iterable)iterable);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONIterable_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterable iterable = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, iterable);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONObjectArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = new Object[4];
        objectArray[0] = new SimplePair((Object)"name", (Object)"Fred");
        objectArray[1] = new SimplePair((Object)"age", (Object)42);
        objectArray[2] = new SimplePair((Object)"sex", (Object)"male");
        Object[] array = objectArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object[])array);
        String expected = "[{\"left\":\"name\",\"right\":\"Fred\"},{\"left\":\"age\",\"right\":42},{\"left\":\"sex\",\"right\":\"male\"},null]";
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)expected, (String)sb.toString());
    }

    public void testAppendJSONObjectArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = new Object[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONObjectArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONObject() throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)new SimplePair((Object)"name", (Object)"Fred"));
        StringBuilderToolsTests.assertEquals((String)"{\"left\":\"name\",\"right\":\"Fred\"}", (String)sb.toString());
    }

    public void testAppendJSONObject_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)new Object());
        StringBuilderToolsTests.assertEquals((String)"{}", (String)sb.toString());
    }

    public void testAppendJSONBooleanArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] objectArray = new Boolean[4];
        objectArray[0] = true;
        objectArray[1] = false;
        objectArray[2] = true;
        Object[] array = objectArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Boolean[])array);
        StringBuilderToolsTests.assertEquals((String)"[true,false,true,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[true,false,true,null]", (String)sb.toString());
    }

    public void testAppendJSONBooleanArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = new Boolean[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Boolean[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONBooleanArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Boolean[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONBoolean() throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Boolean)true);
        StringBuilderToolsTests.assertEquals((String)"true", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Boolean)false);
        StringBuilderToolsTests.assertEquals((String)"false", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)true);
        StringBuilderToolsTests.assertEquals((String)"true", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)false);
        StringBuilderToolsTests.assertEquals((String)"false", (String)sb.toString());
    }

    public void testAppendJSONBooleanPrimitiveArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[2] = true;
        boolean[] array = blArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (boolean[])array);
        StringBuilderToolsTests.assertEquals((String)"[true,false,true]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)"[true,false,true]", (String)sb.toString());
    }

    public void testAppendJSONBooleanPrimitiveArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean[] array = new boolean[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (boolean[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONBooleanPrimitiveArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        boolean[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONBooleanPrimitive() throws Exception {
        StringBuilder sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (boolean)true);
        StringBuilderToolsTests.assertEquals((String)"true", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (boolean)false);
        StringBuilderToolsTests.assertEquals((String)"false", (String)sb.toString());
    }

    public void testAppendJSONNumber() throws Exception {
        StringBuilder sb = new StringBuilder();
        Number n = 7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
        sb = new StringBuilder();
        n = 7.7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"7.7", (String)sb.toString());
        sb = new StringBuilder();
        n = (byte)7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
        sb = new StringBuilder();
        n = Float.valueOf(7.7f);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"7.7", (String)sb.toString());
        sb = new StringBuilder();
        n = 123456789123456789L;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"123456789123456789", (String)sb.toString());
        sb = new StringBuilder();
        n = (short)7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
        sb = new StringBuilder();
        n = BigDecimal.valueOf(123456789123456789L, 5);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"1234567891234.56789", (String)sb.toString());
        sb = new StringBuilder();
        n = BigInteger.valueOf(123456789123456789L);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"123456789123456789", (String)sb.toString());
        sb = new StringBuilder();
        n = new AtomicInteger(7);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
        sb = new StringBuilder();
        n = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)n);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONIntegerArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Integer i0 = 7;
        Integer i1 = -3;
        Integer i2 = 0;
        Number[] numberArray = new Integer[4];
        numberArray[0] = i0;
        numberArray[1] = i1;
        numberArray[2] = i2;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Integer[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0,null]", (String)sb.toString());
    }

    public void testAppendJSONIntegerArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Integer[] array = new Integer[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Integer[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONIntegerArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Integer[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONInteger() throws Exception {
        StringBuilder sb = new StringBuilder();
        Integer i = 7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Integer)i);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
    }

    public void testAppendJSONIntegerPrimitiveArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        int i0 = 7;
        int i1 = -3;
        int i2 = 0;
        int[] array = new int[]{i0, i1, i2};
        StringBuilderTools.appendJSON((StringBuilder)sb, (int[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0]", (String)sb.toString());
    }

    public void testAppendJSONIntegerPrimitiveArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        int[] array = new int[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (int[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONIntegerPrimitiveArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        int[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONIntegerPrimitive() throws Exception {
        StringBuilder sb = new StringBuilder();
        int i = 7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (int)i);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
    }

    public void testAppendJSONDoubleArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Double d0 = 7.7;
        Double d1 = -3.2;
        Double d2 = 0.0;
        Number[] numberArray = new Double[4];
        numberArray[0] = d0;
        numberArray[1] = d1;
        numberArray[2] = d2;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Double[])array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0,null]", (String)sb.toString());
    }

    public void testAppendJSONDoubleArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Double[] array = new Double[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Double[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONDoubleArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Double[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONDouble() throws Exception {
        StringBuilder sb = new StringBuilder();
        Double d = 7.0;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Double)d);
        StringBuilderToolsTests.assertEquals((String)"7.0", (String)sb.toString());
    }

    public void testAppendJSONDoublePrimitiveArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        double d0 = 7.7;
        double d1 = -3.2;
        double d2 = 0.0;
        double[] array = new double[]{d0, d1, d2};
        StringBuilderTools.appendJSON((StringBuilder)sb, (double[])array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0]", (String)sb.toString());
    }

    public void testAppendJSONDoublePrimitiveArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        double[] array = new double[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (double[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONDoublePrimitiveArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        double[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONDoublePrimitive() throws Exception {
        StringBuilder sb = new StringBuilder();
        double d = 7.0;
        StringBuilderTools.appendJSON((StringBuilder)sb, (double)d);
        StringBuilderToolsTests.assertEquals((String)"7.0", (String)sb.toString());
    }

    public void testAppendJSONByteArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Byte b0 = 7;
        Byte b1 = -3;
        Byte b2 = 0;
        Number[] numberArray = new Byte[4];
        numberArray[0] = b0;
        numberArray[1] = b1;
        numberArray[2] = b2;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Byte[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0,null]", (String)sb.toString());
    }

    public void testAppendJSONByteArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Byte[] array = new Byte[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Byte[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONByteArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Byte[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONByte() throws Exception {
        StringBuilder sb = new StringBuilder();
        Byte b = 7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Byte)b);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
    }

    public void testAppendJSONBytePrimitiveArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        byte b0 = 7;
        byte b1 = -3;
        byte b2 = 0;
        byte[] array = new byte[]{b0, b1, b2};
        StringBuilderTools.appendJSON((StringBuilder)sb, (byte[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0]", (String)sb.toString());
    }

    public void testAppendJSONBytePrimitiveArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        byte[] array = new byte[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (byte[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONBytePrimitiveArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        byte[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONBytePrimitive() throws Exception {
        StringBuilder sb = new StringBuilder();
        byte b = 7;
        StringBuilderTools.appendJSON((StringBuilder)sb, (byte)b);
        StringBuilderToolsTests.assertEquals((String)"7", (String)sb.toString());
    }

    public void testAppendJSONFloatArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Float f0 = Float.valueOf(7.7f);
        Float f1 = Float.valueOf(-3.2f);
        Float f2 = Float.valueOf(0.0f);
        Number[] numberArray = new Float[4];
        numberArray[0] = f0;
        numberArray[1] = f1;
        numberArray[2] = f2;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Float[])array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0,null]", (String)sb.toString());
    }

    public void testAppendJSONFloatArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Float[] array = new Float[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Float[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONFloatArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Float[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONFloat() throws Exception {
        StringBuilder sb = new StringBuilder();
        Float f = Float.valueOf(7.0f);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Float)f);
        StringBuilderToolsTests.assertEquals((String)"7.0", (String)sb.toString());
    }

    public void testAppendJSONFloatPrimitiveArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        float f0 = 7.7f;
        float f1 = -3.2f;
        float f2 = 0.0f;
        float[] array = new float[]{f0, f1, f2};
        StringBuilderTools.appendJSON((StringBuilder)sb, (float[])array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)"[7.7,-3.2,0.0]", (String)sb.toString());
    }

    public void testAppendJSONFloatPrimitiveArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        float[] array = new float[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (float[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONFloatPrimitiveArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        float[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONFloatPrimitive() throws Exception {
        StringBuilder sb = new StringBuilder();
        float f = 7.0f;
        StringBuilderTools.appendJSON((StringBuilder)sb, (float)f);
        StringBuilderToolsTests.assertEquals((String)"7.0", (String)sb.toString());
    }

    public void testAppendJSONLongArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Long l0 = 123456789123456789L;
        Long l1 = -123456789123456789L;
        Long l2 = 0L;
        Number[] numberArray = new Long[4];
        numberArray[0] = l0;
        numberArray[1] = l1;
        numberArray[2] = l2;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Long[])array);
        StringBuilderToolsTests.assertEquals((String)"[123456789123456789,-123456789123456789,0,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[123456789123456789,-123456789123456789,0,null]", (String)sb.toString());
    }

    public void testAppendJSONLongArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Long[] array = new Long[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Long[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONLongArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Long[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONLong() throws Exception {
        StringBuilder sb = new StringBuilder();
        Long l = 123456789123456789L;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Long)l);
        StringBuilderToolsTests.assertEquals((String)"123456789123456789", (String)sb.toString());
    }

    public void testAppendJSONLongPrimitiveArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        long l0 = 123456789123456789L;
        long l1 = -123456789123456789L;
        long l2 = 0L;
        long[] array = new long[]{l0, l1, l2};
        StringBuilderTools.appendJSON((StringBuilder)sb, (long[])array);
        StringBuilderToolsTests.assertEquals((String)"[123456789123456789,-123456789123456789,0]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)"[123456789123456789,-123456789123456789,0]", (String)sb.toString());
    }

    public void testAppendJSONLongPrimitiveArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        long[] array = new long[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (long[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONLongPrimitiveArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        long[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONLongPrimitive() throws Exception {
        StringBuilder sb = new StringBuilder();
        long l = 123456789123456789L;
        StringBuilderTools.appendJSON((StringBuilder)sb, (long)l);
        StringBuilderToolsTests.assertEquals((String)"123456789123456789", (String)sb.toString());
    }

    public void testAppendJSONShortArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        Short s0 = 5;
        Short s1 = -3;
        Short s2 = 0;
        Number[] numberArray = new Short[4];
        numberArray[0] = s0;
        numberArray[1] = s1;
        numberArray[2] = s2;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Short[])array);
        StringBuilderToolsTests.assertEquals((String)"[5,-3,0,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[5,-3,0,null]", (String)sb.toString());
    }

    public void testAppendJSONShortArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Short[] array = new Short[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Short[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONShortArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Short[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONShort() throws Exception {
        StringBuilder sb = new StringBuilder();
        Short s = 5;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Short)s);
        StringBuilderToolsTests.assertEquals((String)"5", (String)sb.toString());
    }

    public void testAppendJSONShortPrimitiveArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        short s0 = 5;
        short s1 = -3;
        short s2 = 0;
        short[] array = new short[]{s0, s1, s2};
        StringBuilderTools.appendJSON((StringBuilder)sb, (short[])array);
        StringBuilderToolsTests.assertEquals((String)"[5,-3,0]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object)array);
        StringBuilderToolsTests.assertEquals((String)"[5,-3,0]", (String)sb.toString());
    }

    public void testAppendJSONShortPrimitiveArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        short[] array = new short[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (short[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONShortPrimitiveArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        short[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONShortPrimitive() throws Exception {
        StringBuilder sb = new StringBuilder();
        short s = 5;
        StringBuilderTools.appendJSON((StringBuilder)sb, (short)s);
        StringBuilderToolsTests.assertEquals((String)"5", (String)sb.toString());
    }

    public void testAppendJSONBigDecimalArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigDecimal bd0 = BigDecimal.valueOf(123456789123456789L, 5);
        BigDecimal bd1 = BigDecimal.valueOf(987654321987654321L, 9);
        BigDecimal bd2 = BigDecimal.valueOf(987654321987654321L, -9);
        Number[] numberArray = new BigDecimal[4];
        numberArray[0] = bd0;
        numberArray[1] = bd1;
        numberArray[2] = bd2;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (BigDecimal[])array);
        StringBuilderToolsTests.assertEquals((String)"[1234567891234.56789,987654321.987654321,9.87654321987654321E+26,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[1234567891234.56789,987654321.987654321,9.87654321987654321E+26,null]", (String)sb.toString());
    }

    public void testAppendJSONBigDecimalArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigDecimal[] array = new BigDecimal[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (BigDecimal[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONBigDecimalArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigDecimal[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONBigDecimal() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigDecimal bd = BigDecimal.valueOf(123456789123456789L, 5);
        StringBuilderTools.appendJSON((StringBuilder)sb, (BigDecimal)bd);
        StringBuilderToolsTests.assertEquals((String)"1234567891234.56789", (String)sb.toString());
    }

    public void testAppendJSONBigIntegerArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigInteger bi0 = BigInteger.valueOf(123456789123456789L);
        BigInteger bi1 = BigInteger.valueOf(987654321987654321L);
        Number[] numberArray = new BigInteger[3];
        numberArray[0] = bi0;
        numberArray[1] = bi1;
        Number[] array = numberArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (BigInteger[])array);
        StringBuilderToolsTests.assertEquals((String)"[123456789123456789,987654321987654321,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[123456789123456789,987654321987654321,null]", (String)sb.toString());
    }

    public void testAppendJSONBigIntegerArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigInteger[] array = new BigInteger[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (BigInteger[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONBigIntegerArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigInteger[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendJSONBigInteger() throws Exception {
        StringBuilder sb = new StringBuilder();
        BigInteger bi = BigInteger.valueOf(123456789123456789L);
        StringBuilderTools.appendJSON((StringBuilder)sb, (BigInteger)bi);
        StringBuilderToolsTests.assertEquals((String)"123456789123456789", (String)sb.toString());
    }

    public void testAppendJSONFraction() throws Exception {
        StringBuilder sb = new StringBuilder();
        Fraction f = Fraction.getReducedFraction((int)2, (int)7);
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number)f);
        StringBuilderToolsTests.assertEquals((String)"{\"denominator\":7,\"numerator\":2}", (String)sb.toString());
    }

    public void testAppendJSONNumberArray() throws Exception {
        StringBuilder sb = new StringBuilder();
        AtomicInteger n0 = new AtomicInteger(7);
        AtomicInteger n1 = new AtomicInteger(-3);
        AtomicInteger n2 = new AtomicInteger(0);
        Object[] objectArray = new Number[4];
        objectArray[0] = n0;
        objectArray[1] = n1;
        objectArray[2] = n2;
        Object[] array = objectArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0,null]", (String)sb.toString());
    }

    public void testAppendJSONNumberArray_mixed() throws Exception {
        StringBuilder sb = new StringBuilder();
        AtomicInteger n0 = new AtomicInteger(7);
        Integer n1 = -3;
        Double n2 = 0.33;
        Object[] objectArray = new Number[4];
        objectArray[0] = n0;
        objectArray[1] = n1;
        objectArray[2] = n2;
        Object[] array = objectArray;
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0.33,null]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[7,-3,0.33,null]", (String)sb.toString());
    }

    public void testAppendJSONNumberArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = new Number[]{};
        StringBuilderTools.appendJSON((StringBuilder)sb, (Number[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
        sb = new StringBuilder();
        StringBuilderTools.appendJSON((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendJSONNumberArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Number[] array = null;
        StringBuilderTools.appendJSON((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendObjectArray_null() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = null;
        StringBuilderTools.append((StringBuilder)sb, array);
        StringBuilderToolsTests.assertEquals((String)"null", (String)sb.toString());
    }

    public void testAppendObjectArray_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = new Object[]{};
        StringBuilderTools.append((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendObjectArray_one() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = new Object[]{"foo"};
        StringBuilderTools.append((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[foo]", (String)sb.toString());
    }

    public void testAppendObjectArray_multiple() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] array = new Object[]{"foo", "bar", "baz"};
        StringBuilderTools.append((StringBuilder)sb, (Object[])array);
        StringBuilderToolsTests.assertEquals((String)"[foo, bar, baz]", (String)sb.toString());
    }

    public void testAppendIterable_empty() throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterable iterable = IterableTools.iterable((Object[])new Object[0]);
        StringBuilderTools.append((StringBuilder)sb, (Iterable)iterable);
        StringBuilderToolsTests.assertEquals((String)"[]", (String)sb.toString());
    }

    public void testAppendIterable_one() throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterable iterable = IterableTools.iterable((Object[])new Object[]{"foo"});
        StringBuilderTools.append((StringBuilder)sb, (Iterable)iterable);
        StringBuilderToolsTests.assertEquals((String)"[foo]", (String)sb.toString());
    }

    public void testAppendIterable_multiple() throws Exception {
        StringBuilder sb = new StringBuilder();
        Iterable iterable = IterableTools.iterable((Object[])new Object[]{"foo", "bar", "baz"});
        StringBuilderTools.append((StringBuilder)sb, (Iterable)iterable);
        StringBuilderToolsTests.assertEquals((String)"[foo, bar, baz]", (String)sb.toString());
    }

    public void testAppendHashCodeToString() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object object = new Object();
        StringBuilderTools.appendHashCodeToString((StringBuilder)sb, (Object)object);
        String string = sb.toString();
        String prefix = "Object[";
        StringBuilderToolsTests.assertTrue((boolean)string.startsWith(prefix));
        StringBuilderToolsTests.assertTrue((boolean)string.endsWith("]"));
        int i = prefix.length();
        while (i < string.length() - 1) {
            char c = string.charAt(i);
            StringBuilderToolsTests.assertTrue((c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c == '-' ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testAppendIdentityToString() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object object = new Object();
        StringBuilderTools.appendIdentityToString((StringBuilder)sb, (Object)object);
        String string = sb.toString();
        String prefix = "java.lang.Object@";
        StringBuilderToolsTests.assertTrue((boolean)string.startsWith(prefix));
        int i = prefix.length();
        while (i < string.length()) {
            char c = string.charAt(i);
            StringBuilderToolsTests.assertTrue((c >= '0' && c <= '9' || c >= 'a' && c <= 'f' ? 1 : 0) != 0);
            ++i;
        }
    }
}

